/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import cats.Functor;
import cats.Semigroupal;
import cats.free.Free;
import cats.free.Free$;
import cats.syntax.package;
import doodle.core.Angle;
import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Vec;
import doodle.core.Vec$;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.random;
import doodle.syntax.package;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DiffusionLimitedAggregation$ {
    public static final DiffusionLimitedAggregation$ MODULE$ = new DiffusionLimitedAggregation$();
    private static final Point start = Point$.MODULE$.zero();
    private static final Free<random.RandomOp, Tuple2<Point, Vec>> seed = random.Random$.MODULE$.double().map((Function1 & Serializable)t -> DiffusionLimitedAggregation$.$anonfun$seed$1(BoxesRunTime.unboxToDouble((Object)t)));
    private static final Free<random.RandomOp, List<Point>> stuckStart = random.Random$.MODULE$.always((Object)new .colon.colon((Object)Point$.MODULE$.cartesian(0.0, 0.0), (List)new .colon.colon((Object)Point$.MODULE$.cartesian(0.0, 50.0), (List)new .colon.colon((Object)Point$.MODULE$.cartesian(0.0, -50.0), (List)Nil$.MODULE$))));
    private static final double stickRadius = 5.0;
    private static final Free<random.RandomOp, Image> smoke;
    private static final Free<random.RandomOp, Image> image;

    static {
        Free alpha = random.Random$.MODULE$.normal(0.5, 0.1);
        Free hue = random.Random$.MODULE$.double().map((Function1 & Serializable)h -> DiffusionLimitedAggregation$.$anonfun$smoke$1(BoxesRunTime.unboxToDouble((Object)h)));
        Free saturation = random.Random$.MODULE$.double().map((Function1)(JFunction1.mcDD.sp & Serializable)s -> s * 0.8);
        Free lightness = random.Random$.MODULE$.normal(0.4, 0.1);
        Free color = (Free)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4((Object)hue, (Object)saturation, (Object)lightness, (Object)alpha)).mapN((Function4 & Serializable)(h, s, l, a) -> Color$.MODULE$.hsla(h, BoxesRunTime.unboxToDouble((Object)s), BoxesRunTime.unboxToDouble((Object)l), BoxesRunTime.unboxToDouble((Object)a)), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
        Free c = random.Random$.MODULE$.normal(1.0, 1.0).map((Function1 & Serializable)r -> Image$.MODULE$.circle(Math.abs(BoxesRunTime.unboxToDouble((Object)r))));
        smoke = (Free)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)c, (Object)color)).mapN((Function2 & Serializable)(circle, line) -> circle.strokeColor((Color)line).noFill(), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
        image = MODULE$.makeImage(1000, 1000);
    }

    public Free<random.RandomOp, Point> brownianMotion(Point start, Vec drift) {
        return this.jitter(start).map((Function1 & Serializable)pt -> pt.$plus(drift));
    }

    public Free<random.RandomOp, Point> jitter(Point point) {
        Free noise = random.Random$.MODULE$.normal(0.0, 10.0);
        return (Free)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)noise, (Object)noise)).mapN((Function2 & Serializable)(dx, dy) -> Point$.MODULE$.cartesian(point.x() + BoxesRunTime.unboxToDouble((Object)dx), point.y() + BoxesRunTime.unboxToDouble((Object)dy)), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
    }

    public Point start() {
        return start;
    }

    public Free<random.RandomOp, Tuple2<Point, Vec>> seed() {
        return seed;
    }

    public Free<random.RandomOp, List<Point>> stuckStart() {
        return stuckStart;
    }

    public double stickRadius() {
        return stickRadius;
    }

    public double distance(Point pt1, Point pt2) {
        return pt1.$minus(pt2).length();
    }

    public boolean isStuck(Point point, List<Point> stuck) {
        return stuck.exists((Function1 & Serializable)pt -> BoxesRunTime.boxToBoolean((boolean)DiffusionLimitedAggregation$.$anonfun$isStuck$1(point, pt)));
    }

    public Free<random.RandomOp, Option<Point>> walk(int maxSteps, List<Point> stuck) {
        return this.seed().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Point start = (Point)tuple2._1();
                Vec drift = (Vec)tuple2._2();
                return DiffusionLimitedAggregation$.iter$1(maxSteps, random.Random$.MODULE$.always((Object)start), drift, stuck);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Free<random.RandomOp, List<Point>> dla(int nParticles, int maxSteps, Free<random.RandomOp, List<Point>> stuck) {
        while (true) {
            Free nowStuck;
            int n = nParticles--;
            switch (n) {
                case 0: {
                    return stuck;
                }
            }
            stuck = nowStuck = stuck.flatMap((Function1 & Serializable)s -> MODULE$.walk(maxSteps, (List<Point>)s).map((Function1 & Serializable)opt -> {
                Option option = opt;
                if (option instanceof Some) {
                    Point pt;
                    Some some = (Some)option;
                    Point point = pt = (Point)some.value();
                    return s.$colon$colon((Object)point);
                }
                if (None$.MODULE$.equals(option)) {
                    return s;
                }
                throw new MatchError((Object)option);
            }));
        }
    }

    public Free<random.RandomOp, Image> smoke() {
        return smoke;
    }

    public Free<random.RandomOp, Image> makeImage(int nParticles, int maxSteps) {
        return this.dla(nParticles, maxSteps, this.stuckStart()).flatMap((Function1 & Serializable)pts -> (Free)pts.foldLeft((Object)random.Random$.MODULE$.always((Object)Image$.MODULE$.empty()), (Function2 & Serializable)(accum, pt) -> accum.flatMap((Function1 & Serializable)imgs -> MODULE$.smoke().map((Function1 & Serializable)img -> img.at(pt.toVec()).on((Image)imgs)))));
    }

    public Free<random.RandomOp, Image> image() {
        return image;
    }

    public static final /* synthetic */ Tuple2 $anonfun$seed$1(double t) {
        Angle angle = package.all$.MODULE$.AngleDoubleOps(t).turns();
        Point start = Point$.MODULE$.polar(200.0, angle);
        Vec drift = Vec$.MODULE$.polar(3.0, angle.$plus(package.all$.MODULE$.AngleDoubleOps(0.5).turns()).normalize());
        return new Tuple2((Object)start, (Object)drift);
    }

    public static final /* synthetic */ boolean $anonfun$isStuck$1(Point point$2, Point pt) {
        return MODULE$.distance(point$2, pt) < MODULE$.stickRadius();
    }

    private static final Free iter$1(int step, Free point, Vec drift, List stuck$1) {
        int n = step;
        switch (n) {
            case 0: {
                return random.Random$.MODULE$.always((Object)None$.MODULE$);
            }
        }
        return point.flatMap((Function1 & Serializable)pt -> {
            if (MODULE$.isStuck((Point)pt, (List<Point>)stuck$1)) {
                return random.Random$.MODULE$.always((Object)new Some(pt));
            }
            return DiffusionLimitedAggregation$.iter$1(step - 1, MODULE$.brownianMotion((Point)pt, drift), drift, stuck$1);
        });
    }

    public static final /* synthetic */ Angle $anonfun$smoke$1(double h) {
        return package.all$.MODULE$.AngleDoubleOps(h * 0.1 + 0.6).turns();
    }

    private DiffusionLimitedAggregation$() {
    }
}

