/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import cats.instances.package;
import cats.kernel.Semigroup;
import doodle.algebra.Algebra;
import doodle.algebra.Picture;
import doodle.algebra.Picture$;
import doodle.core.Angle;
import doodle.core.ClosedPath$;
import doodle.core.Color;
import doodle.core.Gradient;
import doodle.core.OpenPath$;
import doodle.core.PathElement;
import doodle.core.PathElement$;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.image.Image;
import doodle.image.Image$Elements$Empty$;
import doodle.image.Path;
import doodle.language.Basic;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Image$
implements Serializable {
    public static final Image$ MODULE$ = new Image$();
    private static final Image empty = Image$Elements$Empty$.MODULE$;
    private static volatile byte bitmap$init$0 = (byte)(bitmap$init$0 | 2);

    public Path closedPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.ClosedPath((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Path openPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.OpenPath((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Image line(double x, double y) {
        double startX = -x / (double)2;
        double startY = -y / (double)2;
        double endX = x / (double)2;
        double endY = y / (double)2;
        return this.openPath((Seq<PathElement>)((Seq)new .colon.colon((Object)PathElement$.MODULE$.moveTo(startX, startY), (List)new .colon.colon((Object)PathElement$.MODULE$.lineTo(endX, endY), (List)Nil$.MODULE$))));
    }

    public Image circle(double diameter) {
        return new Image.Elements.Circle(diameter);
    }

    public Image rectangle(double width, double height) {
        return new Image.Elements.Rectangle(width, height);
    }

    public Image square(double side) {
        return this.rectangle(side, side);
    }

    public Image regularPolygon(int sides, double radius, Angle angle) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.regularPolygon(sides, radius, angle));
    }

    public Image star(int points, double outerRadius, double innerRadius, Angle angle) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.star(points, outerRadius, innerRadius, angle));
    }

    public Image rightArrow(double width, double height) {
        List path = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(width / (double)2, 0.0), PathElement$.MODULE$.lineTo(0.0, height / (double)2), PathElement$.MODULE$.lineTo(0.0, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height / (double)2), PathElement$.MODULE$.lineTo(width / (double)2, 0.0)}));
        return this.closedPath((Seq<PathElement>)path);
    }

    public Image roundedRectangle(double width, double height, double radius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.roundedRectangle(width, height, radius));
    }

    public Image triangle(double width, double height) {
        return new Image.Elements.Triangle(width, height);
    }

    public Path interpolatingSpline(Seq<Point> points) {
        return this.catmulRom(points, this.catmulRom$default$2());
    }

    public Path catmulRom(Seq<Point> points, double tension) {
        return this.openPath((Seq<PathElement>)PathElement$.MODULE$.catmulRom(points, tension));
    }

    public double catmulRom$default$2() {
        return 0.5;
    }

    public Image empty() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/Image.scala: 259");
        }
        return empty;
    }

    public <Alg extends Basic<Object>, F> Picture<Alg, F, BoxedUnit> compile(Image image) {
        return Picture$.MODULE$.apply((Function1 & Serializable)algebra -> {
            Object object;
            Image image = image;
            if (image instanceof Image.Elements.OpenPath) {
                Image.Elements.OpenPath openPath = (Image.Elements.OpenPath)image;
                List<PathElement> elements = openPath.elements();
                object = algebra.path(OpenPath$.MODULE$.apply(elements));
            } else if (image instanceof Image.Elements.ClosedPath) {
                Image.Elements.ClosedPath closedPath = (Image.Elements.ClosedPath)image;
                List<PathElement> elements = closedPath.elements();
                object = algebra.path(ClosedPath$.MODULE$.apply(elements));
            } else if (image instanceof Image.Elements.Circle) {
                Image.Elements.Circle circle = (Image.Elements.Circle)image;
                double d = circle.d();
                object = algebra.circle(d);
            } else if (image instanceof Image.Elements.Rectangle) {
                Image.Elements.Rectangle rectangle = (Image.Elements.Rectangle)image;
                double w = rectangle.w();
                double h = rectangle.h();
                object = algebra.rectangle(w, h);
            } else if (image instanceof Image.Elements.Triangle) {
                Image.Elements.Triangle triangle = (Image.Elements.Triangle)image;
                double w = triangle.w();
                double h = triangle.h();
                object = algebra.triangle(w, h);
            } else if (image instanceof Image.Elements.Beside) {
                Image.Elements.Beside beside = (Image.Elements.Beside)image;
                Image l = beside.l();
                Image r = beside.r();
                object = algebra.beside(MODULE$.compile(l).apply((Algebra)algebra), MODULE$.compile(r).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
            } else if (image instanceof Image.Elements.Above) {
                Image.Elements.Above above = (Image.Elements.Above)image;
                Image l = above.l();
                Image r = above.r();
                object = algebra.above(MODULE$.compile(l).apply((Algebra)algebra), MODULE$.compile(r).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
            } else if (image instanceof Image.Elements.On) {
                Image.Elements.On on = (Image.Elements.On)image;
                Image t = on.t();
                Image b = on.b();
                object = algebra.on(MODULE$.compile(t).apply((Algebra)algebra), MODULE$.compile(b).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
            } else if (image instanceof Image.Elements.At) {
                Image.Elements.At at = (Image.Elements.At)image;
                Image image2 = at.image();
                double x = at.x();
                double y = at.y();
                object = algebra.at(MODULE$.compile(image2).apply((Algebra)algebra), x, y);
            } else if (image instanceof Image.Elements.Transform) {
                Image.Elements.Transform transform = (Image.Elements.Transform)image;
                Transform tx = transform.tx();
                Image i = transform.i();
                object = algebra.transform(MODULE$.compile(i).apply((Algebra)algebra), tx);
            } else if (image instanceof Image.Elements.StrokeWidth) {
                Image.Elements.StrokeWidth strokeWidth = (Image.Elements.StrokeWidth)image;
                Image image3 = strokeWidth.image();
                double width = strokeWidth.width();
                object = algebra.strokeWidth(MODULE$.compile(image3).apply((Algebra)algebra), width);
            } else if (image instanceof Image.Elements.StrokeColor) {
                Image.Elements.StrokeColor strokeColor = (Image.Elements.StrokeColor)image;
                Image image4 = strokeColor.image();
                Color color = strokeColor.color();
                object = algebra.strokeColor(MODULE$.compile(image4).apply((Algebra)algebra), color);
            } else if (image instanceof Image.Elements.FillColor) {
                Image.Elements.FillColor fillColor = (Image.Elements.FillColor)image;
                Image image5 = fillColor.image();
                Color color = fillColor.color();
                object = algebra.fillColor(MODULE$.compile(image5).apply((Algebra)algebra), color);
            } else if (image instanceof Image.Elements.FillGradient) {
                Image.Elements.FillGradient fillGradient = (Image.Elements.FillGradient)image;
                Image image6 = fillGradient.image();
                Gradient gradient = fillGradient.gradient();
                object = algebra.fillGradient(MODULE$.compile(image6).apply((Algebra)algebra), gradient);
            } else if (image instanceof Image.Elements.NoStroke) {
                Image.Elements.NoStroke noStroke = (Image.Elements.NoStroke)image;
                Image image7 = noStroke.image();
                object = algebra.noStroke(MODULE$.compile(image7).apply((Algebra)algebra));
            } else if (image instanceof Image.Elements.NoFill) {
                Image.Elements.NoFill noFill = (Image.Elements.NoFill)image;
                Image image8 = noFill.image();
                object = algebra.noFill(MODULE$.compile(image8).apply((Algebra)algebra));
            } else if (image instanceof Image.Elements.Debug) {
                Image.Elements.Debug debug = (Image.Elements.Debug)image;
                Image image9 = debug.image();
                Color color = debug.color();
                object = algebra.debug(MODULE$.compile(image9).apply((Algebra)algebra), color);
            } else if (Image$Elements$Empty$.MODULE$.equals(image)) {
                object = algebra.empty();
            } else {
                throw new MatchError((Object)image);
            }
            return object;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Image$.class);
    }

    private Image$() {
    }
}

