package doodle
package image
package examples

import doodle.core._
import doodle.core.font._
import Image._

object BoxesAndArrows {
  val size = 100.0

  val spacer = rectangle(size * 0.2, size).noFill.noStroke

  val box =
    roundedRectangle(size, size, size * .12).strokeWidth(size * .12).noFill

  val font = Font(FontFamily.sansSerif, FontStyle.normal, FontWeight.normal, FontSize.points((size / 2.0).toInt))
  // val equals = text("=").font(font)

  val c = circle(size * 0.3).fillColor(Color.black)
  val t = triangle(size * 0.6, size * 0.6).fillColor(Color.black)

  val circleBox = box on c
  val triangleBox = box on t
  val circleAndTriangleBox = box on (circle(size * 0.15) beside triangle(
    size * 0.3,
    size * 0.3))

  val circleToTriangle =
    c beside spacer beside rightArrow(size, size).fillColor(Color.black) beside spacer beside t

  val circleToTriangleBox =
    c beside spacer beside rightArrow(size, size).fillColor(Color.black) beside spacer beside triangleBox

  def besideWithSpace(elts: List[Image]): Image =
    elts.foldLeft(Image.empty) { (accum, elt) =>
      accum beside spacer beside elt
    }

  val map: Image =
    besideWithSpace(
      List(
        circleBox, /*text("map").font(font),*/ circleToTriangle,
        /*equals,*/ triangleBox
      )
    )

  val applicative: Image =
    besideWithSpace(
      List(
        circleBox, /* text("|@|").font(font), */ triangleBox,
        /*equals,*/ circleAndTriangleBox
      )
    )

  val flatMap: Image =
    besideWithSpace(
      List(
        circleBox, /*text("flatMap").font(font),*/ circleToTriangleBox,
        /*equals,*/ triangleBox
      )
    )
}
