/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import cats.instances.package;
import cats.kernel.Semigroup;
import doodle.algebra.Picture;
import doodle.core.ClosedPath;
import doodle.core.ClosedPath$;
import doodle.core.Color;
import doodle.core.Gradient;
import doodle.core.OpenPath;
import doodle.core.OpenPath$;
import doodle.core.PathElement;
import doodle.core.PathElement$;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.core.font.Font;
import doodle.image.Image;
import doodle.image.Image$Elements$Empty$;
import doodle.image.Path;
import doodle.language.Basic;
import java.io.Serializable;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Image$
implements Serializable {
    public static final Image$ MODULE$ = new Image$();
    private static final Image empty = Image$Elements$Empty$.MODULE$;

    public Path closedPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.ClosedPath((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Path openPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.OpenPath((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Path path(ClosedPath path) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.ClosedPath((List<PathElement>)((List)path.elements().$plus$colon((Object)pathElement)));
    }

    public Path path(OpenPath path) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.OpenPath((List<PathElement>)((List)path.elements().$plus$colon((Object)pathElement)));
    }

    public Image text(String characters) {
        return new Image.Elements.Text(characters);
    }

    public Image line(double x, double y) {
        double startX = -x / (double)2;
        double startY = -y / (double)2;
        double endX = x / (double)2;
        double endY = y / (double)2;
        return this.openPath((Seq<PathElement>)new .colon.colon((Object)PathElement$.MODULE$.moveTo(startX, startY), (List)new .colon.colon((Object)PathElement$.MODULE$.lineTo(endX, endY), (List)Nil$.MODULE$)));
    }

    public Image circle(double diameter) {
        return new Image.Elements.Circle(diameter);
    }

    public Image rectangle(double width, double height) {
        return new Image.Elements.Rectangle(width, height);
    }

    public Image square(double side) {
        return this.rectangle(side, side);
    }

    public Image regularPolygon(int sides, double radius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.regularPolygon(sides, radius));
    }

    public Image star(int points, double outerRadius, double innerRadius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.star(points, outerRadius, innerRadius));
    }

    public Image rightArrow(double width, double height) {
        List path = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(width / (double)2, 0.0), PathElement$.MODULE$.lineTo(0.0, height / (double)2), PathElement$.MODULE$.lineTo(0.0, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height / (double)2), PathElement$.MODULE$.lineTo(width / (double)2, 0.0)}));
        return this.closedPath((Seq<PathElement>)path);
    }

    public Image roundedRectangle(double width, double height, double radius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.roundedRectangle(width, height, radius));
    }

    public Image equilateralTriangle(double width) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.equilateralTriangle(width));
    }

    public Image triangle(double width, double height) {
        return new Image.Elements.Triangle(width, height);
    }

    public Path interpolatingSpline(Seq<Point> points) {
        return this.catmulRom(points, this.catmulRom$default$2());
    }

    public Path catmulRom(Seq<Point> points, double tension) {
        return this.openPath((Seq<PathElement>)PathElement$.MODULE$.catmulRom(points, tension));
    }

    public double catmulRom$default$2() {
        return 0.5;
    }

    public Image empty() {
        return empty;
    }

    public <Alg extends Basic> Picture<Alg, BoxedUnit> compile(Image image) {
        return new Picture<Alg, BoxedUnit>(image){
            private final Image image$1;

            public Object apply(Alg algebra) {
                Image image = this.image$1;
                if (image instanceof Image.Elements.OpenPath) {
                    Image.Elements.OpenPath openPath = (Image.Elements.OpenPath)image;
                    List<PathElement> elements = openPath.elements();
                    return algebra.path(OpenPath$.MODULE$.apply(elements));
                }
                if (image instanceof Image.Elements.ClosedPath) {
                    Image.Elements.ClosedPath closedPath = (Image.Elements.ClosedPath)image;
                    List<PathElement> elements = closedPath.elements();
                    return algebra.path(ClosedPath$.MODULE$.apply(elements));
                }
                if (image instanceof Image.Elements.Text) {
                    Image.Elements.Text text = (Image.Elements.Text)image;
                    String t = text.get();
                    return algebra.text(t);
                }
                if (image instanceof Image.Elements.Font) {
                    Image.Elements.Font font = (Image.Elements.Font)image;
                    Image image2 = font.image();
                    Font f = font.font();
                    return algebra.font(Image$.MODULE$.compile(image2).apply(algebra), f);
                }
                if (image instanceof Image.Elements.Circle) {
                    Image.Elements.Circle circle = (Image.Elements.Circle)image;
                    double d = circle.d();
                    return algebra.circle(d);
                }
                if (image instanceof Image.Elements.Rectangle) {
                    Image.Elements.Rectangle rectangle = (Image.Elements.Rectangle)image;
                    double w = rectangle.w();
                    double h = rectangle.h();
                    return algebra.rectangle(w, h);
                }
                if (image instanceof Image.Elements.Triangle) {
                    Image.Elements.Triangle triangle = (Image.Elements.Triangle)image;
                    double w = triangle.w();
                    double h = triangle.h();
                    return algebra.triangle(w, h);
                }
                if (image instanceof Image.Elements.Beside) {
                    Image.Elements.Beside beside = (Image.Elements.Beside)image;
                    Image l = beside.l();
                    Image r = beside.r();
                    return algebra.beside(Image$.MODULE$.compile(l).apply(algebra), Image$.MODULE$.compile(r).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.Above) {
                    Image.Elements.Above above = (Image.Elements.Above)image;
                    Image l = above.l();
                    Image r = above.r();
                    return algebra.above(Image$.MODULE$.compile(l).apply(algebra), Image$.MODULE$.compile(r).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.On) {
                    Image.Elements.On on = (Image.Elements.On)image;
                    Image t = on.t();
                    Image b = on.b();
                    return algebra.on(Image$.MODULE$.compile(t).apply(algebra), Image$.MODULE$.compile(b).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.At) {
                    Image.Elements.At at = (Image.Elements.At)image;
                    Image image3 = at.image();
                    double x = at.x();
                    double y = at.y();
                    return algebra.at(Image$.MODULE$.compile(image3).apply(algebra), x, y);
                }
                if (image instanceof Image.Elements.Transform) {
                    Image.Elements.Transform transform = (Image.Elements.Transform)image;
                    Transform tx = transform.tx();
                    Image i = transform.i();
                    return algebra.transform(Image$.MODULE$.compile(i).apply(algebra), tx);
                }
                if (image instanceof Image.Elements.StrokeWidth) {
                    Image.Elements.StrokeWidth strokeWidth = (Image.Elements.StrokeWidth)image;
                    Image image4 = strokeWidth.image();
                    double width = strokeWidth.width();
                    return algebra.strokeWidth(Image$.MODULE$.compile(image4).apply(algebra), width);
                }
                if (image instanceof Image.Elements.StrokeColor) {
                    Image.Elements.StrokeColor strokeColor = (Image.Elements.StrokeColor)image;
                    Image image5 = strokeColor.image();
                    Color color = strokeColor.color();
                    return algebra.strokeColor(Image$.MODULE$.compile(image5).apply(algebra), color);
                }
                if (image instanceof Image.Elements.FillColor) {
                    Image.Elements.FillColor fillColor = (Image.Elements.FillColor)image;
                    Image image6 = fillColor.image();
                    Color color = fillColor.color();
                    return algebra.fillColor(Image$.MODULE$.compile(image6).apply(algebra), color);
                }
                if (image instanceof Image.Elements.FillGradient) {
                    Image.Elements.FillGradient fillGradient = (Image.Elements.FillGradient)image;
                    Image image7 = fillGradient.image();
                    Gradient gradient = fillGradient.gradient();
                    return algebra.fillGradient(Image$.MODULE$.compile(image7).apply(algebra), gradient);
                }
                if (image instanceof Image.Elements.NoStroke) {
                    Image.Elements.NoStroke noStroke = (Image.Elements.NoStroke)image;
                    Image image8 = noStroke.image();
                    return algebra.noStroke(Image$.MODULE$.compile(image8).apply(algebra));
                }
                if (image instanceof Image.Elements.NoFill) {
                    Image.Elements.NoFill noFill = (Image.Elements.NoFill)image;
                    Image image9 = noFill.image();
                    return algebra.noFill(Image$.MODULE$.compile(image9).apply(algebra));
                }
                if (image instanceof Image.Elements.Debug) {
                    Image.Elements.Debug debug = (Image.Elements.Debug)image;
                    Image image10 = debug.image();
                    Color color = debug.color();
                    return algebra.debug(Image$.MODULE$.compile(image10).apply(algebra), color);
                }
                if (Image$Elements$Empty$.MODULE$.equals(image)) {
                    return algebra.empty();
                }
                throw new MatchError((Object)image);
            }
            {
                this.image$1 = image$1;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Image$.class);
    }

    private Image$() {
    }
}

