/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import cats.instances.package;
import cats.kernel.Semigroup;
import doodle.algebra.Picture;
import doodle.core.Cap;
import doodle.core.ClosedPath;
import doodle.core.ClosedPath$;
import doodle.core.Color;
import doodle.core.Gradient;
import doodle.core.Join;
import doodle.core.OpenPath;
import doodle.core.OpenPath$;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.core.font.Font;
import doodle.image.Image;
import doodle.image.Image$Elements$Empty$;
import doodle.language.Basic;
import java.io.Serializable;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class Image$
implements Serializable {
    public static final Image$ MODULE$ = new Image$();
    private static final Image empty = Image$Elements$Empty$.MODULE$;

    public Image path(ClosedPath path) {
        return new Image.Elements.ClosedPath(path);
    }

    public Image path(OpenPath path) {
        return new Image.Elements.OpenPath(path);
    }

    public Image text(String characters) {
        return new Image.Elements.Text(characters);
    }

    public Image line(double x, double y) {
        return this.path(OpenPath$.MODULE$.line(x, y));
    }

    public Image circle(double diameter) {
        return new Image.Elements.Circle(diameter);
    }

    public Image rectangle(double width, double height) {
        return new Image.Elements.Rectangle(width, height);
    }

    public Image square(double side) {
        return this.rectangle(side, side);
    }

    public Image regularPolygon(int sides, double radius) {
        return this.path(ClosedPath$.MODULE$.regularPolygon(sides, radius));
    }

    public Image star(int points, double outerRadius, double innerRadius) {
        return this.path(ClosedPath$.MODULE$.star(points, outerRadius, innerRadius));
    }

    public Image rightArrow(double width, double height) {
        return this.path(ClosedPath$.MODULE$.rightArrow(width, height));
    }

    public Image roundedRectangle(double width, double height, double radius) {
        return this.path(ClosedPath$.MODULE$.roundedRectangle(width, height, radius));
    }

    public Image equilateralTriangle(double width) {
        return this.path(ClosedPath$.MODULE$.equilateralTriangle(width));
    }

    public Image triangle(double width, double height) {
        return new Image.Elements.Triangle(width, height);
    }

    public Image interpolatingSpline(Seq<Point> points) {
        return this.catmulRom(points, this.catmulRom$default$2());
    }

    public Image catmulRom(Seq<Point> points, double tension) {
        return this.path(OpenPath$.MODULE$.catmulRom(points, tension));
    }

    public double catmulRom$default$2() {
        return 0.5;
    }

    public Image empty() {
        return empty;
    }

    public <Alg extends Basic> Picture<Alg, BoxedUnit> compile(Image image) {
        return new Picture<Alg, BoxedUnit>(image){
            private final Image image$1;

            public Object apply(Alg algebra) {
                Image image = this.image$1;
                if (image instanceof Image.Elements.OpenPath) {
                    Image.Elements.OpenPath openPath = (Image.Elements.OpenPath)image;
                    OpenPath path = openPath.path();
                    return algebra.path(path);
                }
                if (image instanceof Image.Elements.ClosedPath) {
                    Image.Elements.ClosedPath closedPath = (Image.Elements.ClosedPath)image;
                    ClosedPath path = closedPath.path();
                    return algebra.path(path);
                }
                if (image instanceof Image.Elements.Text) {
                    Image.Elements.Text text = (Image.Elements.Text)image;
                    String t = text.get();
                    return algebra.text(t);
                }
                if (image instanceof Image.Elements.Font) {
                    Image.Elements.Font font = (Image.Elements.Font)image;
                    Image image2 = font.image();
                    Font f = font.font();
                    return algebra.font(Image$.MODULE$.compile(image2).apply(algebra), f);
                }
                if (image instanceof Image.Elements.Circle) {
                    Image.Elements.Circle circle = (Image.Elements.Circle)image;
                    double d = circle.d();
                    return algebra.circle(d);
                }
                if (image instanceof Image.Elements.Rectangle) {
                    Image.Elements.Rectangle rectangle = (Image.Elements.Rectangle)image;
                    double w = rectangle.w();
                    double h = rectangle.h();
                    return algebra.rectangle(w, h);
                }
                if (image instanceof Image.Elements.Triangle) {
                    Image.Elements.Triangle triangle = (Image.Elements.Triangle)image;
                    double w = triangle.w();
                    double h = triangle.h();
                    return algebra.triangle(w, h);
                }
                if (image instanceof Image.Elements.Beside) {
                    Image.Elements.Beside beside = (Image.Elements.Beside)image;
                    Image l = beside.l();
                    Image r = beside.r();
                    return algebra.beside(Image$.MODULE$.compile(l).apply(algebra), Image$.MODULE$.compile(r).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.Above) {
                    Image.Elements.Above above = (Image.Elements.Above)image;
                    Image l = above.l();
                    Image r = above.r();
                    return algebra.above(Image$.MODULE$.compile(l).apply(algebra), Image$.MODULE$.compile(r).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.On) {
                    Image.Elements.On on = (Image.Elements.On)image;
                    Image t = on.t();
                    Image b = on.b();
                    return algebra.on(Image$.MODULE$.compile(t).apply(algebra), Image$.MODULE$.compile(b).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.At) {
                    Image.Elements.At at = (Image.Elements.At)image;
                    Image image3 = at.image();
                    double x = at.x();
                    double y = at.y();
                    return algebra.at(Image$.MODULE$.compile(image3).apply(algebra), x, y);
                }
                if (image instanceof Image.Elements.Margin) {
                    Image.Elements.Margin margin = (Image.Elements.Margin)image;
                    Image image4 = margin.i();
                    double top = margin.top();
                    double right = margin.right();
                    double bottom = margin.bottom();
                    double left = margin.left();
                    return algebra.margin(Image$.MODULE$.compile(image4).apply(algebra), top, right, bottom, left);
                }
                if (image instanceof Image.Elements.OriginAt) {
                    Image.Elements.OriginAt originAt = (Image.Elements.OriginAt)image;
                    Image image5 = originAt.image();
                    double x = originAt.x();
                    double y = originAt.y();
                    return algebra.originAt(Image$.MODULE$.compile(image5).apply(algebra), x, y);
                }
                if (image instanceof Image.Elements.Transform) {
                    Image.Elements.Transform transform = (Image.Elements.Transform)image;
                    Transform tx = transform.tx();
                    Image i = transform.i();
                    return algebra.transform(Image$.MODULE$.compile(i).apply(algebra), tx);
                }
                if (image instanceof Image.Elements.StrokeWidth) {
                    Image.Elements.StrokeWidth strokeWidth = (Image.Elements.StrokeWidth)image;
                    Image image6 = strokeWidth.image();
                    double width = strokeWidth.width();
                    return algebra.strokeWidth(Image$.MODULE$.compile(image6).apply(algebra), width);
                }
                if (image instanceof Image.Elements.StrokeColor) {
                    Image.Elements.StrokeColor strokeColor = (Image.Elements.StrokeColor)image;
                    Image image7 = strokeColor.image();
                    Color color = strokeColor.color();
                    return algebra.strokeColor(Image$.MODULE$.compile(image7).apply(algebra), color);
                }
                if (image instanceof Image.Elements.StrokeCap) {
                    Image.Elements.StrokeCap strokeCap = (Image.Elements.StrokeCap)image;
                    Image image8 = strokeCap.image();
                    Cap cap = strokeCap.cap();
                    return algebra.strokeCap(Image$.MODULE$.compile(image8).apply(algebra), cap);
                }
                if (image instanceof Image.Elements.StrokeJoin) {
                    Image.Elements.StrokeJoin strokeJoin = (Image.Elements.StrokeJoin)image;
                    Image image9 = strokeJoin.image();
                    Join join = strokeJoin.join();
                    return algebra.strokeJoin(Image$.MODULE$.compile(image9).apply(algebra), join);
                }
                if (image instanceof Image.Elements.StrokeDash) {
                    Image.Elements.StrokeDash strokeDash = (Image.Elements.StrokeDash)image;
                    Image image10 = strokeDash.image();
                    Iterable<Object> pattern = strokeDash.pattern();
                    return algebra.strokeDash(Image$.MODULE$.compile(image10).apply(algebra), pattern);
                }
                if (image instanceof Image.Elements.FillColor) {
                    Image.Elements.FillColor fillColor = (Image.Elements.FillColor)image;
                    Image image11 = fillColor.image();
                    Color color = fillColor.color();
                    return algebra.fillColor(Image$.MODULE$.compile(image11).apply(algebra), color);
                }
                if (image instanceof Image.Elements.FillGradient) {
                    Image.Elements.FillGradient fillGradient = (Image.Elements.FillGradient)image;
                    Image image12 = fillGradient.image();
                    Gradient gradient = fillGradient.gradient();
                    return algebra.fillGradient(Image$.MODULE$.compile(image12).apply(algebra), gradient);
                }
                if (image instanceof Image.Elements.NoStroke) {
                    Image.Elements.NoStroke noStroke = (Image.Elements.NoStroke)image;
                    Image image13 = noStroke.image();
                    return algebra.noStroke(Image$.MODULE$.compile(image13).apply(algebra));
                }
                if (image instanceof Image.Elements.NoFill) {
                    Image.Elements.NoFill noFill = (Image.Elements.NoFill)image;
                    Image image14 = noFill.image();
                    return algebra.noFill(Image$.MODULE$.compile(image14).apply(algebra));
                }
                if (image instanceof Image.Elements.Debug) {
                    Image.Elements.Debug debug = (Image.Elements.Debug)image;
                    Image image15 = debug.image();
                    Color color = debug.color();
                    return algebra.debug(Image$.MODULE$.compile(image15).apply(algebra), color);
                }
                if (Image$Elements$Empty$.MODULE$.equals(image)) {
                    return algebra.empty();
                }
                throw new MatchError((Object)image);
            }
            {
                this.image$1 = image$1;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Image$.class);
    }

    private Image$() {
    }
}

