/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import cats.Foldable;
import cats.Traverse;
import cats.free.Free;
import cats.free.Free$;
import cats.implicits$;
import cats.kernel.Order;
import doodle.core.Angle;
import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Parametric;
import doodle.core.Parametric$;
import doodle.core.PathElement;
import doodle.core.PathElement$;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Vec$;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.image.syntax.package$all$;
import doodle.image.syntax.package$core$;
import doodle.random;
import doodle.random$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class Sine$
implements Serializable {
    private static final Color underBlue;
    private static final Free randomAngle;
    private static final Free samples;
    private static final Image spacer;
    private static final Image sines;
    private static final List images;
    public static final Sine$ MODULE$;

    private Sine$() {
    }

    static {
        MODULE$ = new Sine$();
        underBlue = Color$.MODULE$.rgb(package$core$.MODULE$.ToUnsignedByteOps(39).uByte(), package$core$.MODULE$.ToUnsignedByteOps(170).uByte(), package$core$.MODULE$.ToUnsignedByteOps(255).uByte());
        randomAngle = random.Random$.MODULE$.double().map((Function1 & Serializable)a -> this.$init$$$anonfun$2(BoxesRunTime.unboxToDouble((Object)a)));
        samples = MODULE$.noiseSamples(100, MODULE$.noisySine(MODULE$.sine(2000, 150.0, 400), MODULE$.noisySine$default$2()));
        spacer = Image$.MODULE$.rectangle(2000.0, 500.0).noStroke().noFill();
        Image s1 = Image$.MODULE$.interpolatingSpline((Seq<Point>)MODULE$.sine(2000, 150.0, 200).sample(200)).strokeWidth(11.0);
        Image s2 = Image$.MODULE$.interpolatingSpline((Seq<Point>)MODULE$.sine(2000, 150.0, 400).sample(200)).strokeWidth(11.0);
        Image s3 = Image$.MODULE$.interpolatingSpline((Seq<Point>)MODULE$.sine(2000, 150.0, 800).sample(200)).strokeWidth(11.0);
        Color c1 = MODULE$.underBlue().lightness(package$core$.MODULE$.ToNormalizedOps(0.8).normalized());
        Color.HSLA c3 = c1.spin(package$core$.MODULE$.AngleIntOps(180).degrees());
        sines = s2.strokeColor(Color$.MODULE$.white()).on(s1.strokeColor(c1)).on(s3.strokeColor((Color)c3));
        images = (List)MODULE$.samples().map((Function1 & Serializable)data -> {
            List periods = (List)package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)1625), (Object)BoxesRunTime.boxToInteger((int)25), (Integral)Numeric.IntIsIntegral$.MODULE$);
            Image dataPlot = package$all$.MODULE$.TraverseImageOps(data.map((Function1 & Serializable)pt -> Image$.MODULE$.circle(9.0).at(pt.toVec()))).allOn((Traverse)implicits$.MODULE$.catsStdInstancesForList()).fillColor(this.underBlue()).noStroke();
            List sines = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 200, 400, 800, 1600}))).map((Function1 & Serializable)p -> this.$anonfun$10(BoxesRunTime.unboxToInt((Object)p)));
            Image bars = this.errorBars((List<Point>)data, this.sine(2000, 150.0, 1600), 2000);
            Image squaredError = this.errorPlot((List<Point>)data, (List<Object>)periods);
            Image descent = this.gradientDescent((List<Point>)data, (List<Object>)periods, 350, 410, 10);
            Image image = dataPlot.on(this.spacer());
            Image image2 = ((Image)sines.last()).on(dataPlot).on(bars);
            return sines.map((Function1 & Serializable)s -> dataPlot.on((Image)s)).$colon$colon((Object)image2).$colon$colon((Object)image).$colon$colon((Object)squaredError).$colon$colon((Object)descent);
        }).run(random$.MODULE$.randomInstances(random$.MODULE$.randomInstances$default$1()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Sine$.class);
    }

    public Color underBlue() {
        return underBlue;
    }

    public Parametric.AngularCurve sine(int width, double amplitude, int period) {
        double frequency = (double)width / (double)period;
        return Parametric.AngularCurve$.MODULE$.apply(Parametric$.MODULE$.sine(amplitude, frequency).andThen((Function1 & Serializable)pt -> Point$.MODULE$.apply((pt.x() - 0.5) * (double)width, pt.y())));
    }

    public Function1<Angle, Free<random.RandomOp, Point>> noisySine(Parametric.AngularCurve curve, double stdDev) {
        return (Function1 & Serializable)angle -> random.Random$.MODULE$.normal(0.0, stdDev).map((Function1 & Serializable)offset -> this.noisySine$$anonfun$2$$anonfun$1(curve, (Angle)angle, BoxesRunTime.unboxToDouble((Object)offset)));
    }

    public double noisySine$default$2() {
        return 15.0;
    }

    public Free randomAngle() {
        return randomAngle;
    }

    public Free<random.RandomOp, List<Point>> noiseSamples(int n, Function1<Angle, Free<random.RandomOp, Point>> f) {
        return (Free)implicits$.MODULE$.toFoldableOps((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).toList(), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).foldM((Object)package$.MODULE$.List().empty(), (Function2 & Serializable)(accum, _$1) -> this.noiseSamples$$anonfun$2(f, (List)accum, BoxesRunTime.unboxToInt((Object)_$1)), Free$.MODULE$.catsFreeMonadForFree());
    }

    public Free<random.RandomOp, List<Point>> samples() {
        return samples;
    }

    public double error(Parametric.AngularCurve curve, List<Point> data) {
        return BoxesRunTime.unboxToDouble((Object)data.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(error, pt) -> this.error$$anonfun$1(curve, BoxesRunTime.unboxToDouble((Object)error), (Point)pt)));
    }

    public Image errorPlot(List<Point> data, List<Object> periods) {
        List errors = ((List)periods.sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForInt()))).map((Function1 & Serializable)p -> this.$anonfun$11(data, BoxesRunTime.unboxToInt((Object)p)));
        int maxPeriod = BoxesRunTime.unboxToInt((Object)periods.max(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForInt())));
        double max = BoxesRunTime.unboxToDouble((Object)errors.map((Function1 & Serializable)pt -> pt.y()).max(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())));
        List scaled = errors.map((Function1 & Serializable)pt -> Point$.MODULE$.apply(pt.x(), pt.y() * (double)maxPeriod * 0.5625 / max));
        Image points = package$all$.MODULE$.TraverseImageOps(scaled.map((Function1 & Serializable)pt -> Image$.MODULE$.circle(13.0).at(pt.toVec()).fillColor(Color$.MODULE$.white()).noStroke())).allOn((Traverse)implicits$.MODULE$.catsStdInstancesForList());
        Image curve = Image$.MODULE$.interpolatingSpline((Seq<Point>)scaled).strokeWidth(11.0).strokeColor(Color$.MODULE$.white());
        return points.on(curve);
    }

    public Image gradientDescent(List<Point> data, List<Object> periods, int start, int goal, int step) {
        List steps = (List)package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)goal), (Object)BoxesRunTime.boxToInteger((int)step), (Integral)Numeric.IntIsIntegral$.MODULE$);
        List errors = ((List)periods.sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForInt()))).map((Function1 & Serializable)p -> this.$anonfun$12(data, BoxesRunTime.unboxToInt((Object)p)));
        int maxPeriod = BoxesRunTime.unboxToInt((Object)periods.max(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForInt())));
        double max = BoxesRunTime.unboxToDouble((Object)errors.map((Function1 & Serializable)pt -> pt.y()).max(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForDouble())));
        List scaled = errors.map((Function1 & Serializable)pt -> Point$.MODULE$.apply(pt.x(), pt.y() * (double)maxPeriod * 0.5625 / max));
        Image curve = Image$.MODULE$.interpolatingSpline((Seq<Point>)scaled).strokeWidth(11.0).strokeColor(Color$.MODULE$.white());
        Tuple2 tuple2 = (Tuple2)steps.map((Function1 & Serializable)p -> this.$anonfun$13(data, BoxesRunTime.unboxToInt((Object)p))).map((Function1 & Serializable)pt -> Point$.MODULE$.apply(pt.x(), pt.y() * (double)maxPeriod * 0.5625 / max)).map((Function1 & Serializable)pt -> Image$.MODULE$.circle(13.0).at(pt.toVec()).noStroke()).foldLeft((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)package$.MODULE$.List().empty()), (Function2 & Serializable)(accum, img) -> {
            Tuple2 tuple2 = accum;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double lightness = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            List soFar = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)lightness), (Object)soFar);
            double lightness2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
            List soFar2 = (List)tuple22._2();
            Image image = img.fillColor(Color$.MODULE$.red().lightness(package$core$.MODULE$.ToNormalizedOps(lightness2).normalized()));
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(lightness2 * 0.9)), (Object)soFar2.$colon$colon((Object)image));
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List visited = (List)tuple2._2();
        List visited2 = visited;
        return package$all$.MODULE$.TraverseImageOps(visited2).allOn((Traverse)implicits$.MODULE$.catsStdInstancesForList()).on(curve);
    }

    public Image errorBars(List<Point> data, Parametric.AngularCurve curve, int width) {
        return package$all$.MODULE$.TraverseImageOps(data.map((Function1 & Serializable)pt -> {
            Angle angle = package$core$.MODULE$.AngleDoubleOps((pt.x() + (double)(width / 2)) / (double)width).turns();
            Point predicted = curve.apply(angle);
            return Image$.MODULE$.openPath((Seq<PathElement>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(pt.x(), pt.y()), PathElement$.MODULE$.lineTo(predicted.x(), predicted.y())})))).strokeColor(this.underBlue()).strokeWidth(7.0);
        })).allOn((Traverse)implicits$.MODULE$.catsStdInstancesForList());
    }

    public Image styledSine(Parametric.AngularCurve curve) {
        return Image$.MODULE$.interpolatingSpline((Seq<Point>)curve.sample(200)).strokeWidth(11.0).strokeColor(Color$.MODULE$.white());
    }

    public Image spacer() {
        return spacer;
    }

    public Image sines() {
        return sines;
    }

    public List<Image> images() {
        return images;
    }

    private final /* synthetic */ Angle $init$$$anonfun$2(double a) {
        return package$core$.MODULE$.AngleDoubleOps(a).turns();
    }

    private final /* synthetic */ Image $anonfun$10(int p) {
        return this.styledSine(this.sine(2000, 150.0, p)).on(this.spacer());
    }

    private final /* synthetic */ Point noisySine$$anonfun$2$$anonfun$1(Parametric.AngularCurve curve$2, Angle angle$1, double offset) {
        return curve$2.apply(angle$1).$plus(Vec$.MODULE$.apply(0.0, offset));
    }

    private final /* synthetic */ Free noiseSamples$$anonfun$2(Function1 f$1, List accum, int _$1) {
        return this.randomAngle().flatMap(f$1).map((Function1 & Serializable)pt -> accum.$colon$colon(pt));
    }

    private final /* synthetic */ double error$$anonfun$1(Parametric.AngularCurve curve$3, double error, Point pt) {
        double diff = curve$3.apply(package$core$.MODULE$.AngleDoubleOps((pt.x() + 1000.0) / 2000.0).turns()).y() - pt.y();
        return error + diff * diff;
    }

    private final /* synthetic */ Point $anonfun$11(List data$1, int p) {
        return Point$.MODULE$.apply((double)p, this.error(this.sine(2000, 150.0, p), (List<Point>)data$1));
    }

    private final /* synthetic */ Point $anonfun$12(List data$2, int p) {
        return Point$.MODULE$.apply((double)p, this.error(this.sine(2000, 150.0, p), (List<Point>)data$2));
    }

    private final /* synthetic */ Point $anonfun$13(List data$3, int p) {
        return Point$.MODULE$.apply((double)p, this.error(this.sine(2000, 150.0, p), (List<Point>)data$3));
    }
}

