/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import doodle.algebra.Picture;
import doodle.core.Angle;
import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Gradient;
import doodle.core.PathElement;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Transform;
import doodle.core.Transform$;
import doodle.core.Vec;
import doodle.image.Image$;
import doodle.image.Image$Elements$Above$;
import doodle.image.Image$Elements$At$;
import doodle.image.Image$Elements$Beside$;
import doodle.image.Image$Elements$Debug$;
import doodle.image.Image$Elements$FillColor$;
import doodle.image.Image$Elements$FillGradient$;
import doodle.image.Image$Elements$NoFill$;
import doodle.image.Image$Elements$NoStroke$;
import doodle.image.Image$Elements$On$;
import doodle.image.Image$Elements$StrokeColor$;
import doodle.image.Image$Elements$StrokeWidth$;
import doodle.image.Image$Elements$Transform$;
import doodle.image.Path;
import doodle.language.Basic;
import java.io.Serializable;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public abstract class Image
implements Product,
Serializable {
    public static Path catmulRom(Seq<Point> seq, double d) {
        return Image$.MODULE$.catmulRom(seq, d);
    }

    public static Image circle(double d) {
        return Image$.MODULE$.circle(d);
    }

    public static Path closedPath(Seq<PathElement> seq) {
        return Image$.MODULE$.closedPath(seq);
    }

    public static Image empty() {
        return Image$.MODULE$.empty();
    }

    public static Image equilateralTriangle(double d) {
        return Image$.MODULE$.equilateralTriangle(d);
    }

    public static Path interpolatingSpline(Seq<Point> seq) {
        return Image$.MODULE$.interpolatingSpline(seq);
    }

    public static Image line(double d, double d2) {
        return Image$.MODULE$.line(d, d2);
    }

    public static Path openPath(Seq<PathElement> seq) {
        return Image$.MODULE$.openPath(seq);
    }

    public static int ordinal(Image image) {
        return Image$.MODULE$.ordinal(image);
    }

    public static Image rectangle(double d, double d2) {
        return Image$.MODULE$.rectangle(d, d2);
    }

    public static Image regularPolygon(int n, double d) {
        return Image$.MODULE$.regularPolygon(n, d);
    }

    public static Image rightArrow(double d, double d2) {
        return Image$.MODULE$.rightArrow(d, d2);
    }

    public static Image roundedRectangle(double d, double d2, double d3) {
        return Image$.MODULE$.roundedRectangle(d, d2, d3);
    }

    public static Image square(double d) {
        return Image$.MODULE$.square(d);
    }

    public static Image star(int n, double d, double d2) {
        return Image$.MODULE$.star(n, d, d2);
    }

    public static Image triangle(double d, double d2) {
        return Image$.MODULE$.triangle(d, d2);
    }

    public static double catmulRom$default$2() {
        return Image$.MODULE$.catmulRom$default$2();
    }

    public Image beside(Image right) {
        return Image$Elements$Beside$.MODULE$.apply(this, right);
    }

    public Image on(Image bottom) {
        return Image$Elements$On$.MODULE$.apply(this, bottom);
    }

    public Image under(Image top) {
        return Image$Elements$On$.MODULE$.apply(top, this);
    }

    public Image above(Image bottom) {
        return Image$Elements$Above$.MODULE$.apply(this, bottom);
    }

    public Image below(Image top) {
        return Image$Elements$Above$.MODULE$.apply(top, this);
    }

    public Image strokeColor(Color color) {
        return Image$Elements$StrokeColor$.MODULE$.apply(this, color);
    }

    public Image strokeWidth(double width) {
        return Image$Elements$StrokeWidth$.MODULE$.apply(this, width);
    }

    public Image fillColor(Color color) {
        return Image$Elements$FillColor$.MODULE$.apply(this, color);
    }

    public Image fillGradient(Gradient gradient) {
        return Image$Elements$FillGradient$.MODULE$.apply(this, gradient);
    }

    public Image noStroke() {
        return Image$Elements$NoStroke$.MODULE$.apply(this);
    }

    public Image noFill() {
        return Image$Elements$NoFill$.MODULE$.apply(this);
    }

    public Image transform(Transform tx) {
        return Image$Elements$Transform$.MODULE$.apply(tx, this);
    }

    public Image rotate(Angle angle) {
        return this.transform(Transform$.MODULE$.rotate(angle));
    }

    public Image scale(double x, double y) {
        return this.transform(Transform$.MODULE$.scale(x, y));
    }

    public Image at(Vec vec) {
        return Image$Elements$At$.MODULE$.apply(this, vec.x(), vec.y());
    }

    public Image at(Point pt) {
        return Image$Elements$At$.MODULE$.apply(this, pt.x(), pt.y());
    }

    public Image at(double x, double y) {
        return Image$Elements$At$.MODULE$.apply(this, x, y);
    }

    public Image at(double r, Angle a) {
        Point pt = Point$.MODULE$.apply(r, a);
        return Image$Elements$At$.MODULE$.apply(this, pt.x(), pt.y());
    }

    public Image debug(Color color) {
        return Image$Elements$Debug$.MODULE$.apply(this, color);
    }

    public Image debug() {
        return Image$Elements$Debug$.MODULE$.apply(this, Color$.MODULE$.crimson());
    }

    public <Algebra extends Basic<Object>, F> Picture<Algebra, F, BoxedUnit> compile() {
        return Image$.MODULE$.compile(this);
    }
}

