/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import cats.instances.package;
import cats.kernel.Semigroup;
import doodle.algebra.Algebra;
import doodle.algebra.Picture;
import doodle.core.ClosedPath$;
import doodle.core.Color;
import doodle.core.Gradient;
import doodle.core.OpenPath$;
import doodle.core.PathElement;
import doodle.core.PathElement$;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.core.font.Font;
import doodle.image.Image;
import doodle.image.Image$Elements$;
import doodle.image.Image$Elements$Above$;
import doodle.image.Image$Elements$At$;
import doodle.image.Image$Elements$Beside$;
import doodle.image.Image$Elements$Circle$;
import doodle.image.Image$Elements$ClosedPath$;
import doodle.image.Image$Elements$Debug$;
import doodle.image.Image$Elements$Empty$;
import doodle.image.Image$Elements$FillColor$;
import doodle.image.Image$Elements$FillGradient$;
import doodle.image.Image$Elements$Font$;
import doodle.image.Image$Elements$NoFill$;
import doodle.image.Image$Elements$NoStroke$;
import doodle.image.Image$Elements$On$;
import doodle.image.Image$Elements$OpenPath$;
import doodle.image.Image$Elements$Rectangle$;
import doodle.image.Image$Elements$StrokeColor$;
import doodle.image.Image$Elements$StrokeWidth$;
import doodle.image.Image$Elements$Text$;
import doodle.image.Image$Elements$Transform$;
import doodle.image.Image$Elements$Triangle$;
import doodle.image.Path;
import doodle.language.Basic;
import java.io.Serializable;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Image$
implements Mirror.Sum,
Serializable {
    public static final Image$Elements$ Elements;
    private static final Image empty;
    public static final Image$ MODULE$;

    private Image$() {
    }

    static {
        MODULE$ = new Image$();
        empty = Image$Elements$Empty$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Image$.class);
    }

    public Path closedPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return Image$Elements$ClosedPath$.MODULE$.apply((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Path openPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return Image$Elements$OpenPath$.MODULE$.apply((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Image text(String characters) {
        return Image$Elements$Text$.MODULE$.apply(characters);
    }

    public Image line(double x, double y) {
        double startX = -x / (double)2;
        double startY = -y / (double)2;
        double endX = x / (double)2;
        double endY = y / (double)2;
        return this.openPath((Seq<PathElement>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(startX, startY), PathElement$.MODULE$.lineTo(endX, endY)}))));
    }

    public Image circle(double diameter) {
        return Image$Elements$Circle$.MODULE$.apply(diameter);
    }

    public Image rectangle(double width, double height) {
        return Image$Elements$Rectangle$.MODULE$.apply(width, height);
    }

    public Image square(double side) {
        return this.rectangle(side, side);
    }

    public Image regularPolygon(int sides, double radius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.regularPolygon(sides, radius));
    }

    public Image star(int points, double outerRadius, double innerRadius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.star(points, outerRadius, innerRadius));
    }

    public Image rightArrow(double width, double height) {
        List path = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(width / (double)2, 0.0), PathElement$.MODULE$.lineTo(0.0, height / (double)2), PathElement$.MODULE$.lineTo(0.0, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height / (double)2), PathElement$.MODULE$.lineTo(width / (double)2, 0.0)}));
        return this.closedPath((Seq<PathElement>)path);
    }

    public Image roundedRectangle(double width, double height, double radius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.roundedRectangle(width, height, radius));
    }

    public Image equilateralTriangle(double width) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.equilateralTriangle(width));
    }

    public Image triangle(double width, double height) {
        return Image$Elements$Triangle$.MODULE$.apply(width, height);
    }

    public Path interpolatingSpline(Seq<Point> points) {
        return this.catmulRom(points, this.catmulRom$default$2());
    }

    public Path catmulRom(Seq<Point> points, double tension) {
        return this.openPath((Seq<PathElement>)PathElement$.MODULE$.catmulRom(points, tension));
    }

    public double catmulRom$default$2() {
        return 0.5;
    }

    public Image empty() {
        return empty;
    }

    public <Alg extends Basic> Picture<Alg, BoxedUnit> compile(Image image) {
        return new Picture<Alg, BoxedUnit>(image){
            private final Image image$1;
            {
                this.image$1 = image$2;
            }

            public Object apply(Basic algebra) {
                Object object;
                Image image = this.image$1;
                if (image instanceof Image.Elements.OpenPath) {
                    List<PathElement> list;
                    Image.Elements.OpenPath openPath = Image$Elements$OpenPath$.MODULE$.unapply((Image.Elements.OpenPath)image);
                    List<PathElement> elements = list = openPath._1();
                    object = algebra.path(OpenPath$.MODULE$.apply(elements));
                } else if (image instanceof Image.Elements.ClosedPath) {
                    List<PathElement> list;
                    Image.Elements.ClosedPath closedPath = Image$Elements$ClosedPath$.MODULE$.unapply((Image.Elements.ClosedPath)image);
                    List<PathElement> elements = list = closedPath._1();
                    object = algebra.path(ClosedPath$.MODULE$.apply(elements));
                } else if (image instanceof Image.Elements.Text) {
                    String string;
                    Image.Elements.Text text = Image$Elements$Text$.MODULE$.unapply((Image.Elements.Text)image);
                    String t = string = text._1();
                    object = algebra.text(t);
                } else if (image instanceof Image.Elements.Font) {
                    Image.Elements.Font font = Image$Elements$Font$.MODULE$.unapply((Image.Elements.Font)image);
                    Image image2 = font._1();
                    Font font2 = font._2();
                    Image image3 = image2;
                    Font f = font2;
                    object = algebra.font(Image$.MODULE$.compile(image3).apply((Algebra)algebra), f);
                } else if (image instanceof Image.Elements.Circle) {
                    double d;
                    Image.Elements.Circle circle = Image$Elements$Circle$.MODULE$.unapply((Image.Elements.Circle)image);
                    double d2 = d = circle._1();
                    object = algebra.circle(d2);
                } else if (image instanceof Image.Elements.Rectangle) {
                    Image.Elements.Rectangle rectangle = Image$Elements$Rectangle$.MODULE$.unapply((Image.Elements.Rectangle)image);
                    double d = rectangle._1();
                    double d3 = rectangle._2();
                    double w = d;
                    double h = d3;
                    object = algebra.rectangle(w, h);
                } else if (image instanceof Image.Elements.Triangle) {
                    Image.Elements.Triangle triangle = Image$Elements$Triangle$.MODULE$.unapply((Image.Elements.Triangle)image);
                    double d = triangle._1();
                    double d4 = triangle._2();
                    double w = d;
                    double h = d4;
                    object = algebra.triangle(w, h);
                } else if (image instanceof Image.Elements.Beside) {
                    Image.Elements.Beside beside = Image$Elements$Beside$.MODULE$.unapply((Image.Elements.Beside)image);
                    Image image4 = beside._1();
                    Image image5 = beside._2();
                    Image l = image4;
                    Image r = image5;
                    object = algebra.beside(Image$.MODULE$.compile(l).apply((Algebra)algebra), Image$.MODULE$.compile(r).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                } else if (image instanceof Image.Elements.Above) {
                    Image.Elements.Above above = Image$Elements$Above$.MODULE$.unapply((Image.Elements.Above)image);
                    Image image6 = above._1();
                    Image image7 = above._2();
                    Image l = image6;
                    Image r = image7;
                    object = algebra.above(Image$.MODULE$.compile(l).apply((Algebra)algebra), Image$.MODULE$.compile(r).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                } else if (image instanceof Image.Elements.On) {
                    Image.Elements.On on = Image$Elements$On$.MODULE$.unapply((Image.Elements.On)image);
                    Image image8 = on._1();
                    Image image9 = on._2();
                    Image t = image8;
                    Image b = image9;
                    object = algebra.on(Image$.MODULE$.compile(t).apply((Algebra)algebra), Image$.MODULE$.compile(b).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                } else if (image instanceof Image.Elements.At) {
                    Image.Elements.At at = Image$Elements$At$.MODULE$.unapply((Image.Elements.At)image);
                    Image image10 = at._1();
                    double d = at._2();
                    double d5 = at._3();
                    Image image11 = image10;
                    double x = d;
                    double y = d5;
                    object = algebra.at(Image$.MODULE$.compile(image11).apply((Algebra)algebra), x, y);
                } else if (image instanceof Image.Elements.Transform) {
                    Image.Elements.Transform transform = Image$Elements$Transform$.MODULE$.unapply((Image.Elements.Transform)image);
                    Transform transform2 = transform._1();
                    Image image12 = transform._2();
                    Transform tx = transform2;
                    Image i = image12;
                    object = algebra.transform(Image$.MODULE$.compile(i).apply((Algebra)algebra), tx);
                } else if (image instanceof Image.Elements.StrokeWidth) {
                    Image.Elements.StrokeWidth strokeWidth = Image$Elements$StrokeWidth$.MODULE$.unapply((Image.Elements.StrokeWidth)image);
                    Image image13 = strokeWidth._1();
                    double d = strokeWidth._2();
                    Image image14 = image13;
                    double width = d;
                    object = algebra.strokeWidth(Image$.MODULE$.compile(image14).apply((Algebra)algebra), width);
                } else if (image instanceof Image.Elements.StrokeColor) {
                    Image.Elements.StrokeColor strokeColor = Image$Elements$StrokeColor$.MODULE$.unapply((Image.Elements.StrokeColor)image);
                    Image image15 = strokeColor._1();
                    Color color = strokeColor._2();
                    Image image16 = image15;
                    Color color2 = color;
                    object = algebra.strokeColor(Image$.MODULE$.compile(image16).apply((Algebra)algebra), color2);
                } else if (image instanceof Image.Elements.FillColor) {
                    Image.Elements.FillColor fillColor = Image$Elements$FillColor$.MODULE$.unapply((Image.Elements.FillColor)image);
                    Image image17 = fillColor._1();
                    Color color = fillColor._2();
                    Image image18 = image17;
                    Color color3 = color;
                    object = algebra.fillColor(Image$.MODULE$.compile(image18).apply((Algebra)algebra), color3);
                } else if (image instanceof Image.Elements.FillGradient) {
                    Image.Elements.FillGradient fillGradient = Image$Elements$FillGradient$.MODULE$.unapply((Image.Elements.FillGradient)image);
                    Image image19 = fillGradient._1();
                    Gradient gradient = fillGradient._2();
                    Image image20 = image19;
                    Gradient gradient2 = gradient;
                    object = algebra.fillGradient(Image$.MODULE$.compile(image20).apply((Algebra)algebra), gradient2);
                } else if (image instanceof Image.Elements.NoStroke) {
                    Image image21;
                    Image.Elements.NoStroke noStroke = Image$Elements$NoStroke$.MODULE$.unapply((Image.Elements.NoStroke)image);
                    Image image22 = image21 = noStroke._1();
                    object = algebra.noStroke(Image$.MODULE$.compile(image22).apply((Algebra)algebra));
                } else if (image instanceof Image.Elements.NoFill) {
                    Image image23;
                    Image.Elements.NoFill noFill = Image$Elements$NoFill$.MODULE$.unapply((Image.Elements.NoFill)image);
                    Image image24 = image23 = noFill._1();
                    object = algebra.noFill(Image$.MODULE$.compile(image24).apply((Algebra)algebra));
                } else if (image instanceof Image.Elements.Debug) {
                    Image.Elements.Debug debug = Image$Elements$Debug$.MODULE$.unapply((Image.Elements.Debug)image);
                    Image image25 = debug._1();
                    Color color = debug._2();
                    Image image26 = image25;
                    Color color4 = color;
                    object = algebra.debug(Image$.MODULE$.compile(image26).apply((Algebra)algebra), color4);
                } else if (Image$Elements$Empty$.MODULE$.equals(image)) {
                    object = algebra.empty();
                } else {
                    throw new MatchError((Object)image);
                }
                return object;
            }
        };
    }

    public int ordinal(Image x$0) {
        int n;
        Image image = x$0;
        if (image instanceof Path) {
            n = 0;
        } else if (image instanceof Image.Elements.Text) {
            n = 1;
        } else if (image instanceof Image.Elements.Circle) {
            n = 2;
        } else if (image instanceof Image.Elements.Rectangle) {
            n = 3;
        } else if (image instanceof Image.Elements.Triangle) {
            n = 4;
        } else if (image instanceof Image.Elements.Beside) {
            n = 5;
        } else if (image instanceof Image.Elements.Above) {
            n = 6;
        } else if (image instanceof Image.Elements.On) {
            n = 7;
        } else if (image instanceof Image.Elements.At) {
            n = 8;
        } else if (image instanceof Image.Elements.Transform) {
            n = 9;
        } else if (image instanceof Image.Elements.StrokeWidth) {
            n = 10;
        } else if (image instanceof Image.Elements.StrokeColor) {
            n = 11;
        } else if (image instanceof Image.Elements.FillColor) {
            n = 12;
        } else if (image instanceof Image.Elements.FillGradient) {
            n = 13;
        } else if (image instanceof Image.Elements.NoStroke) {
            n = 14;
        } else if (image instanceof Image.Elements.NoFill) {
            n = 15;
        } else if (image instanceof Image.Elements.Font) {
            n = 16;
        } else if (image instanceof Image.Elements.Debug) {
            n = 17;
        } else if (image == Image$Elements$Empty$.MODULE$) {
            n = 18;
        } else {
            throw new MatchError((Object)image);
        }
        return n;
    }
}

