/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Normalized;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.syntax.package;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.runtime.ModuleSerializationProxy;

public final class ColorPaletteAgain$
implements Serializable {
    private static final double circleMinimum;
    private static final double circleIncrement;
    public static final ColorPaletteAgain$ MODULE$;

    private ColorPaletteAgain$() {
    }

    static {
        MODULE$ = new ColorPaletteAgain$();
        circleMinimum = 50.0;
        circleIncrement = 10.0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ColorPaletteAgain$.class);
    }

    public double circleMinimum() {
        return circleMinimum;
    }

    public double circleIncrement() {
        return circleIncrement;
    }

    public Color complement(Color c) {
        return c.spin(package.all$.MODULE$.AngleIntOps(180).degrees());
    }

    public Color nearComplement(Color c) {
        return c.spin(package.all$.MODULE$.AngleIntOps(170).degrees());
    }

    public Color analogous(Color c) {
        return c.spin(package.all$.MODULE$.AngleIntOps(15).degrees());
    }

    public Image singleCircle(int n, Color color) {
        return Image$.MODULE$.circle(this.circleMinimum() + this.circleIncrement() * (double)n).strokeColor(color).strokeWidth(this.circleIncrement());
    }

    public Image complementCircles(int n, Color c) {
        Color color = this.complement(c);
        if (n == 1) {
            return this.singleCircle(n, color);
        }
        return this.complementCircles(n - 1, color).on(this.singleCircle(n, color));
    }

    public Image nearComplementCircles(int n, Color c) {
        Color color = this.nearComplement(c);
        if (n == 1) {
            return this.singleCircle(n, color);
        }
        return this.nearComplementCircles(n - 1, color).on(this.singleCircle(n, color));
    }

    public Image coloredCircles(int n, Color c, Function1<Color, Color> palette) {
        Color color = (Color)palette.apply((Object)c);
        if (n == 1) {
            return this.singleCircle(n, color);
        }
        return this.coloredCircles(n - 1, color, palette).on(this.singleCircle(n, color));
    }

    public int lcg1(int input) {
        int a = 8121;
        int c = 28411;
        int m = 134456;
        return (a * input + c) % m;
    }

    public int lcg2(int input) {
        int a = 48271;
        int m = Integer.MAX_VALUE;
        int q = m / a;
        int r = m % a;
        int result = a * (input % q) - r * (input / q);
        if (result <= 0) {
            return result + m;
        }
        return result;
    }

    public double normalize(int value, int max) {
        return package.all$.MODULE$.ToNormalizedOps((double)value / (double)max).normalized();
    }

    public double rescale(double value, double min, double range) {
        return package.all$.MODULE$.ToNormalizedOps(value * range + min).normalized();
    }

    public Color lcgColor(Color c) {
        Color.HSLA spun = c.spin(package.all$.MODULE$.AngleIntOps(169).degrees());
        double saturation = this.rescale(this.normalize(this.lcg1((int)spun.hue().toDegrees()), 134456), 0.25, 0.75);
        double lightness = this.rescale(this.normalize(this.lcg2((int)spun.hue().toDegrees()), Integer.MAX_VALUE), 0.25, 0.5);
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("saturation ").append(new Normalized(saturation)).append(" lightness ").append(new Normalized(lightness)).toString());
        return spun.saturation(saturation).lightness(lightness);
    }

    public Image image() {
        return this.complementCircles(10, Color$.MODULE$.seaGreen()).beside(this.nearComplementCircles(10, Color$.MODULE$.seaGreen())).beside(this.coloredCircles(10, Color$.MODULE$.seaGreen(), (Function1<Color, Color>)(Function1 & Serializable)c -> this.lcgColor((Color)c)));
    }
}

