/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import cats.instances.package;
import cats.kernel.Semigroup;
import doodle.algebra.Algebra;
import doodle.algebra.Picture;
import doodle.core.Cap;
import doodle.core.ClosedPath;
import doodle.core.ClosedPath$;
import doodle.core.Color;
import doodle.core.Gradient;
import doodle.core.Join;
import doodle.core.OpenPath;
import doodle.core.OpenPath$;
import doodle.core.PathElement;
import doodle.core.PathElement$;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.core.font.Font;
import doodle.image.Image;
import doodle.image.Image$Elements$;
import doodle.image.Image$Elements$Above$;
import doodle.image.Image$Elements$At$;
import doodle.image.Image$Elements$Beside$;
import doodle.image.Image$Elements$Circle$;
import doodle.image.Image$Elements$ClosedPath$;
import doodle.image.Image$Elements$Debug$;
import doodle.image.Image$Elements$Empty$;
import doodle.image.Image$Elements$FillColor$;
import doodle.image.Image$Elements$FillGradient$;
import doodle.image.Image$Elements$Font$;
import doodle.image.Image$Elements$NoFill$;
import doodle.image.Image$Elements$NoStroke$;
import doodle.image.Image$Elements$On$;
import doodle.image.Image$Elements$OpenPath$;
import doodle.image.Image$Elements$Rectangle$;
import doodle.image.Image$Elements$StrokeCap$;
import doodle.image.Image$Elements$StrokeColor$;
import doodle.image.Image$Elements$StrokeDash$;
import doodle.image.Image$Elements$StrokeJoin$;
import doodle.image.Image$Elements$StrokeWidth$;
import doodle.image.Image$Elements$Text$;
import doodle.image.Image$Elements$Transform$;
import doodle.image.Image$Elements$Triangle$;
import doodle.image.Path;
import doodle.language.Basic;
import java.io.Serializable;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Image$
implements Mirror.Sum,
Serializable {
    public static final Image$Elements$ Elements;
    private static final Image empty;
    public static final Image$ MODULE$;

    private Image$() {
    }

    static {
        MODULE$ = new Image$();
        empty = Image$Elements$Empty$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Image$.class);
    }

    public Path closedPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return Image$Elements$ClosedPath$.MODULE$.apply((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Path openPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return Image$Elements$OpenPath$.MODULE$.apply((List<PathElement>)((IterableOnceOps)elements.$plus$colon((Object)pathElement)).toList());
    }

    public Path path(ClosedPath path) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return Image$Elements$ClosedPath$.MODULE$.apply((List<PathElement>)((List)path.elements().$plus$colon((Object)pathElement)));
    }

    public Path path(OpenPath path) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return Image$Elements$OpenPath$.MODULE$.apply((List<PathElement>)((List)path.elements().$plus$colon((Object)pathElement)));
    }

    public Image text(String characters) {
        return Image$Elements$Text$.MODULE$.apply(characters);
    }

    public Image line(double x, double y) {
        double startX = -x / (double)2;
        double startY = -y / (double)2;
        double endX = x / (double)2;
        double endY = y / (double)2;
        return this.openPath((Seq<PathElement>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(startX, startY), PathElement$.MODULE$.lineTo(endX, endY)}))));
    }

    public Image circle(double diameter) {
        return Image$Elements$Circle$.MODULE$.apply(diameter);
    }

    public Image rectangle(double width, double height) {
        return Image$Elements$Rectangle$.MODULE$.apply(width, height);
    }

    public Image square(double side) {
        return this.rectangle(side, side);
    }

    public Image regularPolygon(int sides, double radius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.regularPolygon(sides, radius));
    }

    public Image star(int points, double outerRadius, double innerRadius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.star(points, outerRadius, innerRadius));
    }

    public Image rightArrow(double width, double height) {
        List path = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(width / (double)2, 0.0), PathElement$.MODULE$.lineTo(0.0, height / (double)2), PathElement$.MODULE$.lineTo(0.0, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, height * 0.2), PathElement$.MODULE$.lineTo(-width / (double)2, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height * 0.2), PathElement$.MODULE$.lineTo(0.0, -height / (double)2), PathElement$.MODULE$.lineTo(width / (double)2, 0.0)}));
        return this.closedPath((Seq<PathElement>)path);
    }

    public Image roundedRectangle(double width, double height, double radius) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.roundedRectangle(width, height, radius));
    }

    public Image equilateralTriangle(double width) {
        return this.closedPath((Seq<PathElement>)PathElement$.MODULE$.equilateralTriangle(width));
    }

    public Image triangle(double width, double height) {
        return Image$Elements$Triangle$.MODULE$.apply(width, height);
    }

    public Path interpolatingSpline(Seq<Point> points) {
        return this.catmulRom(points, this.catmulRom$default$2());
    }

    public Path catmulRom(Seq<Point> points, double tension) {
        return this.openPath((Seq<PathElement>)PathElement$.MODULE$.catmulRom(points, tension));
    }

    public double catmulRom$default$2() {
        return 0.5;
    }

    public Image empty() {
        return empty;
    }

    public <Alg extends Basic> Picture<Alg, BoxedUnit> compile(Image image) {
        return new Picture<Alg, BoxedUnit>(image){
            private final Image image$1;
            {
                this.image$1 = image$2;
            }

            public Object apply(Basic algebra) {
                Image image = this.image$1;
                if (image instanceof Image.Elements.OpenPath) {
                    List<PathElement> list;
                    Image.Elements.OpenPath openPath = Image$Elements$OpenPath$.MODULE$.unapply((Image.Elements.OpenPath)image);
                    List<PathElement> elements = list = openPath._1();
                    return algebra.path(OpenPath$.MODULE$.apply(elements));
                }
                if (image instanceof Image.Elements.ClosedPath) {
                    List<PathElement> list;
                    Image.Elements.ClosedPath closedPath = Image$Elements$ClosedPath$.MODULE$.unapply((Image.Elements.ClosedPath)image);
                    List<PathElement> elements = list = closedPath._1();
                    return algebra.path(ClosedPath$.MODULE$.apply(elements));
                }
                if (image instanceof Image.Elements.Text) {
                    String string;
                    Image.Elements.Text text = Image$Elements$Text$.MODULE$.unapply((Image.Elements.Text)image);
                    String t = string = text._1();
                    return algebra.text(t);
                }
                if (image instanceof Image.Elements.Font) {
                    Image.Elements.Font font = Image$Elements$Font$.MODULE$.unapply((Image.Elements.Font)image);
                    Image image2 = font._1();
                    Font font2 = font._2();
                    Image image3 = image2;
                    Font f = font2;
                    return algebra.font(Image$.MODULE$.compile(image3).apply((Algebra)algebra), f);
                }
                if (image instanceof Image.Elements.Circle) {
                    double d;
                    Image.Elements.Circle circle = Image$Elements$Circle$.MODULE$.unapply((Image.Elements.Circle)image);
                    double d2 = d = circle._1();
                    return algebra.circle(d2);
                }
                if (image instanceof Image.Elements.Rectangle) {
                    Image.Elements.Rectangle rectangle = Image$Elements$Rectangle$.MODULE$.unapply((Image.Elements.Rectangle)image);
                    double d = rectangle._1();
                    double d3 = rectangle._2();
                    double w = d;
                    double h = d3;
                    return algebra.rectangle(w, h);
                }
                if (image instanceof Image.Elements.Triangle) {
                    Image.Elements.Triangle triangle = Image$Elements$Triangle$.MODULE$.unapply((Image.Elements.Triangle)image);
                    double d = triangle._1();
                    double d4 = triangle._2();
                    double w = d;
                    double h = d4;
                    return algebra.triangle(w, h);
                }
                if (image instanceof Image.Elements.Beside) {
                    Image.Elements.Beside beside = Image$Elements$Beside$.MODULE$.unapply((Image.Elements.Beside)image);
                    Image image4 = beside._1();
                    Image image5 = beside._2();
                    Image l = image4;
                    Image r = image5;
                    return algebra.beside(Image$.MODULE$.compile(l).apply((Algebra)algebra), Image$.MODULE$.compile(r).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.Above) {
                    Image.Elements.Above above = Image$Elements$Above$.MODULE$.unapply((Image.Elements.Above)image);
                    Image image6 = above._1();
                    Image image7 = above._2();
                    Image l = image6;
                    Image r = image7;
                    return algebra.above(Image$.MODULE$.compile(l).apply((Algebra)algebra), Image$.MODULE$.compile(r).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.On) {
                    Image.Elements.On on = Image$Elements$On$.MODULE$.unapply((Image.Elements.On)image);
                    Image image8 = on._1();
                    Image image9 = on._2();
                    Image t = image8;
                    Image b = image9;
                    return algebra.on(Image$.MODULE$.compile(t).apply((Algebra)algebra), Image$.MODULE$.compile(b).apply((Algebra)algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
                }
                if (image instanceof Image.Elements.At) {
                    Image.Elements.At at = Image$Elements$At$.MODULE$.unapply((Image.Elements.At)image);
                    Image image10 = at._1();
                    double d = at._2();
                    double d5 = at._3();
                    Image image11 = image10;
                    double x = d;
                    double y = d5;
                    return algebra.at(Image$.MODULE$.compile(image11).apply((Algebra)algebra), x, y);
                }
                if (image instanceof Image.Elements.Transform) {
                    Image.Elements.Transform transform = Image$Elements$Transform$.MODULE$.unapply((Image.Elements.Transform)image);
                    Transform transform2 = transform._1();
                    Image image12 = transform._2();
                    Transform tx = transform2;
                    Image i = image12;
                    return algebra.transform(Image$.MODULE$.compile(i).apply((Algebra)algebra), tx);
                }
                if (image instanceof Image.Elements.StrokeWidth) {
                    Image.Elements.StrokeWidth strokeWidth = Image$Elements$StrokeWidth$.MODULE$.unapply((Image.Elements.StrokeWidth)image);
                    Image image13 = strokeWidth._1();
                    double d = strokeWidth._2();
                    Image image14 = image13;
                    double width = d;
                    return algebra.strokeWidth(Image$.MODULE$.compile(image14).apply((Algebra)algebra), width);
                }
                if (image instanceof Image.Elements.StrokeColor) {
                    Image.Elements.StrokeColor strokeColor = Image$Elements$StrokeColor$.MODULE$.unapply((Image.Elements.StrokeColor)image);
                    Image image15 = strokeColor._1();
                    Color color = strokeColor._2();
                    Image image16 = image15;
                    Color color2 = color;
                    return algebra.strokeColor(Image$.MODULE$.compile(image16).apply((Algebra)algebra), color2);
                }
                if (image instanceof Image.Elements.StrokeCap) {
                    Image.Elements.StrokeCap strokeCap = Image$Elements$StrokeCap$.MODULE$.unapply((Image.Elements.StrokeCap)image);
                    Image image17 = strokeCap._1();
                    Cap cap = strokeCap._2();
                    Image image18 = image17;
                    Cap cap2 = cap;
                    return algebra.strokeCap(Image$.MODULE$.compile(image18).apply((Algebra)algebra), cap2);
                }
                if (image instanceof Image.Elements.StrokeJoin) {
                    Image.Elements.StrokeJoin strokeJoin = Image$Elements$StrokeJoin$.MODULE$.unapply((Image.Elements.StrokeJoin)image);
                    Image image19 = strokeJoin._1();
                    Join join = strokeJoin._2();
                    Image image20 = image19;
                    Join join2 = join;
                    return algebra.strokeJoin(Image$.MODULE$.compile(image20).apply((Algebra)algebra), join2);
                }
                if (image instanceof Image.Elements.StrokeDash) {
                    Image.Elements.StrokeDash strokeDash = Image$Elements$StrokeDash$.MODULE$.unapply((Image.Elements.StrokeDash)image);
                    Image image21 = strokeDash._1();
                    Iterable<Object> iterable = strokeDash._2();
                    Image image22 = image21;
                    Iterable<Object> pattern = iterable;
                    return algebra.strokeDash(Image$.MODULE$.compile(image22).apply((Algebra)algebra), pattern);
                }
                if (image instanceof Image.Elements.FillColor) {
                    Image.Elements.FillColor fillColor = Image$Elements$FillColor$.MODULE$.unapply((Image.Elements.FillColor)image);
                    Image image23 = fillColor._1();
                    Color color = fillColor._2();
                    Image image24 = image23;
                    Color color3 = color;
                    return algebra.fillColor(Image$.MODULE$.compile(image24).apply((Algebra)algebra), color3);
                }
                if (image instanceof Image.Elements.FillGradient) {
                    Image.Elements.FillGradient fillGradient = Image$Elements$FillGradient$.MODULE$.unapply((Image.Elements.FillGradient)image);
                    Image image25 = fillGradient._1();
                    Gradient gradient = fillGradient._2();
                    Image image26 = image25;
                    Gradient gradient2 = gradient;
                    return algebra.fillGradient(Image$.MODULE$.compile(image26).apply((Algebra)algebra), gradient2);
                }
                if (image instanceof Image.Elements.NoStroke) {
                    Image image27;
                    Image.Elements.NoStroke noStroke = Image$Elements$NoStroke$.MODULE$.unapply((Image.Elements.NoStroke)image);
                    Image image28 = image27 = noStroke._1();
                    return algebra.noStroke(Image$.MODULE$.compile(image28).apply((Algebra)algebra));
                }
                if (image instanceof Image.Elements.NoFill) {
                    Image image29;
                    Image.Elements.NoFill noFill = Image$Elements$NoFill$.MODULE$.unapply((Image.Elements.NoFill)image);
                    Image image30 = image29 = noFill._1();
                    return algebra.noFill(Image$.MODULE$.compile(image30).apply((Algebra)algebra));
                }
                if (image instanceof Image.Elements.Debug) {
                    Image.Elements.Debug debug = Image$Elements$Debug$.MODULE$.unapply((Image.Elements.Debug)image);
                    Image image31 = debug._1();
                    Color color = debug._2();
                    Image image32 = image31;
                    Color color4 = color;
                    return algebra.debug(Image$.MODULE$.compile(image32).apply((Algebra)algebra), color4);
                }
                if (Image$Elements$Empty$.MODULE$.equals(image)) {
                    return algebra.empty();
                }
                throw new MatchError((Object)image);
            }
        };
    }

    public int ordinal(Image x$0) {
        Image image = x$0;
        if (image instanceof Path) {
            return 0;
        }
        if (image instanceof Image.Elements.Text) {
            return 1;
        }
        if (image instanceof Image.Elements.Circle) {
            return 2;
        }
        if (image instanceof Image.Elements.Rectangle) {
            return 3;
        }
        if (image instanceof Image.Elements.Triangle) {
            return 4;
        }
        if (image instanceof Image.Elements.Beside) {
            return 5;
        }
        if (image instanceof Image.Elements.Above) {
            return 6;
        }
        if (image instanceof Image.Elements.On) {
            return 7;
        }
        if (image instanceof Image.Elements.At) {
            return 8;
        }
        if (image instanceof Image.Elements.Transform) {
            return 9;
        }
        if (image instanceof Image.Elements.StrokeWidth) {
            return 10;
        }
        if (image instanceof Image.Elements.StrokeColor) {
            return 11;
        }
        if (image instanceof Image.Elements.StrokeCap) {
            return 12;
        }
        if (image instanceof Image.Elements.StrokeJoin) {
            return 13;
        }
        if (image instanceof Image.Elements.StrokeDash) {
            return 14;
        }
        if (image instanceof Image.Elements.FillColor) {
            return 15;
        }
        if (image instanceof Image.Elements.FillGradient) {
            return 16;
        }
        if (image instanceof Image.Elements.NoStroke) {
            return 17;
        }
        if (image instanceof Image.Elements.NoFill) {
            return 18;
        }
        if (image instanceof Image.Elements.Font) {
            return 19;
        }
        if (image instanceof Image.Elements.Debug) {
            return 20;
        }
        if (image == Image$Elements$Empty$.MODULE$) {
            return 21;
        }
        throw new MatchError((Object)image);
    }
}

