/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import cats.Applicative;
import cats.Functor;
import cats.Semigroupal;
import cats.Traverse;
import cats.free.Free;
import cats.free.Free$;
import cats.instances.package;
import cats.syntax.package;
import doodle.core.Angle;
import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.random;
import doodle.syntax.package;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.Predef$;
import scala.Tuple2$;
import scala.Tuple4$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class Spirals$
implements Serializable {
    private static final Function1 linearWeight;
    private static final Function1 quadraticWeight;
    private static final Function1 symmetricDecreasingWeight;
    private static final Free randomSpiral;
    private static final Free smoke;
    private static final Free pts;
    private static final Free image;
    public static final Spirals$ MODULE$;

    private Spirals$() {
    }

    static {
        MODULE$ = new Spirals$();
        linearWeight = (Function1 & Serializable)angle -> angle.toTurns();
        quadraticWeight = (Function1 & Serializable)angle -> angle.toTurns() * angle.toTurns();
        symmetricDecreasingWeight = (Function1 & Serializable)angle -> {
            double t = angle.toTurns();
            double turns = t < 0.5 ? t : t - 0.5;
            return 1.0 - turns;
        };
        randomSpiral = random.Random$.MODULE$.oneOf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{MODULE$.spiral(MODULE$.linearWeight()), MODULE$.spiral(MODULE$.quadraticWeight()), MODULE$.spiral(MODULE$.symmetricDecreasingWeight()), MODULE$.spiral(MODULE$.roseWeight(1)), MODULE$.spiral(MODULE$.roseWeight(3)), MODULE$.spiral(MODULE$.roseWeight(4)), MODULE$.spiral(MODULE$.roseWeight(5))}));
        Free alpha = random.Random$.MODULE$.normal(0.5, 0.1);
        Free hue = random.Random$.MODULE$.double().map((Function1 & Serializable)h -> this.$anonfun$1(BoxesRunTime.unboxToDouble((Object)h)));
        Free saturation = random.Random$.MODULE$.double().map((Function1 & Serializable)s -> this.$anonfun$2(BoxesRunTime.unboxToDouble((Object)s)));
        Free lightness = random.Random$.MODULE$.normal(0.4, 0.1);
        Free color = (Free)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)hue, (Object)saturation, (Object)lightness, (Object)alpha)).mapN((Function4 & Serializable)(h, s, l, a) -> this.$anonfun$3((Angle)h, BoxesRunTime.unboxToDouble((Object)s), BoxesRunTime.unboxToDouble((Object)l), BoxesRunTime.unboxToDouble((Object)a)), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
        Free c = random.Random$.MODULE$.normal(2.0, 1.0).map((Function1 & Serializable)r -> this.$anonfun$4(BoxesRunTime.unboxToDouble((Object)r)));
        smoke = (Free)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)c, (Object)color)).mapN((Function2 & Serializable)(circle, stroke) -> circle.strokeColor((Color)stroke).noFill(), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
        pts = (Free)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).toList().map((Function1 & Serializable)_$1 -> this.$init$$$anonfun$5(BoxesRunTime.unboxToInt((Object)_$1))).foldLeft((Object)random.Random$.MODULE$.always((Object)package$.MODULE$.List().empty()), (Function2 & Serializable)(accum, elt) -> accum.flatMap((Function1 & Serializable)imgs1 -> elt.map((Function1 & Serializable)imgs2 -> (List)imgs1.$plus$plus((IterableOnce)imgs2))));
        image = MODULE$.pts().map((Function1 & Serializable)pt -> (Image)pt.foldLeft((Object)Image$.MODULE$.empty(), (Function2 & Serializable)(_$4, _$5) -> _$4.on((Image)_$5)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Spirals$.class);
    }

    public Function1<Point, Point> scale(double factor) {
        return (Function1 & Serializable)pt -> Point$.MODULE$.polar(pt.r() * factor, pt.angle());
    }

    public Function1<Angle, Point> spiral(Function1<Angle, Object> weight) {
        return (Function1 & Serializable)angle -> Point$.MODULE$.polar(BoxesRunTime.unboxToDouble((Object)weight.apply(angle)), angle);
    }

    public Function1<Angle, Object> linearWeight() {
        return linearWeight;
    }

    public Function1<Angle, Object> quadraticWeight() {
        return quadraticWeight;
    }

    public Function1<Angle, Object> roseWeight(int k) {
        return (Function1 & Serializable)angle -> angle.$times((double)k).cos();
    }

    public Function1<Angle, Object> symmetricDecreasingWeight() {
        return symmetricDecreasingWeight;
    }

    public Free<random.RandomOp, Function1<Angle, Point>> randomSpiral() {
        return randomSpiral;
    }

    public Free<random.RandomOp, Point> jitter(Point point) {
        Free noise = random.Random$.MODULE$.normal(0.0, 10.0);
        return (Free)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)noise, (Object)noise)).mapN((Function2 & Serializable)(dx, dy) -> Point$.MODULE$.cartesian(point.x() + BoxesRunTime.unboxToDouble((Object)dx), point.y() + BoxesRunTime.unboxToDouble((Object)dy)), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
    }

    public Free<random.RandomOp, Image> smoke() {
        return smoke;
    }

    public Free<random.RandomOp, List<Image>> pts() {
        return pts;
    }

    public Free<random.RandomOp, Image> image() {
        return image;
    }

    private final /* synthetic */ Angle $anonfun$1(double h) {
        return package.all$.MODULE$.AngleDoubleOps(h * 0.1 + 0.7).turns();
    }

    private final /* synthetic */ double $anonfun$2(double s) {
        return s * 0.8;
    }

    private final /* synthetic */ Color $anonfun$3(Angle h, double s, double l, double a) {
        return Color$.MODULE$.hsla(h, s, l, a);
    }

    private final /* synthetic */ Image $anonfun$4(double r) {
        return Image$.MODULE$.circle(r);
    }

    private final /* synthetic */ Free $init$$$anonfun$5$$anonfun$1$$anonfun$1(Function1 spiral$1, int angle) {
        Free pt = (Free)spiral$1.andThen(this.scale(200.0)).andThen((Function1 & Serializable)point -> this.jitter((Point)point)).apply((Object)package.all$.MODULE$.AngleIntOps(angle).degrees());
        return (Free)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(this.smoke(), (Object)pt)).mapN((Function2 & Serializable)(_$2, _$3) -> _$2.at(_$3.toVec()), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
    }

    private final /* synthetic */ Free $init$$$anonfun$5(int _$1) {
        return this.randomSpiral().flatMap((Function1 & Serializable)spiral -> (Free)package.all$.MODULE$.toTraverseOps((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 720).by(10).toList().map((Function1 & Serializable)angle -> this.$init$$$anonfun$5$$anonfun$1$$anonfun$1((Function1)spiral, BoxesRunTime.unboxToInt((Object)angle))), (Traverse)package.all$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)Free$.MODULE$.catsFreeMonadForFree()));
    }
}

