/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import cats.Functor;
import cats.Semigroupal;
import cats.free.Free;
import cats.free.Free$;
import cats.syntax.package;
import doodle.core.Angle;
import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Vec;
import doodle.core.Vec$;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.random;
import doodle.syntax.package;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DiffusionLimitedAggregation$
implements Serializable {
    private static final Point start;
    private static final Free seed;
    private static final Free stuckStart;
    private static final double stickRadius;
    private static final Free smoke;
    private static final Free image;
    public static final DiffusionLimitedAggregation$ MODULE$;

    private DiffusionLimitedAggregation$() {
    }

    static {
        MODULE$ = new DiffusionLimitedAggregation$();
        start = Point$.MODULE$.zero();
        seed = random.Random$.MODULE$.double().map((Function1 & Serializable)t -> this.$init$$$anonfun$1(BoxesRunTime.unboxToDouble((Object)t)));
        stuckStart = random.Random$.MODULE$.always((Object)new .colon.colon((Object)Point$.MODULE$.cartesian(0.0, 0.0), (List)new .colon.colon((Object)Point$.MODULE$.cartesian(0.0, 50.0), (List)new .colon.colon((Object)Point$.MODULE$.cartesian(0.0, -50.0), (List)Nil$.MODULE$))));
        stickRadius = 5.0;
        Free alpha = random.Random$.MODULE$.normal(0.5, 0.1);
        Free hue = random.Random$.MODULE$.double().map((Function1 & Serializable)h -> this.$anonfun$1(BoxesRunTime.unboxToDouble((Object)h)));
        Free saturation = random.Random$.MODULE$.double().map((Function1 & Serializable)s -> this.$anonfun$2(BoxesRunTime.unboxToDouble((Object)s)));
        Free lightness = random.Random$.MODULE$.normal(0.4, 0.1);
        Free color = (Free)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)hue, (Object)saturation, (Object)lightness, (Object)alpha)).mapN((Function4 & Serializable)(h, s, l, a) -> this.$anonfun$3((Angle)h, BoxesRunTime.unboxToDouble((Object)s), BoxesRunTime.unboxToDouble((Object)l), BoxesRunTime.unboxToDouble((Object)a)), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
        Free c = random.Random$.MODULE$.normal(1.0, 1.0).map((Function1 & Serializable)r -> this.$anonfun$4(BoxesRunTime.unboxToDouble((Object)r)));
        smoke = (Free)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)c, (Object)color)).mapN((Function2 & Serializable)(circle, line) -> circle.strokeColor((Color)line).noFill(), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
        image = MODULE$.makeImage(1000, 1000);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DiffusionLimitedAggregation$.class);
    }

    public Free<random.RandomOp, Point> brownianMotion(Point start, Vec drift) {
        return this.jitter(start).map((Function1 & Serializable)pt -> pt.$plus(drift));
    }

    public Free<random.RandomOp, Point> jitter(Point point) {
        Free noise = random.Random$.MODULE$.normal(0.0, 10.0);
        return (Free)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)noise, (Object)noise)).mapN((Function2 & Serializable)(dx, dy) -> Point$.MODULE$.cartesian(point.x() + BoxesRunTime.unboxToDouble((Object)dx), point.y() + BoxesRunTime.unboxToDouble((Object)dy)), (Functor)Free$.MODULE$.catsFreeMonadForFree(), (Semigroupal)Free$.MODULE$.catsFreeMonadForFree());
    }

    public Point start() {
        return start;
    }

    public Free<random.RandomOp, Tuple2<Point, Vec>> seed() {
        return seed;
    }

    public Free<random.RandomOp, List<Point>> stuckStart() {
        return stuckStart;
    }

    public double stickRadius() {
        return stickRadius;
    }

    public double distance(Point pt1, Point pt2) {
        return pt1.$minus(pt2).length();
    }

    public boolean isStuck(Point point, List<Point> stuck) {
        return stuck.exists((Function1 & Serializable)pt -> MODULE$.distance(point, (Point)pt) < MODULE$.stickRadius());
    }

    public Free<random.RandomOp, Option<Point>> walk(int maxSteps, List<Point> stuck) {
        return this.seed().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Point start = (Point)tuple2._1();
                Vec drift = (Vec)tuple2._2();
                return this.iter$1(stuck, maxSteps, random.Random$.MODULE$.always((Object)start), drift);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Free<random.RandomOp, List<Point>> dla(int nParticles, int maxSteps, Free<random.RandomOp, List<Point>> stuck) {
        int n;
        while (0 != (n = nParticles)) {
            Free nowStuck = stuck.flatMap((Function1 & Serializable)s -> MODULE$.walk(maxSteps, (List<Point>)s).map((Function1 & Serializable)opt -> {
                Option option = opt;
                if (option instanceof Some) {
                    Point pt = (Point)((Some)option).value();
                    return s.$colon$colon((Object)pt);
                }
                if (None$.MODULE$.equals(option)) {
                    return s;
                }
                throw new MatchError((Object)option);
            }));
            int n2 = nParticles - 1;
            Free free = nowStuck;
            nParticles = n2;
            stuck = free;
        }
        return stuck;
    }

    public Free<random.RandomOp, Image> smoke() {
        return smoke;
    }

    public Free<random.RandomOp, Image> makeImage(int nParticles, int maxSteps) {
        return this.dla(nParticles, maxSteps, this.stuckStart()).flatMap((Function1 & Serializable)pts -> (Free)pts.foldLeft((Object)random.Random$.MODULE$.always((Object)Image$.MODULE$.empty()), (Function2 & Serializable)(accum, pt) -> accum.flatMap((Function1 & Serializable)imgs -> MODULE$.smoke().map((Function1 & Serializable)img -> img.at(pt.toVec()).on((Image)imgs)))));
    }

    public Free<random.RandomOp, Image> image() {
        return image;
    }

    private final /* synthetic */ Tuple2 $init$$$anonfun$1(double t) {
        Angle angle = package.all$.MODULE$.AngleDoubleOps(t).turns();
        Point start = Point$.MODULE$.polar(200.0, angle);
        Vec drift = Vec$.MODULE$.polar(3.0, angle.$plus(package.all$.MODULE$.AngleDoubleOps(0.5).turns()).normalize());
        return Tuple2$.MODULE$.apply((Object)start, (Object)drift);
    }

    private final /* synthetic */ Angle $anonfun$1(double h) {
        return package.all$.MODULE$.AngleDoubleOps(h * 0.1 + 0.6).turns();
    }

    private final /* synthetic */ double $anonfun$2(double s) {
        return s * 0.8;
    }

    private final /* synthetic */ Color $anonfun$3(Angle h, double s, double l, double a) {
        return Color$.MODULE$.hsl(h, s, l, a);
    }

    private final /* synthetic */ Image $anonfun$4(double r) {
        return Image$.MODULE$.circle(Math.abs(r));
    }

    private final Free iter$1(List stuck$1, int step, Free point, Vec drift) {
        int n = step;
        if (0 == n) {
            return random.Random$.MODULE$.always((Object)None$.MODULE$);
        }
        return point.flatMap((Function1 & Serializable)pt -> {
            if (this.isStuck((Point)pt, (List<Point>)stuck$1)) {
                return random.Random$.MODULE$.always((Object)Some$.MODULE$.apply(pt));
            }
            return this.iter$1(stuck$1, step - 1, this.brownianMotion((Point)pt, drift), drift);
        });
    }
}

