/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import doodle.algebra.Picture;
import doodle.core.Angle;
import doodle.core.Cap;
import doodle.core.ClosedPath;
import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Gradient;
import doodle.core.Join;
import doodle.core.Landmark;
import doodle.core.Landmark$;
import doodle.core.OpenPath;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Transform;
import doodle.core.Transform$;
import doodle.core.Vec;
import doodle.core.font.Font;
import doodle.image.Image$;
import doodle.image.Image$Elements$Above$;
import doodle.image.Image$Elements$At$;
import doodle.image.Image$Elements$Beside$;
import doodle.image.Image$Elements$Debug$;
import doodle.image.Image$Elements$FillColor$;
import doodle.image.Image$Elements$FillGradient$;
import doodle.image.Image$Elements$Font$;
import doodle.image.Image$Elements$Margin$;
import doodle.image.Image$Elements$NoFill$;
import doodle.image.Image$Elements$NoStroke$;
import doodle.image.Image$Elements$On$;
import doodle.image.Image$Elements$OriginAt$;
import doodle.image.Image$Elements$Size$;
import doodle.image.Image$Elements$StrokeCap$;
import doodle.image.Image$Elements$StrokeColor$;
import doodle.image.Image$Elements$StrokeDash$;
import doodle.image.Image$Elements$StrokeJoin$;
import doodle.image.Image$Elements$StrokeWidth$;
import doodle.image.Image$Elements$Transform$;
import doodle.language.Basic;
import java.io.Serializable;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public abstract class Image
implements Product,
Serializable {
    public static Image arc(double d, Angle angle) {
        return Image$.MODULE$.arc(d, angle);
    }

    public static Image catmulRom(Seq<Point> seq, double d) {
        return Image$.MODULE$.catmulRom(seq, d);
    }

    public static Image circle(double d) {
        return Image$.MODULE$.circle(d);
    }

    public static Image empty() {
        return Image$.MODULE$.empty();
    }

    public static Image equilateralTriangle(double d) {
        return Image$.MODULE$.equilateralTriangle(d);
    }

    public static Image interpolatingSpline(Seq<Point> seq) {
        return Image$.MODULE$.interpolatingSpline(seq);
    }

    public static Image line(double d, double d2) {
        return Image$.MODULE$.line(d, d2);
    }

    public static int ordinal(Image image) {
        return Image$.MODULE$.ordinal(image);
    }

    public static Image path(ClosedPath closedPath) {
        return Image$.MODULE$.path(closedPath);
    }

    public static Image path(OpenPath openPath) {
        return Image$.MODULE$.path(openPath);
    }

    public static Image pie(double d, Angle angle) {
        return Image$.MODULE$.pie(d, angle);
    }

    public static Image rectangle(double d, double d2) {
        return Image$.MODULE$.rectangle(d, d2);
    }

    public static Image regularPolygon(int n, double d) {
        return Image$.MODULE$.regularPolygon(n, d);
    }

    public static Image rightArrow(double d, double d2) {
        return Image$.MODULE$.rightArrow(d, d2);
    }

    public static Image roundedRectangle(double d, double d2, double d3) {
        return Image$.MODULE$.roundedRectangle(d, d2, d3);
    }

    public static Image square(double d) {
        return Image$.MODULE$.square(d);
    }

    public static Image star(int n, double d, double d2) {
        return Image$.MODULE$.star(n, d, d2);
    }

    public static Image text(String string) {
        return Image$.MODULE$.text(string);
    }

    public static Image triangle(double d, double d2) {
        return Image$.MODULE$.triangle(d, d2);
    }

    public static double catmulRom$default$2() {
        return Image$.MODULE$.catmulRom$default$2();
    }

    public Image beside(Image right) {
        return Image$Elements$Beside$.MODULE$.apply(this, right);
    }

    public Image on(Image bottom) {
        return Image$Elements$On$.MODULE$.apply(this, bottom);
    }

    public Image under(Image top) {
        return Image$Elements$On$.MODULE$.apply(top, this);
    }

    public Image above(Image bottom) {
        return Image$Elements$Above$.MODULE$.apply(this, bottom);
    }

    public Image below(Image top) {
        return Image$Elements$Above$.MODULE$.apply(top, this);
    }

    public Image margin(double top, double right, double bottom, double left) {
        return Image$Elements$Margin$.MODULE$.apply(this, top, right, bottom, left);
    }

    public Image margin(double width, double height) {
        return Image$Elements$Margin$.MODULE$.apply(this, height, width, height, width);
    }

    public Image margin(double width) {
        return Image$Elements$Margin$.MODULE$.apply(this, width, width, width, width);
    }

    public Image size(double width, double height) {
        return Image$Elements$Size$.MODULE$.apply(this, width, height);
    }

    public Image strokeColor(Color color) {
        return Image$Elements$StrokeColor$.MODULE$.apply(this, color);
    }

    public Image strokeWidth(double width) {
        return Image$Elements$StrokeWidth$.MODULE$.apply(this, width);
    }

    public <A> Image strokeCap(Cap strokeCap) {
        return Image$Elements$StrokeCap$.MODULE$.apply(this, strokeCap);
    }

    public <A> Image strokeJoin(Join strokeJoin) {
        return Image$Elements$StrokeJoin$.MODULE$.apply(this, strokeJoin);
    }

    public <A> Image strokeDash(Iterable<Object> pattern) {
        return Image$Elements$StrokeDash$.MODULE$.apply(this, pattern);
    }

    public Image fillColor(Color color) {
        return Image$Elements$FillColor$.MODULE$.apply(this, color);
    }

    public Image fillGradient(Gradient gradient) {
        return Image$Elements$FillGradient$.MODULE$.apply(this, gradient);
    }

    public Image noStroke() {
        return Image$Elements$NoStroke$.MODULE$.apply(this);
    }

    public Image noFill() {
        return Image$Elements$NoFill$.MODULE$.apply(this);
    }

    public Image font(Font font) {
        return Image$Elements$Font$.MODULE$.apply(this, font);
    }

    public Image transform(Transform tx) {
        return Image$Elements$Transform$.MODULE$.apply(tx, this);
    }

    public Image rotate(Angle angle) {
        return this.transform(Transform$.MODULE$.rotate(angle));
    }

    public Image scale(double x, double y) {
        return this.transform(Transform$.MODULE$.scale(x, y));
    }

    public Image at(Landmark landmark) {
        return Image$Elements$At$.MODULE$.apply(this, landmark);
    }

    public Image at(Vec vec) {
        return this.at(vec.x(), vec.y());
    }

    public Image at(Point pt) {
        return this.at(pt.x(), pt.y());
    }

    public Image at(double x, double y) {
        return this.at(Landmark$.MODULE$.point(x, y));
    }

    public Image at(double r, Angle a) {
        Point pt = Point$.MODULE$.apply(r, a);
        return this.at(pt.x(), pt.y());
    }

    public Image originAt(Landmark landmark) {
        return Image$Elements$OriginAt$.MODULE$.apply(this, landmark);
    }

    public Image originAt(Vec vec) {
        return this.originAt(vec.x(), vec.y());
    }

    public Image originAt(Point pt) {
        return this.originAt(pt.x(), pt.y());
    }

    public Image originAt(double x, double y) {
        return this.originAt(Landmark$.MODULE$.point(x, y));
    }

    public Image originAt(double r, Angle a) {
        Point pt = Point$.MODULE$.apply(r, a);
        return this.originAt(pt.x(), pt.y());
    }

    public Image debug(Color color) {
        return Image$Elements$Debug$.MODULE$.apply(this, color);
    }

    public Image debug() {
        return Image$Elements$Debug$.MODULE$.apply(this, Color$.MODULE$.crimson());
    }

    public <Algebra extends Basic> Picture<Algebra, BoxedUnit> compile() {
        return Image$.MODULE$.compile(this);
    }
}

