/*
 * Decompiled with CFR 0.152.
 */
package doodle.java2d.algebra;

import doodle.algebra.generic.DrawingContext;
import doodle.algebra.generic.Fill;
import doodle.algebra.generic.Stroke;
import doodle.core.BoundingBox;
import doodle.core.BoundingBox$;
import doodle.core.Cap;
import doodle.core.Color;
import doodle.core.Gradient;
import doodle.core.Join;
import doodle.core.Normalized$;
import doodle.core.PathElement;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.core.UnsignedByte$;
import doodle.core.font.FontFamily;
import doodle.core.font.FontSize;
import doodle.core.font.FontStyle;
import doodle.core.font.FontWeight;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class Java2D$ {
    public static Java2D$ MODULE$;

    static {
        new Java2D$();
    }

    public FontMetrics fontMetrics(Graphics2D gc, doodle.core.font.Font font) {
        return gc.getFontMetrics(this.toAwtFont(font));
    }

    public BoundingBox textBoundingBox(Graphics2D gc, String text, doodle.core.font.Font font) {
        Rectangle2D bounds = this.textBounds(gc, text, font);
        return BoundingBox$.MODULE$.centered(bounds.getWidth(), bounds.getHeight());
    }

    public Rectangle2D textBounds(Graphics2D gc, String text, doodle.core.font.Font font) {
        FontMetrics metrics = this.fontMetrics(gc, font);
        return metrics.getStringBounds(text, gc);
    }

    public Font toAwtFont(doodle.core.font.Font font) {
        int pts;
        int n;
        String string;
        FontFamily fontFamily = font.family();
        if (FontFamily.Serif$.MODULE$.equals(fontFamily)) {
            string = "Serif";
        } else if (FontFamily.SansSerif$.MODULE$.equals(fontFamily)) {
            string = "SansSerif";
        } else if (FontFamily.Monospaced$.MODULE$.equals(fontFamily)) {
            string = "Monospaced";
        } else if (fontFamily instanceof FontFamily.Named) {
            String name;
            FontFamily.Named named = (FontFamily.Named)fontFamily;
            string = name = named.get();
        } else {
            throw new MatchError((Object)fontFamily);
        }
        String awtFamily = string;
        FontWeight fontWeight = font.weight();
        if (FontWeight.Normal$.MODULE$.equals(fontWeight)) {
            int n2;
            FontStyle fontStyle = font.style();
            if (FontStyle.Italic$.MODULE$.equals(fontStyle)) {
                n2 = 2;
            } else if (FontStyle.Normal$.MODULE$.equals(fontStyle)) {
                n2 = 0;
            } else {
                throw new MatchError((Object)fontStyle);
            }
            n = n2;
        } else if (FontWeight.Bold$.MODULE$.equals(fontWeight)) {
            int n3;
            FontStyle fontStyle = font.style();
            if (FontStyle.Italic$.MODULE$.equals(fontStyle)) {
                n3 = 3;
            } else if (FontStyle.Normal$.MODULE$.equals(fontStyle)) {
                n3 = 1;
            } else {
                throw new MatchError((Object)fontStyle);
            }
            n = n3;
        } else {
            throw new MatchError((Object)fontWeight);
        }
        int awtStyle = n;
        FontSize fontSize = font.size();
        if (!(fontSize instanceof FontSize.Points)) {
            throw new MatchError((Object)fontSize);
        }
        FontSize.Points points = (FontSize.Points)fontSize;
        int n4 = pts = points.get();
        int awtSize = n4;
        return new Font(awtFamily, awtStyle, awtSize);
    }

    public Point2D toPoint2D(Point point) {
        return new Point2D.Double(point.x(), point.y());
    }

    public Color toAwtColor(doodle.core.Color color) {
        Color.RGBA rgba = color.toRGBA();
        return new Color(UnsignedByte$.MODULE$.get$extension(rgba.r()), UnsignedByte$.MODULE$.get$extension(rgba.g()), UnsignedByte$.MODULE$.get$extension(rgba.b()), UnsignedByte$.MODULE$.get$extension(Normalized$.MODULE$.toUnsignedByte$extension(rgba.a())));
    }

    public void setStroke(Graphics2D graphics, Stroke stroke) {
        BasicStroke basicStroke;
        int n;
        int n2;
        float width = (float)stroke.width();
        Cap cap = stroke.cap();
        if (Cap.Butt$.MODULE$.equals(cap)) {
            n2 = 0;
        } else if (Cap.Round$.MODULE$.equals(cap)) {
            n2 = 1;
        } else if (Cap.Square$.MODULE$.equals(cap)) {
            n2 = 2;
        } else {
            throw new MatchError((Object)cap);
        }
        int cap2 = n2;
        Join join = stroke.join();
        if (Join.Bevel$.MODULE$.equals(join)) {
            n = 2;
        } else if (Join.Miter$.MODULE$.equals(join)) {
            n = 0;
        } else if (Join.Round$.MODULE$.equals(join)) {
            n = 1;
        } else {
            throw new MatchError((Object)join);
        }
        int join2 = n;
        Option option = stroke.dash();
        if (None$.MODULE$.equals(option)) {
            basicStroke = new BasicStroke(width, cap2, join2);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            float[] dash = (float[])some.value();
            basicStroke = new BasicStroke(width, cap2, join2, 1.0f, dash, 0.0f);
        } else {
            throw new MatchError((Object)option);
        }
        BasicStroke jStroke = basicStroke;
        Color jColor = this.toAwtColor(stroke.color());
        graphics.setStroke(jStroke);
        graphics.setColor(jColor);
    }

    public void setFill(Graphics2D graphics, Fill fill) {
        Paint paint;
        Fill fill2 = fill;
        if (fill2 instanceof Fill.ColorFill) {
            Fill.ColorFill colorFill = (Fill.ColorFill)fill2;
            doodle.core.Color c = colorFill.color();
            paint = this.toAwtColor(c);
        } else if (fill2 instanceof Fill.GradientFill) {
            MultipleGradientPaint multipleGradientPaint;
            Fill.GradientFill gradientFill = (Fill.GradientFill)fill2;
            Gradient g = gradientFill.gradient();
            Gradient gradient = g;
            if (gradient instanceof Gradient.Linear) {
                Gradient.Linear linear = (Gradient.Linear)gradient;
                multipleGradientPaint = this.toLinearGradientPaint(linear);
            } else if (gradient instanceof Gradient.Radial) {
                Gradient.Radial radial = (Gradient.Radial)gradient;
                multipleGradientPaint = this.toRadialGradientPaint(radial);
            } else {
                throw new MatchError((Object)gradient);
            }
            paint = multipleGradientPaint;
        } else {
            throw new MatchError((Object)fill2);
        }
        Color paint2 = paint;
        graphics.setPaint(paint2);
    }

    public MultipleGradientPaint.CycleMethod toCycleMethod(Gradient.CycleMethod cycleMethod) {
        MultipleGradientPaint.CycleMethod cycleMethod2;
        Gradient.CycleMethod cycleMethod3 = cycleMethod;
        if (Gradient.CycleMethod$.NoCycle$.MODULE$.equals(cycleMethod3)) {
            cycleMethod2 = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        } else if (Gradient.CycleMethod$.Reflect$.MODULE$.equals(cycleMethod3)) {
            cycleMethod2 = MultipleGradientPaint.CycleMethod.REFLECT;
        } else if (Gradient.CycleMethod$.Repeat$.MODULE$.equals(cycleMethod3)) {
            cycleMethod2 = MultipleGradientPaint.CycleMethod.REPEAT;
        } else {
            throw new MatchError((Object)cycleMethod3);
        }
        return cycleMethod2;
    }

    public LinearGradientPaint toLinearGradientPaint(Gradient.Linear gradient) {
        Point2D start = this.toPoint2D(gradient.start());
        Point2D end = this.toPoint2D(gradient.end());
        float[] fractions = (float[])((TraversableOnce)((TraversableLike)gradient.stops().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._2$mcD$sp()), Seq$.MODULE$.canBuildFrom())).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$2 -> (float)x$2, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
        Color[] colors = (Color[])((TraversableOnce)((TraversableLike)gradient.stops().map((Function1 & Serializable & scala.Serializable)x$3 -> (doodle.core.Color)x$3._1(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.toAwtColor((doodle.core.Color)x$4), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Color.class));
        MultipleGradientPaint.CycleMethod cycleMethod = this.toCycleMethod(gradient.cycleMethod());
        return new LinearGradientPaint(start, end, fractions, colors, cycleMethod);
    }

    public RadialGradientPaint toRadialGradientPaint(Gradient.Radial gradient) {
        Point2D center = this.toPoint2D(gradient.outer());
        Point2D focus = this.toPoint2D(gradient.inner());
        float radius = (float)gradient.radius();
        float[] fractions = (float[])((TraversableOnce)((TraversableLike)gradient.stops().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5._2$mcD$sp()), Seq$.MODULE$.canBuildFrom())).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$6 -> (float)x$6, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
        Color[] colors = (Color[])((TraversableOnce)((TraversableLike)gradient.stops().map((Function1 & Serializable & scala.Serializable)x$7 -> (doodle.core.Color)x$7._1(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.toAwtColor((doodle.core.Color)x$8), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Color.class));
        MultipleGradientPaint.CycleMethod cycleMethod = this.toCycleMethod(gradient.cycleMethod());
        return new RadialGradientPaint(center, radius, focus, fractions, colors, cycleMethod);
    }

    /*
     * WARNING - void declaration
     */
    public Path2D toPath2D(List<PathElement> elements) {
        void var2_2;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(0.0, 0.0);
        elements.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Java2D$.$anonfun$toPath2D$1(path, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public AffineTransform toAffineTransform(Transform transform) {
        double[] elts = transform.elements();
        return new AffineTransform(elts[0], elts[3], elts[1], elts[4], elts[2], elts[5]);
    }

    public void withTransform(Graphics2D graphics, Transform transform, Function0<BoxedUnit> f) {
        AffineTransform original = graphics.getTransform();
        graphics.transform(this.toAffineTransform(transform));
        f.apply$mcV$sp();
        graphics.setTransform(original);
    }

    public void strokeAndFill(Graphics2D graphics, Path2D path, DrawingContext current) {
        current.stroke().foreach((Function1 & Serializable & scala.Serializable)s -> {
            Java2D$.$anonfun$strokeAndFill$1(graphics, path, s);
            return BoxedUnit.UNIT;
        });
        current.fill().foreach((Function1 & Serializable & scala.Serializable)f -> {
            Java2D$.$anonfun$strokeAndFill$2(graphics, path, f);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$toPath2D$1(Path2D.Double path$1, PathElement x0$1) {
        PathElement.LineTo lineTo;
        Point point;
        Option option;
        PathElement.MoveTo moveTo;
        Point point2;
        Option option2;
        PathElement pathElement = x0$1;
        if (pathElement instanceof PathElement.MoveTo && !(option2 = Point.extractors$.Cartesian$.MODULE$.unapply(point2 = (moveTo = (PathElement.MoveTo)pathElement).to())).isEmpty()) {
            double x = ((Tuple2)option2.get())._1$mcD$sp();
            double y = ((Tuple2)option2.get())._2$mcD$sp();
            path$1.moveTo(x, y);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if (pathElement instanceof PathElement.LineTo && !(option = Point.extractors$.Cartesian$.MODULE$.unapply(point = (lineTo = (PathElement.LineTo)pathElement).to())).isEmpty()) {
            double x = ((Tuple2)option.get())._1$mcD$sp();
            double y = ((Tuple2)option.get())._2$mcD$sp();
            path$1.lineTo(x, y);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            if (!(pathElement instanceof PathElement.BezierCurveTo)) throw new MatchError((Object)pathElement);
            PathElement.BezierCurveTo bezierCurveTo = (PathElement.BezierCurveTo)pathElement;
            Point point3 = bezierCurveTo.cp1();
            Point point4 = bezierCurveTo.cp2();
            Point point5 = bezierCurveTo.to();
            Option option3 = Point.extractors$.Cartesian$.MODULE$.unapply(point3);
            if (option3.isEmpty()) throw new MatchError((Object)pathElement);
            double cp1x = ((Tuple2)option3.get())._1$mcD$sp();
            double cp1y = ((Tuple2)option3.get())._2$mcD$sp();
            Option option4 = Point.extractors$.Cartesian$.MODULE$.unapply(point4);
            if (option4.isEmpty()) throw new MatchError((Object)pathElement);
            double cp2x = ((Tuple2)option4.get())._1$mcD$sp();
            double cp2y = ((Tuple2)option4.get())._2$mcD$sp();
            Option option5 = Point.extractors$.Cartesian$.MODULE$.unapply(point5);
            if (option5.isEmpty()) throw new MatchError((Object)pathElement);
            double endX = ((Tuple2)option5.get())._1$mcD$sp();
            double endY = ((Tuple2)option5.get())._2$mcD$sp();
            path$1.curveTo(cp1x, cp1y, cp2x, cp2y, endX, endY);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$strokeAndFill$1(Graphics2D graphics$1, Path2D path$2, Stroke s) {
        MODULE$.setStroke(graphics$1, s);
        graphics$1.draw(path$2);
    }

    public static final /* synthetic */ void $anonfun$strokeAndFill$2(Graphics2D graphics$1, Path2D path$2, Fill f) {
        MODULE$.setFill(graphics$1, f);
        graphics$1.fill(path$2);
    }

    private Java2D$() {
        MODULE$ = this;
    }
}

