/*
 * Decompiled with CFR 0.152.
 */
package doodle.java2d.effect;

import cats.Eval;
import cats.Eval$;
import cats.FlatMap;
import cats.data.IndexedStateT;
import cats.data.WriterT;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime;
import doodle.algebra.Algebra;
import doodle.algebra.Bitmap;
import doodle.algebra.Picture;
import doodle.algebra.generic.DrawingContext;
import doodle.core.BoundingBox;
import doodle.core.Color;
import doodle.core.Normalized$;
import doodle.core.Transform;
import doodle.core.Transform$;
import doodle.java2d.algebra.Algebra$;
import doodle.java2d.algebra.Java2D$;
import doodle.java2d.algebra.reified.Reified;
import doodle.java2d.effect.Frame;
import doodle.java2d.effect.Java2DPanel$RenderRequest$;
import doodle.java2d.effect.Java2DPanel$RenderResult$;
import doodle.java2d.effect.Java2d$;
import doodle.java2d.effect.Redraw;
import doodle.java2d.effect.Redraw$ClearToBackground$;
import doodle.java2d.effect.Redraw$ClearToColor$;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class Java2DPanel
extends JPanel {
    private final Frame frame;
    private final IORuntime runtime;
    private final LinkedBlockingQueue<RenderRequest<?>> channel;
    private final ArrayBuffer<Tuple2<BoundingBox, List<Reified>>> pictures;
    private final boolean opaqueRedraw;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Java2DPanel(Frame frame, IORuntime runtime) {
        boolean bl;
        this.frame = frame;
        this.runtime = runtime;
        this.channel = new LinkedBlockingQueue(1);
        this.pictures = new ArrayBuffer(1);
        Redraw redraw = frame.redraw();
        if (Redraw$ClearToBackground$.MODULE$.equals(redraw)) {
            Option<Color> option = frame.background();
            if (None$.MODULE$.equals(option)) {
                bl = true;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                Color c = (Color)((Some)option).value();
                bl = c.alpha() == Normalized$.MODULE$.MaxValue();
            }
        } else {
            if (!(redraw instanceof Redraw.ClearToColor)) throw new MatchError((Object)redraw);
            Redraw.ClearToColor clearToColor = Redraw$ClearToColor$.MODULE$.unapply((Redraw.ClearToColor)redraw);
            Color color = clearToColor._1();
            Color c = color;
            bl = c.alpha() == Normalized$.MODULE$.MaxValue();
        }
        this.opaqueRedraw = bl;
    }

    public void resize(double width, double height) {
        this.setPreferredSize(new Dimension((int)width, (int)height));
        SwingUtilities.windowForComponent(this).pack();
    }

    public <A> void render(RenderRequest<A> request) {
        this.channel.put(request);
        this.repaint();
    }

    public void draw(Graphics2D gc) {
        this.frame.background().foreach((Function1)(JProcedure1 & Serializable)c -> {
            gc.setColor(Java2D$.MODULE$.toAwtColor((Color)c));
            gc.fillRect(0, 0, this.getWidth(), this.getHeight());
        });
        int n = this.pictures.size();
        if (0 != n) {
            if (1 == n) {
                Tuple2 tuple2 = (Tuple2)this.pictures.apply(0);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BoundingBox bb = (BoundingBox)tuple2._1();
                List reified = (List)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)bb, (Object)reified);
                BoundingBox bb2 = (BoundingBox)tuple22._1();
                List reified2 = (List)tuple22._2();
                Transform tx = Java2d$.MODULE$.transform(bb2, this.getWidth(), this.getHeight(), this.frame.center());
                Java2d$.MODULE$.render(gc, (List<Reified>)reified2, tx);
            } else {
                Tuple2 tuple2 = (Tuple2)this.pictures.apply(0);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BoundingBox bb = (BoundingBox)tuple2._1();
                List reified = (List)tuple2._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)bb, (Object)reified);
                BoundingBox bb3 = (BoundingBox)tuple23._1();
                List reified3 = (List)tuple23._2();
                Transform tx = Java2d$.MODULE$.transform(bb3, this.getWidth(), this.getHeight(), this.frame.center());
                Java2d$.MODULE$.render(gc, (List<Reified>)reified3, tx);
                for (int i = 0; i < this.pictures.size(); ++i) {
                    Redraw redraw = this.frame.redraw();
                    if (Redraw$ClearToBackground$.MODULE$.equals(redraw)) {
                        this.frame.background().foreach((Function1)(JProcedure1 & Serializable)c -> {
                            gc.setColor(Java2D$.MODULE$.toAwtColor((Color)c));
                            gc.fillRect(0, 0, this.getWidth(), this.getHeight());
                        });
                    } else if (redraw instanceof Redraw.ClearToColor) {
                        Color color;
                        Redraw.ClearToColor clearToColor = Redraw$ClearToColor$.MODULE$.unapply((Redraw.ClearToColor)redraw);
                        Color c2 = color = clearToColor._1();
                        gc.setColor(Java2D$.MODULE$.toAwtColor(c2));
                        gc.fillRect(0, 0, this.getWidth(), this.getHeight());
                    } else {
                        throw new MatchError((Object)redraw);
                    }
                    Tuple2 tuple24 = (Tuple2)this.pictures.apply(i);
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    BoundingBox bb4 = (BoundingBox)tuple24._1();
                    List reified4 = (List)tuple24._2();
                    Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)bb4, (Object)reified4);
                    BoundingBox bb5 = (BoundingBox)tuple25._1();
                    List reified5 = (List)tuple25._2();
                    Transform tx2 = Java2d$.MODULE$.transform(bb5, this.getWidth(), this.getHeight(), this.frame.center());
                    Java2d$.MODULE$.render(gc, (List<Reified>)reified5, tx2);
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics context) {
        BoxedUnit boxedUnit;
        Graphics2D gc = (Graphics2D)context;
        Java2d$.MODULE$.setup(gc);
        doodle.java2d.algebra.Algebra algebra = Algebra$.MODULE$.apply(gc, Algebra$.MODULE$.$lessinit$greater$default$2(), Algebra$.MODULE$.$lessinit$greater$default$3());
        RenderRequest<?> rr = this.channel.poll(10L, TimeUnit.MILLISECONDS);
        if (rr == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            RenderResult result = (RenderResult)rr.render(algebra).unsafeRunSync(this.runtime);
            BoundingBox bb = result.boundingBox();
            List<Reified> picture = result.reified();
            this.resize(result.width(), result.height());
            if (this.opaqueRedraw && this.pictures.size() > 0) {
                this.pictures.update(0, (Object)Tuple2$.MODULE$.apply((Object)bb, picture));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = this.pictures.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)bb, picture));
            }
        }
        this.draw(gc);
    }

    public static final class RenderRequest<A>
    implements Product,
    Serializable {
        private final Picture picture;
        private final Frame frame;
        private final Function1 cb;

        public static <A> RenderRequest<A> apply(Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> picture, Frame frame, Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> function1) {
            return Java2DPanel$RenderRequest$.MODULE$.apply(picture, frame, function1);
        }

        public static RenderRequest<?> fromProduct(Product product) {
            return Java2DPanel$RenderRequest$.MODULE$.fromProduct(product);
        }

        public static <A> RenderRequest<A> unapply(RenderRequest<A> renderRequest) {
            return Java2DPanel$RenderRequest$.MODULE$.unapply(renderRequest);
        }

        public RenderRequest(Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> picture, Frame frame, Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> cb) {
            this.picture = picture;
            this.frame = frame;
            this.cb = cb;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RenderRequest)) return false;
            RenderRequest renderRequest = (RenderRequest)object;
            Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> picture = this.picture();
            Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> picture2 = renderRequest.picture();
            if (picture == null) {
                if (picture2 != null) {
                    return false;
                }
            } else if (!picture.equals(picture2)) return false;
            Frame frame = this.frame();
            Frame frame2 = renderRequest.frame();
            if (frame == null) {
                if (frame2 != null) {
                    return false;
                }
            } else if (!((Object)frame).equals(frame2)) return false;
            Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> function1 = this.cb();
            Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> function12 = renderRequest.cb();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RenderRequest;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "RenderRequest";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "picture";
                    break;
                }
                case 1: {
                    string = "frame";
                    break;
                }
                case 2: {
                    string = "cb";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> picture() {
            return this.picture;
        }

        public Frame frame() {
            return this.frame;
        }

        public Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> cb() {
            return this.cb;
        }

        public IO<RenderResult<A>> render(doodle.java2d.algebra.Algebra algebra) {
            return IO$.MODULE$.apply(() -> this.render$$anonfun$1(algebra));
        }

        public <A> RenderRequest<A> copy(Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> picture, Frame frame, Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> cb) {
            return new RenderRequest<A>(picture, frame, cb);
        }

        public <A> Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> copy$default$1() {
            return this.picture();
        }

        public <A> Frame copy$default$2() {
            return this.frame();
        }

        public <A> Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> copy$default$3() {
            return this.cb();
        }

        public Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> _1() {
            return this.picture();
        }

        public Frame _2() {
            return this.frame();
        }

        public Function1<Either<Throwable, RenderResult<A>>, BoxedUnit> _3() {
            return this.cb();
        }

        private final RenderResult render$$anonfun$1(doodle.java2d.algebra.Algebra algebra$1) {
            IndexedStateT drawing = (IndexedStateT)this.picture().apply((Algebra)algebra$1);
            Tuple2 tuple2 = (Tuple2)((Eval)drawing.runA((Object)package$.MODULE$.List().empty(), (FlatMap)Eval$.MODULE$.catsBimonadForEval())).value();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BoundingBox bb = (BoundingBox)tuple2._1();
            IndexedStateT rdr = (IndexedStateT)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)bb, (Object)rdr);
            BoundingBox bb2 = (BoundingBox)tuple22._1();
            IndexedStateT rdr2 = (IndexedStateT)tuple22._2();
            Tuple2<Object, Object> tuple23 = Java2d$.MODULE$.size(bb2, this.frame().size());
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            double w = BoxesRunTime.unboxToDouble((Object)tuple23._1());
            double h = BoxesRunTime.unboxToDouble((Object)tuple23._2());
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)w), (Object)BoxesRunTime.boxToDouble((double)h));
            double w2 = BoxesRunTime.unboxToDouble((Object)tuple24._1());
            double h2 = BoxesRunTime.unboxToDouble((Object)tuple24._2());
            Tuple2 tuple25 = (Tuple2)((Eval)rdr2.run((Object)Transform$.MODULE$.identity(), (FlatMap)Eval$.MODULE$.catsBimonadForEval())).value();
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            WriterT fa = (WriterT)tuple25._2();
            WriterT fa2 = fa;
            Tuple2 tuple26 = (Tuple2)((Eval)fa2.run()).value();
            if (tuple26 == null) {
                throw new MatchError((Object)tuple26);
            }
            List reified = (List)tuple26._1();
            Object a = tuple26._2();
            Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)reified, a);
            List reified2 = (List)tuple27._1();
            Object a2 = tuple27._2();
            RenderResult<Object> result = Java2DPanel$RenderResult$.MODULE$.apply(bb2, w2, h2, (List<Reified>)reified2, a2);
            this.cb().apply((Object)package$.MODULE$.Right().apply(result));
            return result;
        }
    }

    public static final class RenderResult<A>
    implements Product,
    Serializable {
        private final BoundingBox boundingBox;
        private final double width;
        private final double height;
        private final List reified;
        private final Object value;

        public static <A> RenderResult<A> apply(BoundingBox boundingBox, double d, double d2, List<Reified> list, A a) {
            return Java2DPanel$RenderResult$.MODULE$.apply(boundingBox, d, d2, list, a);
        }

        public static RenderResult<?> fromProduct(Product product) {
            return Java2DPanel$RenderResult$.MODULE$.fromProduct(product);
        }

        public static <A> RenderResult<A> unapply(RenderResult<A> renderResult) {
            return Java2DPanel$RenderResult$.MODULE$.unapply(renderResult);
        }

        public RenderResult(BoundingBox boundingBox, double width, double height, List<Reified> reified, A value) {
            this.boundingBox = boundingBox;
            this.width = width;
            this.height = height;
            this.reified = reified;
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.boundingBox()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.width()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.height()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.reified()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.value()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RenderResult)) return false;
            RenderResult renderResult = (RenderResult)object;
            if (this.width() != renderResult.width()) return false;
            if (this.height() != renderResult.height()) return false;
            BoundingBox boundingBox = this.boundingBox();
            BoundingBox boundingBox2 = renderResult.boundingBox();
            if (boundingBox == null) {
                if (boundingBox2 != null) {
                    return false;
                }
            } else if (!boundingBox.equals(boundingBox2)) return false;
            List<Reified> list = this.reified();
            List<Reified> list2 = renderResult.reified();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!BoxesRunTime.equals(this.value(), renderResult.value())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RenderResult;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "RenderResult";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToDouble((double)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "boundingBox";
                    break;
                }
                case 1: {
                    string = "width";
                    break;
                }
                case 2: {
                    string = "height";
                    break;
                }
                case 3: {
                    string = "reified";
                    break;
                }
                case 4: {
                    string = "value";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public BoundingBox boundingBox() {
            return this.boundingBox;
        }

        public double width() {
            return this.width;
        }

        public double height() {
            return this.height;
        }

        public List<Reified> reified() {
            return this.reified;
        }

        public A value() {
            return (A)this.value;
        }

        public <A> RenderResult<A> copy(BoundingBox boundingBox, double width, double height, List<Reified> reified, A value) {
            return new RenderResult<A>(boundingBox, width, height, reified, value);
        }

        public <A> BoundingBox copy$default$1() {
            return this.boundingBox();
        }

        public double copy$default$2() {
            return this.width();
        }

        public double copy$default$3() {
            return this.height();
        }

        public <A> List<Reified> copy$default$4() {
            return this.reified();
        }

        public <A> A copy$default$5() {
            return this.value();
        }

        public BoundingBox _1() {
            return this.boundingBox();
        }

        public double _2() {
            return this.width();
        }

        public double _3() {
            return this.height();
        }

        public List<Reified> _4() {
            return this.reified();
        }

        public A _5() {
            return this.value();
        }
    }
}

