/*
 * Decompiled with CFR 0.152.
 */
package doodle.java2d.effect;

import cats.NonEmptyParallel;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.syntax.package;
import doodle.algebra.Bitmap;
import doodle.algebra.Picture;
import doodle.core.Point;
import doodle.java2d.effect.BlockingCircularQueue;
import doodle.java2d.effect.Canvas$;
import doodle.java2d.effect.Frame;
import doodle.java2d.effect.Java2dWindow;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Topic;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;
import scala.Tuple3$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class Canvas {
    private final Frame frame;
    private final Topic<IO, Object> redrawTopic;
    private final Topic<IO, Point> mouseClickTopic;
    private final Topic<IO, Point> mouseMoveTopic;
    private final BlockingCircularQueue<Object> redrawQueue;
    private final BlockingCircularQueue<Point> mouseClickQueue;
    private final BlockingCircularQueue<Point> mouseMoveQueue;
    private Java2dWindow window;
    private IO<Object> windowClosed;
    private final IO closed;
    private final Stream stream;
    private final Stream redraw;
    private final Stream mouseClick;
    private final Stream mouseMove;

    public static Resource<IO, Canvas> apply(Frame frame) {
        return Canvas$.MODULE$.apply(frame);
    }

    public Canvas(Frame frame, Topic<IO, Object> redrawTopic, Topic<IO, Point> mouseClickTopic, Topic<IO, Point> mouseMoveTopic) {
        this.frame = frame;
        this.redrawTopic = redrawTopic;
        this.mouseClickTopic = mouseClickTopic;
        this.mouseMoveTopic = mouseMoveTopic;
        this.redrawQueue = this.eventQueue(ClassTag$.MODULE$.apply(Integer.TYPE));
        this.mouseClickQueue = this.eventQueue(ClassTag$.MODULE$.apply(Point.class));
        this.mouseMoveQueue = this.eventQueue(ClassTag$.MODULE$.apply(Point.class));
        SwingUtilities.invokeAndWait(() -> {
            this.window = new Java2dWindow(frame, new package.DurationDouble(package$.MODULE$.DurationDouble(16.67)).milliseconds(), this.redrawQueue, this.mouseClickQueue, this.mouseMoveQueue);
            this.windowClosed = IO$.MODULE$.fromCompletableFuture(IO$.MODULE$.blocking(this::$init$$$anonfun$1$$anonfun$1));
        });
        this.closed = this.windowClosed.void();
        Stream redraw = this.pump(this.redrawQueue, redrawTopic).drain();
        Stream mouseClick = this.pump(this.mouseClickQueue, mouseClickTopic).drain();
        Stream mouseMove = this.pump(this.mouseMoveQueue, mouseMoveTopic).drain();
        Stream closeStream = Stream$.MODULE$.eval((Object)this.windowClosed.$greater$greater(() -> Canvas.$anonfun$1(redrawTopic, mouseClickTopic, mouseMoveTopic))).drain();
        this.stream = redraw.merge(mouseClick, (GenConcurrent)IO$.MODULE$.asyncForIO()).merge(mouseMove, (GenConcurrent)IO$.MODULE$.asyncForIO()).merge(closeStream, (GenConcurrent)IO$.MODULE$.asyncForIO());
        IO interruptWhen = this.windowClosed.void().attempt();
        this.redraw = redrawTopic.subscribe(4).interruptWhen((Object)interruptWhen);
        this.mouseClick = mouseClickTopic.subscribe(4).interruptWhen((Object)interruptWhen);
        this.mouseMove = mouseMoveTopic.subscribe(4).interruptWhen((Object)interruptWhen);
    }

    private <A> BlockingCircularQueue<A> eventQueue(ClassTag<A> evidence$1) {
        return new BlockingCircularQueue<A>(8, evidence$1);
    }

    public IO<BoxedUnit> closed() {
        return this.closed;
    }

    public <A> Stream<IO, A> pump(BlockingCircularQueue<A> queue, Topic<IO, A> topic) {
        return Stream$.MODULE$.repeatEval((Object)IO$.MODULE$.interruptible(() -> Canvas.pump$$anonfun$1(queue))).through(topic.publish());
    }

    public Stream<IO, Nothing$> stream() {
        return this.stream;
    }

    public Stream<IO, Object> redraw() {
        return this.redraw;
    }

    public Stream<IO, Point> mouseClick() {
        return this.mouseClick;
    }

    public Stream<IO, Point> mouseMove() {
        return this.mouseMove;
    }

    public <A> IO<A> render(Picture<Bitmap, A> picture) {
        CompletableFuture<A> f = this.window.render(picture);
        return IO$.MODULE$.fromCompletableFuture(IO$.MODULE$.apply(() -> Canvas.render$$anonfun$1(f)));
    }

    public IO<Object> close() {
        return IO$.MODULE$.apply(this::close$$anonfun$1).$greater$greater(this::close$$anonfun$2);
    }

    private final CompletableFuture $init$$$anonfun$1$$anonfun$1() {
        return this.window.closed();
    }

    private static final IO $anonfun$1(Topic redrawTopic$1, Topic mouseClickTopic$1, Topic mouseMoveTopic$1) {
        return ((IO)package.all$.MODULE$.catsSyntaxTuple3Parallel(Tuple3$.MODULE$.apply(redrawTopic$1.close(), mouseClickTopic$1.close(), mouseMoveTopic$1.close())).parTupled((NonEmptyParallel)IO$.MODULE$.parallelForIO())).void();
    }

    private static final Object pump$$anonfun$1(BlockingCircularQueue queue$1) {
        return queue$1.take();
    }

    private static final CompletableFuture render$$anonfun$1(CompletableFuture f$1) {
        return f$1;
    }

    private final CompletableFuture close$$anonfun$1() {
        return this.window.close();
    }

    private final IO close$$anonfun$2() {
        return this.windowClosed;
    }
}

