/*
 * Decompiled with CFR 0.152.
 */
package doodle.java2d.algebra;

import doodle.algebra.generic.DrawingContext;
import doodle.algebra.generic.Fill;
import doodle.algebra.generic.Stroke;
import doodle.core.BoundingBox;
import doodle.core.BoundingBox$;
import doodle.core.Cap;
import doodle.core.Color;
import doodle.core.Gradient;
import doodle.core.Join;
import doodle.core.Normalized$;
import doodle.core.PathElement;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.core.UnsignedByte$;
import doodle.core.font.FontFamily;
import doodle.core.font.FontSize;
import doodle.core.font.FontStyle;
import doodle.core.font.FontWeight;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Java2D$
implements Serializable {
    public static final Java2D$ MODULE$ = new Java2D$();

    private Java2D$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Java2D$.class);
    }

    public FontMetrics fontMetrics(Graphics2D gc, doodle.core.font.Font font) {
        return gc.getFontMetrics(this.toAwtFont(font));
    }

    public BoundingBox textBoundingBox(Graphics2D gc, String text, doodle.core.font.Font font) {
        Rectangle2D bounds = this.textBounds(gc, text, font);
        return BoundingBox$.MODULE$.centered(bounds.getWidth(), bounds.getHeight());
    }

    public Rectangle2D textBounds(Graphics2D gc, String text, doodle.core.font.Font font) {
        FontMetrics metrics = this.fontMetrics(gc, font);
        return metrics.getStringBounds(text, gc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Font toAwtFont(doodle.core.font.Font font) {
        int n;
        int n2;
        String string;
        FontFamily fontFamily = font.family();
        if (FontFamily.Serif$.MODULE$.equals(fontFamily)) {
            string = "Serif";
        } else if (FontFamily.SansSerif$.MODULE$.equals(fontFamily)) {
            string = "SansSerif";
        } else if (FontFamily.Monospaced$.MODULE$.equals(fontFamily)) {
            string = "Monospaced";
        } else {
            String string2;
            String name;
            if (!(fontFamily instanceof FontFamily.Named)) throw new MatchError((Object)fontFamily);
            FontFamily.Named named = FontFamily.Named$.MODULE$.unapply((FontFamily.Named)fontFamily);
            string = name = (string2 = named._1());
        }
        String awtFamily = string;
        FontWeight fontWeight = font.weight();
        if (FontWeight.Normal$.MODULE$.equals(fontWeight)) {
            FontStyle fontStyle = font.style();
            if (FontStyle.Italic$.MODULE$.equals(fontStyle)) {
                n2 = 2;
            } else {
                if (!FontStyle.Normal$.MODULE$.equals(fontStyle)) throw new MatchError((Object)fontStyle);
                n2 = 0;
            }
        } else {
            if (!FontWeight.Bold$.MODULE$.equals(fontWeight)) throw new MatchError((Object)fontWeight);
            FontStyle fontStyle = font.style();
            if (FontStyle.Italic$.MODULE$.equals(fontStyle)) {
                n2 = 3;
            } else {
                if (!FontStyle.Normal$.MODULE$.equals(fontStyle)) throw new MatchError((Object)fontStyle);
                n2 = 1;
            }
        }
        int awtStyle = n2;
        FontSize fontSize = font.size();
        if (!(fontSize instanceof FontSize.Points)) {
            throw new MatchError((Object)fontSize);
        }
        FontSize.Points points = FontSize.Points$.MODULE$.unapply((FontSize.Points)fontSize);
        int pts = n = points._1();
        int awtSize = pts;
        return new Font(awtFamily, awtStyle, awtSize);
    }

    public Point2D toPoint2D(Point point) {
        return new Point2D.Double(point.x(), point.y());
    }

    public Color toAwtColor(doodle.core.Color color) {
        Color.Rgb rgba = color.toRgb();
        return new Color(UnsignedByte$.MODULE$.get$extension(rgba.r()), UnsignedByte$.MODULE$.get$extension(rgba.g()), UnsignedByte$.MODULE$.get$extension(rgba.b()), UnsignedByte$.MODULE$.get$extension(Normalized$.MODULE$.toUnsignedByte$extension(rgba.a())));
    }

    public void setStroke(Graphics2D graphics, Stroke stroke) {
        BasicStroke basicStroke;
        int n;
        int n2;
        float width = (float)stroke.width();
        Cap cap = stroke.cap();
        if (Cap.Butt$.MODULE$.equals(cap)) {
            n2 = 0;
        } else if (Cap.Round$.MODULE$.equals(cap)) {
            n2 = 1;
        } else if (Cap.Square$.MODULE$.equals(cap)) {
            n2 = 2;
        } else {
            throw new MatchError((Object)cap);
        }
        int cap2 = n2;
        Join join = stroke.join();
        if (Join.Bevel$.MODULE$.equals(join)) {
            n = 2;
        } else if (Join.Miter$.MODULE$.equals(join)) {
            n = 0;
        } else if (Join.Round$.MODULE$.equals(join)) {
            n = 1;
        } else {
            throw new MatchError((Object)join);
        }
        int join2 = n;
        Option option = stroke.dash();
        if (None$.MODULE$.equals(option)) {
            basicStroke = new BasicStroke(width, cap2, join2);
        } else if (option instanceof Some) {
            float[] dash = (float[])((Some)option).value();
            basicStroke = new BasicStroke(width, cap2, join2, 1.0f, dash, 0.0f);
        } else {
            throw new MatchError((Object)option);
        }
        BasicStroke jStroke = basicStroke;
        Color jColor = this.toAwtColor(stroke.color());
        graphics.setStroke(jStroke);
        graphics.setColor(jColor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFill(Graphics2D graphics, Fill fill) {
        Paint paint;
        Fill fill2 = fill;
        if (fill2 instanceof Fill.ColorFill) {
            doodle.core.Color color;
            Fill.ColorFill colorFill = Fill.ColorFill$.MODULE$.unapply((Fill.ColorFill)fill2);
            doodle.core.Color c = color = colorFill._1();
            paint = this.toAwtColor(c);
        } else {
            if (!(fill2 instanceof Fill.GradientFill)) throw new MatchError((Object)fill2);
            Fill.GradientFill gradientFill = Fill.GradientFill$.MODULE$.unapply((Fill.GradientFill)fill2);
            Gradient gradient = gradientFill._1();
            Gradient g = gradient;
            Gradient gradient2 = g;
            if (gradient2 instanceof Gradient.Linear) {
                Gradient.Linear l = (Gradient.Linear)gradient2;
                paint = this.toLinearGradientPaint(l);
            } else {
                if (!(gradient2 instanceof Gradient.Radial)) throw new MatchError((Object)gradient2);
                Gradient.Radial r = (Gradient.Radial)gradient2;
                paint = this.toRadialGradientPaint(r);
            }
        }
        Color paint2 = paint;
        graphics.setPaint(paint2);
    }

    public MultipleGradientPaint.CycleMethod toCycleMethod(Gradient.CycleMethod cycleMethod) {
        Gradient.CycleMethod cycleMethod2 = cycleMethod;
        if (Gradient.CycleMethod$.NoCycle$.MODULE$.equals(cycleMethod2)) {
            return MultipleGradientPaint.CycleMethod.NO_CYCLE;
        }
        if (Gradient.CycleMethod$.Reflect$.MODULE$.equals(cycleMethod2)) {
            return MultipleGradientPaint.CycleMethod.REFLECT;
        }
        if (Gradient.CycleMethod$.Repeat$.MODULE$.equals(cycleMethod2)) {
            return MultipleGradientPaint.CycleMethod.REPEAT;
        }
        throw new MatchError((Object)cycleMethod2);
    }

    public LinearGradientPaint toLinearGradientPaint(Gradient.Linear gradient) {
        Point2D start = this.toPoint2D(gradient.start());
        Point2D end = this.toPoint2D(gradient.end());
        float[] fractions = (float[])((IterableOnceOps)((IterableOps)gradient.stops().map((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToDouble((Object)_$1._2()))).map((Function1)(JFunction1.mcFD.sp & Serializable)_$2 -> (float)_$2)).toArray(ClassTag$.MODULE$.apply(Float.TYPE));
        Color[] colors = (Color[])((IterableOnceOps)((IterableOps)gradient.stops().map((Function1 & Serializable)_$3 -> (doodle.core.Color)_$3._1())).map((Function1 & Serializable)_$4 -> this.toAwtColor((doodle.core.Color)_$4))).toArray(ClassTag$.MODULE$.apply(Color.class));
        MultipleGradientPaint.CycleMethod cycleMethod = this.toCycleMethod(gradient.cycleMethod());
        return new LinearGradientPaint(start, end, fractions, colors, cycleMethod);
    }

    public RadialGradientPaint toRadialGradientPaint(Gradient.Radial gradient) {
        Point2D center = this.toPoint2D(gradient.outer());
        Point2D focus = this.toPoint2D(gradient.inner());
        float radius = (float)gradient.radius();
        float[] fractions = (float[])((IterableOnceOps)((IterableOps)gradient.stops().map((Function1 & Serializable)_$5 -> BoxesRunTime.unboxToDouble((Object)_$5._2()))).map((Function1)(JFunction1.mcFD.sp & Serializable)_$6 -> (float)_$6)).toArray(ClassTag$.MODULE$.apply(Float.TYPE));
        Color[] colors = (Color[])((IterableOnceOps)((IterableOps)gradient.stops().map((Function1 & Serializable)_$7 -> (doodle.core.Color)_$7._1())).map((Function1 & Serializable)_$8 -> this.toAwtColor((doodle.core.Color)_$8))).toArray(ClassTag$.MODULE$.apply(Color.class));
        MultipleGradientPaint.CycleMethod cycleMethod = this.toCycleMethod(gradient.cycleMethod());
        return new RadialGradientPaint(center, radius, focus, fractions, colors, cycleMethod);
    }

    public Path2D toPath2D(List<PathElement> elements) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(0.0, 0.0);
        elements.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Some some;
            PathElement.LineTo lineTo;
            Point point;
            Some some2;
            PathElement.MoveTo moveTo;
            Point point2;
            PathElement pathElement = x$1;
            if (pathElement instanceof PathElement.MoveTo && (point2 = (moveTo = PathElement.MoveTo$.MODULE$.unapply((PathElement.MoveTo)pathElement))._1()) != null && !(some2 = Point.extractors$.Cartesian$.MODULE$.unapply(point2)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)some2.get();
                double x = tuple2._1$mcD$sp();
                double y = tuple2._2$mcD$sp();
                path.moveTo(x, y);
                return;
            }
            if (pathElement instanceof PathElement.LineTo && (point = (lineTo = PathElement.LineTo$.MODULE$.unapply((PathElement.LineTo)pathElement))._1()) != null && !(some = Point.extractors$.Cartesian$.MODULE$.unapply(point)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)some.get();
                double x = tuple2._1$mcD$sp();
                double y = tuple2._2$mcD$sp();
                path.lineTo(x, y);
                return;
            }
            if (pathElement instanceof PathElement.BezierCurveTo) {
                Some some3;
                PathElement.BezierCurveTo bezierCurveTo = PathElement.BezierCurveTo$.MODULE$.unapply((PathElement.BezierCurveTo)pathElement);
                Point point3 = bezierCurveTo._1();
                Point point4 = bezierCurveTo._2();
                Point point5 = bezierCurveTo._3();
                if (point3 != null && !(some3 = Point.extractors$.Cartesian$.MODULE$.unapply(point3)).isEmpty()) {
                    Some some4;
                    Tuple2 tuple2 = (Tuple2)some3.get();
                    double cp1x = tuple2._1$mcD$sp();
                    double cp1y = tuple2._2$mcD$sp();
                    if (point4 != null && !(some4 = Point.extractors$.Cartesian$.MODULE$.unapply(point4)).isEmpty()) {
                        Some some5;
                        Tuple2 tuple22 = (Tuple2)some4.get();
                        double cp2x = tuple22._1$mcD$sp();
                        double cp2y = tuple22._2$mcD$sp();
                        if (point5 != null && !(some5 = Point.extractors$.Cartesian$.MODULE$.unapply(point5)).isEmpty()) {
                            Tuple2 tuple23 = (Tuple2)some5.get();
                            double endX = tuple23._1$mcD$sp();
                            double endY = tuple23._2$mcD$sp();
                            path.curveTo(cp1x, cp1y, cp2x, cp2y, endX, endY);
                            return;
                        }
                    }
                }
            }
            throw new MatchError((Object)pathElement);
        });
        return path;
    }

    public AffineTransform toAffineTransform(Transform transform) {
        double[] elts = transform.elements();
        return new AffineTransform(elts[0], elts[3], elts[1], elts[4], elts[2], elts[5]);
    }

    public void withTransform(Graphics2D graphics, Transform transform, Function0<BoxedUnit> f) {
        AffineTransform original = graphics.getTransform();
        graphics.transform(this.toAffineTransform(transform));
        f.apply$mcV$sp();
        graphics.setTransform(original);
    }

    public void strokeAndFill(Graphics2D graphics, Path2D path, DrawingContext current) {
        current.stroke().foreach((Function1)(JProcedure1 & Serializable)s -> {
            MODULE$.setStroke(graphics, (Stroke)s);
            graphics.draw(path);
        });
        current.fill().foreach((Function1)(JProcedure1 & Serializable)f -> {
            MODULE$.setFill(graphics, (Fill)f);
            graphics.fill(path);
        });
    }
}

