/*
 * Decompiled with CFR 0.152.
 */
package doodle.java2d.effect;

import doodle.algebra.Bitmap;
import doodle.algebra.Picture;
import doodle.core.BoundingBox;
import doodle.core.BoundingBox$;
import doodle.core.Color;
import doodle.core.Normalized$;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Transform;
import doodle.core.Transform$;
import doodle.java2d.algebra.Algebra;
import doodle.java2d.algebra.Algebra$;
import doodle.java2d.algebra.Java2D$;
import doodle.java2d.algebra.reified.Reified;
import doodle.java2d.effect.BlockingCircularQueue;
import doodle.java2d.effect.Frame;
import doodle.java2d.effect.Java2d$;
import doodle.java2d.effect.Redraw;
import doodle.java2d.effect.Redraw$ClearToBackground$;
import doodle.java2d.effect.Redraw$ClearToColor$;
import doodle.java2d.effect.RenderRequest;
import doodle.java2d.effect.RenderRequest$;
import doodle.java2d.effect.RenderResult;
import doodle.java2d.effect.Size;
import doodle.java2d.effect.Size$FitToImage$;
import doodle.java2d.effect.Size$FixedSize$;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Java2DPanel
extends JPanel {
    private final Frame frame;
    public final BlockingCircularQueue<Point> doodle$java2d$effect$Java2DPanel$$mouseClickQueue;
    public final BlockingCircularQueue<Point> doodle$java2d$effect$Java2DPanel$$mouseMoveQueue;
    private final Queue<RenderRequest<?>> requests;
    private final ArrayBuffer<Tuple2<BoundingBox, List<Reified>>> pictures;
    public Transform doodle$java2d$effect$Java2DPanel$$inverseTx;
    private final boolean opaqueRedraw;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Java2DPanel(Frame frame, BlockingCircularQueue<Point> mouseClickQueue, BlockingCircularQueue<Point> mouseMoveQueue) {
        boolean bl;
        this.frame = frame;
        this.doodle$java2d$effect$Java2DPanel$$mouseClickQueue = mouseClickQueue;
        this.doodle$java2d$effect$Java2DPanel$$mouseMoveQueue = mouseMoveQueue;
        this.requests = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RenderRequest[0]));
        this.pictures = new ArrayBuffer(1);
        this.doodle$java2d$effect$Java2DPanel$$inverseTx = Transform$.MODULE$.identity();
        Redraw redraw = frame.redraw();
        if (Redraw$ClearToBackground$.MODULE$.equals(redraw)) {
            Option<Color> option = frame.background();
            if (None$.MODULE$.equals(option)) {
                bl = true;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                Color c = (Color)((Some)option).value();
                bl = c.alpha() == Normalized$.MODULE$.MaxValue();
            }
        } else {
            if (!(redraw instanceof Redraw.ClearToColor)) throw new MatchError((Object)redraw);
            Redraw.ClearToColor clearToColor = Redraw$ClearToColor$.MODULE$.unapply((Redraw.ClearToColor)redraw);
            Color color = clearToColor._1();
            Color c = color;
            bl = c.alpha() == Normalized$.MODULE$.MaxValue();
        }
        this.opaqueRedraw = bl;
        this.addMouseListener(new MouseListener(this){
            private final /* synthetic */ Java2DPanel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                java.awt.Point pt = e.getPoint();
                this.$outer.doodle$java2d$effect$Java2DPanel$$mouseClickQueue.add(this.$outer.doodle$java2d$effect$Java2DPanel$$inverseTx.apply(Point$.MODULE$.apply(pt.getX(), pt.getY())));
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(this){
            private final /* synthetic */ Java2DPanel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                java.awt.Point pt = e.getPoint();
                this.$outer.doodle$java2d$effect$Java2DPanel$$mouseMoveQueue.add(this.$outer.doodle$java2d$effect$Java2DPanel$$inverseTx.apply(Point$.MODULE$.apply(pt.getX(), pt.getY())));
            }
        });
        Size size = frame.size();
        if (size instanceof Size.FitToImage) {
            int n;
            Size.FitToImage fitToImage = Size$FitToImage$.MODULE$.unapply((Size.FitToImage)size);
            int border = n = fitToImage._1();
            return;
        } else {
            if (!(size instanceof Size.FixedSize)) throw new MatchError((Object)size);
            Size.FixedSize fixedSize = Size$FixedSize$.MODULE$.unapply((Size.FixedSize)size);
            double d = fixedSize._1();
            double d2 = fixedSize._2();
            double width = d;
            double height = d2;
            this.setSize((int)width, (int)height);
            this.doodle$java2d$effect$Java2DPanel$$inverseTx = Java2d$.MODULE$.inverseTransform(BoundingBox$.MODULE$.centered(width, height), width, height, frame.center());
        }
    }

    public void resize(double width, double height) {
        this.setPreferredSize(new Dimension((int)width, (int)height));
        SwingUtilities.windowForComponent(this).pack();
    }

    public <A> CompletableFuture<A> render(Picture<Bitmap, A> picture) {
        CompletableFuture f = new CompletableFuture();
        SwingUtilities.invokeLater(() -> {
            RenderRequest request = RenderRequest$.MODULE$.apply(picture, f);
            this.requests.enqueue(request);
            this.repaint();
        });
        return f;
    }

    public void draw(Graphics2D gc) {
        this.frame.background().foreach((Function1)(JProcedure1 & Serializable)c -> {
            gc.setColor(Java2D$.MODULE$.toAwtColor((Color)c));
            gc.fillRect(0, 0, this.getWidth(), this.getHeight());
        });
        int n = this.pictures.size();
        if (0 == n) {
            return;
        }
        if (1 == n) {
            Tuple2 tuple2 = (Tuple2)this.pictures.apply(0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BoundingBox bb = (BoundingBox)tuple2._1();
            List reified = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)bb, (Object)reified);
            BoundingBox bb2 = (BoundingBox)tuple22._1();
            List reified2 = (List)tuple22._2();
            Transform tx = Java2d$.MODULE$.transform(bb2, this.getWidth(), this.getHeight(), this.frame.center());
            Java2d$.MODULE$.render(gc, (List<Reified>)reified2, tx);
            return;
        }
        Tuple2 tuple2 = (Tuple2)this.pictures.apply(0);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BoundingBox bb = (BoundingBox)tuple2._1();
        List reified = (List)tuple2._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)bb, (Object)reified);
        BoundingBox bb3 = (BoundingBox)tuple23._1();
        List reified3 = (List)tuple23._2();
        Transform tx = Java2d$.MODULE$.transform(bb3, this.getWidth(), this.getHeight(), this.frame.center());
        Java2d$.MODULE$.render(gc, (List<Reified>)reified3, tx);
        this.pictures.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BoundingBox bb = (BoundingBox)tuple2._1();
                List reified = (List)tuple2._2();
                Redraw redraw = this.frame.redraw();
                if (Redraw$ClearToBackground$.MODULE$.equals(redraw)) {
                    this.frame.background().foreach((Function1)(JProcedure1 & Serializable)c -> {
                        gc.setColor(Java2D$.MODULE$.toAwtColor((Color)c));
                        gc.fillRect(0, 0, this.getWidth(), this.getHeight());
                    });
                } else if (redraw instanceof Redraw.ClearToColor) {
                    Color color;
                    Redraw.ClearToColor clearToColor = Redraw$ClearToColor$.MODULE$.unapply((Redraw.ClearToColor)redraw);
                    Color c2 = color = clearToColor._1();
                    gc.setColor(Java2D$.MODULE$.toAwtColor(c2));
                    gc.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    throw new MatchError((Object)redraw);
                }
                Transform tx = Java2d$.MODULE$.transform(bb, this.getWidth(), this.getHeight(), this.frame.center());
                Java2d$.MODULE$.render(gc, (List<Reified>)reified, tx);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public void paintComponent(Graphics context) {
        super.paintComponents(context);
        Graphics2D gc = (Graphics2D)context;
        Java2d$.MODULE$.setup(gc);
        Algebra algebra = Algebra$.MODULE$.apply(gc, Algebra$.MODULE$.$lessinit$greater$default$2(), Algebra$.MODULE$.$lessinit$greater$default$3());
        while (this.requests.size() > 0) {
            Growable growable;
            RenderRequest r = (RenderRequest)this.requests.dequeue();
            RenderResult result = r.render(this.frame, algebra);
            BoundingBox bb = result.boundingBox();
            List<Reified> reified = result.reified();
            this.resize(result.width(), result.height());
            if (this.opaqueRedraw && this.pictures.size() > 0) {
                this.pictures.update(0, (Object)Tuple2$.MODULE$.apply((Object)bb, reified));
                growable = BoxedUnit.UNIT;
            } else {
                growable = this.pictures.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)bb, reified));
            }
            this.doodle$java2d$effect$Java2DPanel$$inverseTx = Java2d$.MODULE$.inverseTransform(result.boundingBox(), result.width(), result.height(), this.frame.center());
        }
        this.draw(gc);
    }
}

