/*
 * Decompiled with CFR 0.152.
 */
package doodle.java2d.effect;

import cats.Eval;
import cats.data.IndexedStateT;
import cats.data.WriterT;
import cats.effect.IO;
import cats.effect.IO$;
import doodle.algebra.Bitmap;
import doodle.algebra.Picture;
import doodle.algebra.generic.DrawingContext;
import doodle.core.BoundingBox;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Transform;
import doodle.core.Transform$;
import doodle.java2d.algebra.reified.Reified;
import doodle.java2d.effect.Frame;
import doodle.java2d.effect.Java2DPanel;
import doodle.java2d.effect.Java2DPanel$RenderRequest$;
import doodle.java2d.effect.Java2d$;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.Timer;
import monix.reactive.subjects.PublishSubject;
import monix.reactive.subjects.PublishSubject$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.function.JProcedure1;

public final class Canvas
extends JFrame {
    private final Frame frame;
    private final Java2DPanel panel;
    public final AtomicReference<Transform> doodle$java2d$effect$Canvas$$currentInverseTx;
    private final PublishSubject redraw;
    private final int frameRateMs;
    private final ActionListener frameEvent;
    private final Timer timer;
    private final PublishSubject mouseClick;
    private final PublishSubject mouseMove;

    public Canvas(Frame frame) {
        this.frame = frame;
        super(frame.title());
        this.panel = new Java2DPanel(frame);
        this.doodle$java2d$effect$Canvas$$currentInverseTx = new AtomicReference<Transform>(Transform$.MODULE$.identity());
        this.redraw = PublishSubject$.MODULE$.apply();
        this.frameRateMs = (int)16.666666666666668;
        BooleanRef firstFrame = BooleanRef.create((boolean)true);
        LongRef lastFrameTime = LongRef.create((long)0L);
        this.frameEvent = new ActionListener(firstFrame, lastFrameTime, this){
            private final BooleanRef firstFrame$1;
            private final LongRef lastFrameTime$1;
            private final Canvas $outer;
            {
                this.firstFrame$1 = firstFrame$2;
                this.lastFrameTime$1 = lastFrameTime$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                long now = e.getWhen();
                if (this.firstFrame$1.elem) {
                    long l;
                    boolean bl;
                    this.firstFrame$1.elem = bl = false;
                    this.lastFrameTime$1.elem = l = now;
                    this.$outer.redraw().onNext((Object)BoxesRunTime.boxToInteger((int)0));
                } else {
                    long l;
                    this.$outer.redraw().onNext((Object)BoxesRunTime.boxToInteger((int)((int)(now - this.lastFrameTime$1.elem))));
                    this.lastFrameTime$1.elem = l = now;
                }
            }
        };
        this.timer = new Timer(this.frameRateMs(), this.frameEvent());
        this.mouseClick = PublishSubject$.MODULE$.apply();
        this.addMouseListener(new MouseListener(this){
            private final Canvas $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                java.awt.Point pt = e.getPoint();
                Transform inverseTx = this.$outer.doodle$java2d$effect$Canvas$$currentInverseTx.get();
                Future ack = this.$outer.mouseClick().onNext((Object)inverseTx.apply(Point$.MODULE$.apply(pt.getX(), pt.getY())));
                Await$.MODULE$.ready((Awaitable)ack, (Duration)Duration$.MODULE$.Inf());
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.mouseMove = PublishSubject$.MODULE$.apply();
        this.addMouseMotionListener(new MouseMotionListener(this){
            private final Canvas $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                java.awt.Point pt = e.getPoint();
                Transform inverseTx = this.$outer.doodle$java2d$effect$Canvas$$currentInverseTx.get();
                Future ack = this.$outer.mouseMove().onNext((Object)inverseTx.apply(Point$.MODULE$.apply(pt.getX(), pt.getY())));
                Await$.MODULE$.ready((Awaitable)ack, (Duration)Duration$.MODULE$.Inf());
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            private final Canvas $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void windowClosed(WindowEvent evt) {
                this.$outer.timer().stop();
            }
        });
        this.getContentPane().add(this.panel());
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.repaint();
        this.timer().start();
    }

    public Java2DPanel panel() {
        return this.panel;
    }

    public <A> IO<A> render(Picture<Bitmap<Object>, IndexedStateT<Eval, List<Function1<DrawingContext, DrawingContext>>, List<Function1<DrawingContext, DrawingContext>>, Tuple2<BoundingBox, IndexedStateT<Eval, Transform, Transform, WriterT<Eval, List<Reified>, Object>>>>, A> picture) {
        return IO$.MODULE$.async((Function1)(JProcedure1 & Serializable)cb -> this.register$1(picture, (Function1)cb)).map((Function1 & Serializable)result -> {
            Transform inverseTx = Java2d$.MODULE$.inverseTransform(result.boundingBox(), result.width(), result.height(), this.frame.center());
            this.doodle$java2d$effect$Canvas$$currentInverseTx.set(inverseTx);
            return result.value();
        });
    }

    public PublishSubject<Object> redraw() {
        return this.redraw;
    }

    public int frameRateMs() {
        return this.frameRateMs;
    }

    public ActionListener frameEvent() {
        return this.frameEvent;
    }

    public Timer timer() {
        return this.timer;
    }

    public PublishSubject<Point> mouseClick() {
        return this.mouseClick;
    }

    public PublishSubject<Point> mouseMove() {
        return this.mouseMove;
    }

    private final void register$1(Picture picture$1, Function1 cb) {
        this.panel().render(Java2DPanel$RenderRequest$.MODULE$.apply(picture$1, this.frame, cb));
    }
}

