/*
 * Copyright 2015-2020 Noel Welsh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package doodle
package plot

import cats.implicits._
import doodle.algebra._
import doodle.syntax._
import doodle.plot.geometry.Geometry

final case class Plot[Alg[x[_]] <: Text[x] with Layout[x], F[_], A](
  geometry: Geometry[Alg, F, A],
  scale: Scale[A],
  title: String,
) {
  def render: Picture[Alg, F, Unit] =
    text[Alg, F](title).above(geometry.render(scale))
}
