/*
 * Copyright 2015-2020 Noel Welsh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package doodle
package plot
package geometry

import cats.Traverse
import cats.syntax.all._
import doodle.algebra.{Layout, Picture, Shape}
import doodle.syntax._

/**
  * Represents a scatterplot of the given data.
  */
final case class Scatter[Alg[x[_]] <: Layout[x] with Shape[x], F[_], G[_]: Traverse, A: AsPoint](
    data: G[A]
)(f: A => Picture[Alg, F, Unit])
    extends Geometry[Alg, F, A] {

  /**
    * Render this scatterplot to a picture using the given scale to determine
    * layout.
    */
  def render(scale: Scale[A]): Picture[Alg, F, Unit] =
    data.map { a =>
      f(a).at(scale(a))
    }.allOn
}
