/*
 * Copyright 2015-2020 Noel Welsh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package doodle
package plot

import doodle.core.Point

/**
 * Type class for data that can be converted to a `Point`.
 */
trait AsPoint[A] {
  def asPoint(value: A): Point
}
object AsPoint {
  implicit class AsPointOps[A](value :A) {
    def asPoint(implicit asPoint: AsPoint[A]): Point =
      asPoint.asPoint(value)
  }

  implicit object pointAsPoint extends AsPoint[Point] {
    def asPoint(value: Point): Point = value
  }

  implicit object tupleAsPoint extends AsPoint[(Double, Double)] {
    def asPoint(value: (Double, Double)): Point = {
      val (x, y) = value
      Point(x, y)
    }
  }
}
