/*
 * Decompiled with CFR 0.152.
 */
package doodle.reactor;

import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.unsafe.IORuntime;
import cats.instances.package;
import cats.kernel.Monoid;
import doodle.core.Point;
import doodle.effect.Renderer;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.image.syntax.package;
import doodle.interact.effect.AnimationRenderer;
import doodle.interact.syntax.package;
import doodle.language.Basic;
import doodle.reactor.BaseReactor$MouseClick$;
import doodle.reactor.BaseReactor$MouseMove$;
import doodle.reactor.BaseReactor$Tick$;
import doodle.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface BaseReactor<A> {
    public A initial();

    public A onTick(A var1);

    public A onMouseMove(Point var1, A var2);

    public A onMouseClick(Point var1, A var2);

    public FiniteDuration tickRate();

    public Image render(A var1);

    public boolean stop(A var1);

    public static Option tick$(BaseReactor $this, Object frame, Renderer e, IORuntime runtime) {
        return $this.tick(frame, e, runtime);
    }

    default public <F, Frame, Canvas> Option<A> tick(Frame frame, Renderer<Basic, F, Frame, Canvas> e, IORuntime runtime) {
        None$ none$;
        if (this.stop(this.initial())) {
            none$ = None$.MODULE$;
        } else {
            package.all$.MODULE$.ImageOps(this.render(this.initial())).draw(frame, e, runtime);
            A next = this.onTick(this.initial());
            none$ = Some$.MODULE$.apply(next);
        }
        return none$;
    }

    public static void run$(BaseReactor $this, Object frame, AnimationRenderer a, Renderer e, doodle.interact.algebra.MouseClick m, IORuntime runtime) {
        $this.run(frame, a, e, m, runtime);
    }

    default public <Alg extends Basic<Object>, F, Frame, Canvas> void run(Frame frame, AnimationRenderer<Canvas> a, Renderer<Alg, F, Frame, Canvas> e, doodle.interact.algebra.MouseClick<Canvas> m, IORuntime runtime) {
        package.renderer$.MODULE$.RendererFrameOps(frame).canvas(e).flatMap((Function1 & Serializable)canvas -> {
            Stream mouseMove = package.all$.MODULE$.MouseMoveOps(canvas).mouseMove((doodle.interact.algebra.MouseMove)m).map((Function1 & Serializable)pt -> BaseReactor$MouseMove$.MODULE$.apply((Point)pt));
            Stream mouseClick = package.all$.MODULE$.MouseClickOps(canvas).mouseClick(m).map((Function1 & Serializable)pt -> BaseReactor$MouseClick$.MODULE$.apply((Point)pt));
            Stream tick = Stream$.MODULE$.fixedDelay(this.tickRate(), (GenTemporal)IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)_$4 -> BaseReactor$Tick$.MODULE$);
            Stream stream = tick.merge(mouseMove, (GenConcurrent)IO$.MODULE$.asyncForIO()).merge(mouseClick, (GenConcurrent)IO$.MODULE$.asyncForIO()).scan(this.initial(), (Function2 & Serializable)(a, cmd) -> {
                Object object;
                Command command = cmd;
                if (BaseReactor$Tick$.MODULE$.equals(command)) {
                    object = this.onTick(a);
                } else if (command instanceof MouseMove) {
                    Point point;
                    MouseMove mouseMove = BaseReactor$MouseMove$.MODULE$.unapply((MouseMove)command);
                    Point pt = point = mouseMove._1();
                    object = this.onMouseMove(pt, a);
                } else if (command instanceof MouseClick) {
                    Point point;
                    MouseClick mouseClick = BaseReactor$MouseClick$.MODULE$.unapply((MouseClick)command);
                    Point pt = point = mouseClick._1();
                    object = this.onMouseClick(pt, a);
                } else {
                    throw new MatchError((Object)command);
                }
                return object;
            });
            Stream frames = stream.takeWhile((Function1 & Serializable)a -> !this.stop(a), stream.takeWhile$default$2()).map((Function1 & Serializable)a -> Image$.MODULE$.compile(this.render(a)));
            return package.all$.MODULE$.AnimateStreamOps(frames).animateWithCanvasToIO(canvas, a, e, (Monoid)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
        }).unsafeRunAsync((Function1)(JProcedure1 & Serializable)_$5 -> {}, runtime);
    }

    public static abstract class Command
    implements Product,
    Serializable {
    }

    public static final class MouseClick
    extends Command {
        private final Point location;

        public static MouseClick apply(Point point) {
            return BaseReactor$MouseClick$.MODULE$.apply(point);
        }

        public static MouseClick fromProduct(Product product) {
            return BaseReactor$MouseClick$.MODULE$.fromProduct(product);
        }

        public static MouseClick unapply(MouseClick mouseClick) {
            return BaseReactor$MouseClick$.MODULE$.unapply(mouseClick);
        }

        public MouseClick(Point location) {
            this.location = location;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MouseClick)) return false;
            MouseClick mouseClick = (MouseClick)object;
            Point point = this.location();
            Point point2 = mouseClick.location();
            if (point != null) {
                if (!point.equals(point2)) return false;
                return true;
            }
            if (point2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MouseClick;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "MouseClick";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "location";
        }

        public Point location() {
            return this.location;
        }

        public MouseClick copy(Point location) {
            return new MouseClick(location);
        }

        public Point copy$default$1() {
            return this.location();
        }

        public Point _1() {
            return this.location();
        }
    }

    public static final class MouseMove
    extends Command {
        private final Point location;

        public static MouseMove apply(Point point) {
            return BaseReactor$MouseMove$.MODULE$.apply(point);
        }

        public static MouseMove fromProduct(Product product) {
            return BaseReactor$MouseMove$.MODULE$.fromProduct(product);
        }

        public static MouseMove unapply(MouseMove mouseMove) {
            return BaseReactor$MouseMove$.MODULE$.unapply(mouseMove);
        }

        public MouseMove(Point location) {
            this.location = location;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MouseMove)) return false;
            MouseMove mouseMove = (MouseMove)object;
            Point point = this.location();
            Point point2 = mouseMove.location();
            if (point != null) {
                if (!point.equals(point2)) return false;
                return true;
            }
            if (point2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MouseMove;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "MouseMove";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "location";
        }

        public Point location() {
            return this.location;
        }

        public MouseMove copy(Point location) {
            return new MouseMove(location);
        }

        public Point copy$default$1() {
            return this.location();
        }

        public Point _1() {
            return this.location();
        }
    }
}

