/*
 * Decompiled with CFR 0.152.
 */
package doodle.reactor;

import cats.NonEmptyParallel;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.effect.unsafe.IORuntime;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.package;
import doodle.core.Point;
import doodle.effect.Renderer;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.image.syntax.package;
import doodle.interact.effect.AnimationRenderer;
import doodle.interact.syntax.package;
import doodle.language.Basic;
import doodle.reactor.BaseReactor$MouseClick$;
import doodle.reactor.BaseReactor$MouseMove$;
import doodle.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure3;

public interface BaseReactor<A> {
    public A initial();

    public A onTick(A var1);

    public A onMouseMove(Point var1, A var2);

    public A onMouseClick(Point var1, A var2);

    public FiniteDuration tickRate();

    public Image render(A var1);

    public boolean stop(A var1);

    public static Option tick$(BaseReactor $this, Object frame, Renderer e, IORuntime runtime) {
        return $this.tick(frame, e, runtime);
    }

    default public <Frame, Canvas> Option<A> tick(Frame frame, Renderer<Basic, Frame, Canvas> e, IORuntime runtime) {
        if (this.stop(this.initial())) {
            return None$.MODULE$;
        }
        package.all$.MODULE$.ImageOps(this.render(this.initial())).drawWithFrame(frame, e, runtime);
        A next = this.onTick(this.initial());
        return Some$.MODULE$.apply(next);
    }

    public static void run$(BaseReactor $this, Object frame, AnimationRenderer a, Renderer e, doodle.interact.algebra.MouseClick m, IORuntime runtime) {
        $this.run(frame, a, e, m, runtime);
    }

    default public <Alg extends Basic, Frame, Canvas> void run(Frame frame, AnimationRenderer<Canvas> a, Renderer<Alg, Frame, Canvas> e, doodle.interact.algebra.MouseClick<Canvas> m, IORuntime runtime) {
        ((IO)package.renderer$.MODULE$.RendererFrameOps(frame).canvas(e).use((Function1 & Serializable)canvas -> ((IO)Queue$.MODULE$.circularBuffer(1, (GenConcurrent)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)tickQueue -> ((IO)Queue$.MODULE$.unbounded((GenConcurrent)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)mouseEventQueue -> ((IO)package.all$.MODULE$.catsSyntaxTuple3Parallel(Tuple3$.MODULE$.apply((Object)BaseReactor.mouseEventProducer$1(m, mouseEventQueue, canvas), (Object)this.tickProducer$1((Queue)tickQueue, (Queue)mouseEventQueue), (Object)this.consumer$1(a, e, (Queue)tickQueue, canvas))).parMapN((Function3)(JProcedure3 & Serializable)(_$3, _$4, _$5) -> {}, (NonEmptyParallel)IO$.MODULE$.parallelForIO())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }))), (MonadCancel)IO$.MODULE$.asyncForIO())).unsafeRunAsync((Function1)(JProcedure1 & Serializable)_$6 -> {}, runtime);
    }

    private static IO mouseEventProducer$1(doodle.interact.algebra.MouseClick m$1, Queue mouseEventQueue, Object canvas) {
        Stream mouseMove = package.all$.MODULE$.MouseMoveOps(canvas).mouseMove((doodle.interact.algebra.MouseMove)m$1).map((Function1 & Serializable)pt -> BaseReactor$MouseMove$.MODULE$.apply((Point)pt));
        Stream mouseClick = package.all$.MODULE$.MouseClickOps(canvas).mouseClick(m$1).map((Function1 & Serializable)pt -> BaseReactor$MouseClick$.MODULE$.apply((Point)pt));
        return (IO)mouseMove.merge(mouseClick, (GenConcurrent)IO$.MODULE$.asyncForIO()).foreach((Function1 & Serializable)a -> (IO)mouseEventQueue.offer(a)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private IO drainMouseQueue$1(Queue mouseEventQueue$3, Object a) {
        return ((IO)mouseEventQueue$3.tryTake()).flatMap((Function1 & Serializable)mouseEvent -> {
            IO iO;
            Option option = mouseEvent;
            if (option instanceof Some) {
                MouseEvent mouseEvent2 = (MouseEvent)((Some)option).value();
                if (mouseEvent2 instanceof MouseMove) {
                    Point point;
                    MouseMove mouseMove = BaseReactor$MouseMove$.MODULE$.unapply((MouseMove)mouseEvent2);
                    Point pt = point = mouseMove._1();
                    iO = this.drainMouseQueue$1(mouseEventQueue$3, this.onMouseMove(pt, a));
                    return iO.map((Function1 & Serializable)state -> state);
                }
                if (mouseEvent2 instanceof MouseClick) {
                    Point point;
                    MouseClick mouseClick = BaseReactor$MouseClick$.MODULE$.unapply((MouseClick)mouseEvent2);
                    Point pt = point = mouseClick._1();
                    iO = this.drainMouseQueue$1(mouseEventQueue$3, this.onMouseClick(pt, a));
                    return iO.map((Function1 & Serializable)state -> state);
                }
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            iO = IO$.MODULE$.pure(a);
            return iO.map((Function1 & Serializable)state -> state);
        });
    }

    private IO tickProducer$1(Queue tickQueue, Queue mouseEventQueue) {
        Stream stream = Stream$.MODULE$.fixedRate(this.tickRate(), (GenTemporal)IO$.MODULE$.asyncForIO()).evalScan(this.initial(), (Function2 & Serializable)(prev, _$1) -> this.drainMouseQueue$1(mouseEventQueue, prev).map((Function1 & Serializable)mouseState -> {
            Object state = this.onTick(mouseState);
            return Tuple2$.MODULE$.apply(mouseState, state);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object mouseState = tuple2._1();
                Object state = tuple2._2();
                return state;
            }
            throw new MatchError((Object)tuple2);
        }));
        return (IO)stream.takeWhile((Function1 & Serializable)a -> !this.stop(a), stream.takeWhile$default$2()).foreach((Function1 & Serializable)a -> (IO)tickQueue.offer(a)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private IO consumer$1(AnimationRenderer a$2, Renderer e$1, Queue tickQueue, Object canvas) {
        Stream stream = Stream$.MODULE$.unit().repeat().evalScan(this.initial(), (Function2 & Serializable)(prev, _$2) -> ((IO)tickQueue.tryTake()).map((Function1 & Serializable)maybeTaken -> {
            Object object;
            Option option = maybeTaken;
            if (option instanceof Some) {
                Object a;
                object = a = ((Some)option).value();
            } else if (None$.MODULE$.equals(option)) {
                object = prev;
            } else {
                throw new MatchError((Object)option);
            }
            Object state = object;
            return Tuple2$.MODULE$.apply(maybeTaken, state);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option maybeTaken = (Option)tuple2._1();
                Object state = tuple2._2();
                return state;
            }
            throw new MatchError((Object)tuple2);
        }));
        return package.all$.MODULE$.AnimateStreamOps(stream.takeWhile((Function1 & Serializable)a -> !this.stop(a), stream.takeWhile$default$2()).map((Function1 & Serializable)a -> Image$.MODULE$.compile(this.render(a)))).animateWithCanvasToIO(canvas, a$2, e$1, (Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit());
    }

    public static final class MouseClick
    extends MouseEvent {
        private final Point location;

        public static MouseClick apply(Point point) {
            return BaseReactor$MouseClick$.MODULE$.apply(point);
        }

        public static MouseClick fromProduct(Product product) {
            return BaseReactor$MouseClick$.MODULE$.fromProduct(product);
        }

        public static MouseClick unapply(MouseClick mouseClick) {
            return BaseReactor$MouseClick$.MODULE$.unapply(mouseClick);
        }

        public MouseClick(Point location) {
            this.location = location;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MouseClick)) return false;
            MouseClick mouseClick = (MouseClick)object;
            Point point = this.location();
            Point point2 = mouseClick.location();
            if (point != null) {
                if (!point.equals(point2)) return false;
                return true;
            }
            if (point2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MouseClick;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "MouseClick";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "location";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Point location() {
            return this.location;
        }

        public MouseClick copy(Point location) {
            return new MouseClick(location);
        }

        public Point copy$default$1() {
            return this.location();
        }

        public Point _1() {
            return this.location();
        }
    }

    public static abstract class MouseEvent
    implements Product,
    Serializable {
    }

    public static final class MouseMove
    extends MouseEvent {
        private final Point location;

        public static MouseMove apply(Point point) {
            return BaseReactor$MouseMove$.MODULE$.apply(point);
        }

        public static MouseMove fromProduct(Product product) {
            return BaseReactor$MouseMove$.MODULE$.fromProduct(product);
        }

        public static MouseMove unapply(MouseMove mouseMove) {
            return BaseReactor$MouseMove$.MODULE$.unapply(mouseMove);
        }

        public MouseMove(Point location) {
            this.location = location;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MouseMove)) return false;
            MouseMove mouseMove = (MouseMove)object;
            Point point = this.location();
            Point point2 = mouseMove.location();
            if (point != null) {
                if (!point.equals(point2)) return false;
                return true;
            }
            if (point2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MouseMove;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "MouseMove";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "location";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Point location() {
            return this.location;
        }

        public MouseMove copy(Point location) {
            return new MouseMove(location);
        }

        public Point copy$default$1() {
            return this.location();
        }

        public Point _1() {
            return this.location();
        }
    }
}

