/*
 * Decompiled with CFR 0.152.
 */
package doodle.reactor;

import doodle.core.Point;
import doodle.effect.DefaultRenderer;
import doodle.effect.Renderer;
import doodle.image.Image;
import doodle.image.syntax.package$;
import doodle.language.Basic;
import doodle.reactor.BaseReactor;
import doodle.reactor.Reactor$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Reactor<A>
implements BaseReactor<A>,
Product,
Serializable {
    private final Object initial;
    private final Function2 onMouseClickHandler;
    private final Function2 onMouseMoveHandler;
    private final Function1 onTickHandler;
    private final FiniteDuration tickRate;
    private final Function1 renderHandler;
    private final Function1 stopHandler;

    public static <A> Reactor<A> apply(A a, Function2<Point, A, A> function2, Function2<Point, A, A> function22, Function1<A, A> function1, FiniteDuration finiteDuration, Function1<A, Image> function12, Function1<A, Object> function13) {
        return Reactor$.MODULE$.apply(a, function2, function22, function1, finiteDuration, function12, function13);
    }

    public static Reactor fromProduct(Product product) {
        return Reactor$.MODULE$.fromProduct(product);
    }

    public static <A> Reactor<A> init(A a) {
        return Reactor$.MODULE$.init(a);
    }

    public static Reactor<Object> linearRamp(double d, double d2, double d3) {
        return Reactor$.MODULE$.linearRamp(d, d2, d3);
    }

    public static <A> Reactor<A> unapply(Reactor<A> reactor) {
        return Reactor$.MODULE$.unapply(reactor);
    }

    public static double linearRamp$default$1() {
        return Reactor$.MODULE$.linearRamp$default$1();
    }

    public static Function2 $lessinit$greater$default$2() {
        return Reactor$.MODULE$.$lessinit$greater$default$2();
    }

    public static double linearRamp$default$2() {
        return Reactor$.MODULE$.linearRamp$default$2();
    }

    public static Function2 $lessinit$greater$default$3() {
        return Reactor$.MODULE$.$lessinit$greater$default$3();
    }

    public static double linearRamp$default$3() {
        return Reactor$.MODULE$.linearRamp$default$3();
    }

    public static Function1 $lessinit$greater$default$4() {
        return Reactor$.MODULE$.$lessinit$greater$default$4();
    }

    public static FiniteDuration $lessinit$greater$default$5() {
        return Reactor$.MODULE$.$lessinit$greater$default$5();
    }

    public static Function1 $lessinit$greater$default$6() {
        return Reactor$.MODULE$.$lessinit$greater$default$6();
    }

    public static Function1 $lessinit$greater$default$7() {
        return Reactor$.MODULE$.$lessinit$greater$default$7();
    }

    public <A> Reactor(A initial, Function2<Point, A, A> onMouseClickHandler, Function2<Point, A, A> onMouseMoveHandler, Function1<A, A> onTickHandler, FiniteDuration tickRate, Function1<A, Image> renderHandler, Function1<A, Object> stopHandler) {
        this.initial = initial;
        this.onMouseClickHandler = onMouseClickHandler;
        this.onMouseMoveHandler = onMouseMoveHandler;
        this.onTickHandler = onTickHandler;
        this.tickRate = tickRate;
        this.renderHandler = renderHandler;
        this.stopHandler = stopHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Reactor)) return false;
        Reactor reactor = (Reactor)object;
        if (!BoxesRunTime.equals(this.initial(), reactor.initial())) return false;
        Function2<Point, A, A> function2 = this.onMouseClickHandler();
        Function2<Point, A, A> function22 = reactor.onMouseClickHandler();
        if (function2 == null) {
            if (function22 != null) {
                return false;
            }
        } else if (!function2.equals(function22)) return false;
        Function2<Point, A, A> function23 = this.onMouseMoveHandler();
        Function2<Point, A, A> function24 = reactor.onMouseMoveHandler();
        if (function23 == null) {
            if (function24 != null) {
                return false;
            }
        } else if (!function23.equals(function24)) return false;
        Function1<A, A> function1 = this.onTickHandler();
        Function1<A, A> function12 = reactor.onTickHandler();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        FiniteDuration finiteDuration = this.tickRate();
        FiniteDuration finiteDuration2 = reactor.tickRate();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        Function1<A, Image> function13 = this.renderHandler();
        Function1<A, Image> function14 = reactor.renderHandler();
        if (function13 == null) {
            if (function14 != null) {
                return false;
            }
        } else if (!function13.equals(function14)) return false;
        Function1<A, Object> function15 = this.stopHandler();
        Function1<A, Object> function16 = reactor.stopHandler();
        if (function15 == null) {
            if (function16 == null) return true;
            return false;
        } else {
            if (!function15.equals(function16)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Reactor;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "Reactor";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = this._6();
                break;
            }
            case 6: {
                object = this._7();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "initial";
                break;
            }
            case 1: {
                string = "onMouseClickHandler";
                break;
            }
            case 2: {
                string = "onMouseMoveHandler";
                break;
            }
            case 3: {
                string = "onTickHandler";
                break;
            }
            case 4: {
                string = "tickRate";
                break;
            }
            case 5: {
                string = "renderHandler";
                break;
            }
            case 6: {
                string = "stopHandler";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    @Override
    public A initial() {
        return (A)this.initial;
    }

    public Function2<Point, A, A> onMouseClickHandler() {
        return this.onMouseClickHandler;
    }

    public Function2<Point, A, A> onMouseMoveHandler() {
        return this.onMouseMoveHandler;
    }

    public Function1<A, A> onTickHandler() {
        return this.onTickHandler;
    }

    @Override
    public FiniteDuration tickRate() {
        return this.tickRate;
    }

    public Function1<A, Image> renderHandler() {
        return this.renderHandler;
    }

    public Function1<A, Object> stopHandler() {
        return this.stopHandler;
    }

    @Override
    public A onMouseClick(Point location, A state) {
        return (A)this.onMouseClickHandler().apply((Object)location, state);
    }

    @Override
    public A onMouseMove(Point location, A state) {
        return (A)this.onMouseMoveHandler().apply((Object)location, state);
    }

    @Override
    public A onTick(A state) {
        return (A)this.onTickHandler().apply(state);
    }

    @Override
    public Image render(A value) {
        return (Image)this.renderHandler().apply(value);
    }

    @Override
    public boolean stop(A value) {
        return BoxesRunTime.unboxToBoolean((Object)this.stopHandler().apply(value));
    }

    public Reactor<A> onMouseClick(Function2<Point, A, A> f) {
        return this.copy(this.copy$default$1(), f, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public Reactor<A> onMouseMove(Function2<Point, A, A> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), f, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public Reactor<A> onTick(Function1<A, A> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), f, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public Reactor<A> tickRate(FiniteDuration duration) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), duration, this.copy$default$6(), this.copy$default$7());
    }

    public Reactor<A> render(Function1<A, Image> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), f, this.copy$default$7());
    }

    public Reactor<A> stop(Function1<A, Object> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), f);
    }

    public Image image() {
        return this.render(this.initial());
    }

    public Reactor<A> step() {
        return this.copy(this.onTick(this.initial()), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public <Alg extends Basic<Object>, F, Frame, Canvas> void draw(Frame frame, Renderer<Alg, F, Frame, Canvas> renderer) {
        package$.MODULE$.ImageOps(this.image()).draw(frame, renderer);
    }

    public <Alg extends Basic<Object>, F, Frame, Canvas> void draw(DefaultRenderer<Alg, F, Frame, Canvas> renderer) {
        package$.MODULE$.ImageOps(this.image()).draw(renderer);
    }

    public <A> Reactor<A> copy(A initial, Function2<Point, A, A> onMouseClickHandler, Function2<Point, A, A> onMouseMoveHandler, Function1<A, A> onTickHandler, FiniteDuration tickRate, Function1<A, Image> renderHandler, Function1<A, Object> stopHandler) {
        return new Reactor<A>(initial, onMouseClickHandler, onMouseMoveHandler, onTickHandler, tickRate, renderHandler, stopHandler);
    }

    public <A> A copy$default$1() {
        return this.initial();
    }

    public <A> Function2<Point, A, A> copy$default$2() {
        return this.onMouseClickHandler();
    }

    public <A> Function2<Point, A, A> copy$default$3() {
        return this.onMouseMoveHandler();
    }

    public <A> Function1<A, A> copy$default$4() {
        return this.onTickHandler();
    }

    public <A> FiniteDuration copy$default$5() {
        return this.tickRate();
    }

    public <A> Function1<A, Image> copy$default$6() {
        return this.renderHandler();
    }

    public <A> Function1<A, Object> copy$default$7() {
        return this.stopHandler();
    }

    public A _1() {
        return this.initial();
    }

    public Function2<Point, A, A> _2() {
        return this.onMouseClickHandler();
    }

    public Function2<Point, A, A> _3() {
        return this.onMouseMoveHandler();
    }

    public Function1<A, A> _4() {
        return this.onTickHandler();
    }

    public FiniteDuration _5() {
        return this.tickRate();
    }

    public Function1<A, Image> _6() {
        return this.renderHandler();
    }

    public Function1<A, Object> _7() {
        return this.stopHandler();
    }
}

