/*
 * Decompiled with CFR 0.152.
 */
package doodle.svg.effect;

import doodle.algebra.generic.Fill;
import doodle.algebra.generic.Stroke;
import doodle.core.Angle;
import doodle.core.Cap;
import doodle.core.Color;
import doodle.core.Join;
import doodle.core.Normalized;
import doodle.core.PathElement;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.core.UnsignedByte;
import doodle.core.UnsignedByte$;
import doodle.svg.effect.Svg;
import doodle.svg.effect.Svg$Closed$;
import doodle.svg.effect.Svg$Open$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BooleanRef;
import scalatags.generic.Bundle;

public final class Svg$
implements scala.Serializable {
    public static Svg$ MODULE$;
    private volatile byte bitmap$init$0;

    static {
        new Svg$();
    }

    public String toStyle(Stroke stroke) {
        String string;
        String string2;
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder(64);
        Cap cap = stroke.cap();
        if (Cap.Butt$.MODULE$.equals(cap)) {
            string2 = "butt";
        } else if (Cap.Round$.MODULE$.equals(cap)) {
            string2 = "round";
        } else if (Cap.Square$.MODULE$.equals(cap)) {
            string2 = "square";
        } else {
            throw new MatchError((Object)cap);
        }
        String linecap = string2;
        Join join = stroke.join();
        if (Join.Bevel$.MODULE$.equals(join)) {
            string = "bevel";
        } else if (Join.Round$.MODULE$.equals(join)) {
            string = "round";
        } else if (Join.Miter$.MODULE$.equals(join)) {
            string = "miter";
        } else {
            throw new MatchError((Object)join);
        }
        String linejoin = string;
        builder.$plus$plus$eq(new StringBuilder(18).append("stroke-width: ").append(stroke.width()).append("px; ").toString());
        builder.$plus$plus$eq(new StringBuilder(9).append("stroke: ").append(this.toHSLA(stroke.color())).append(";").toString());
        builder.$plus$plus$eq(new StringBuilder(18).append("stroke-linecap: ").append(linecap).append("; ").toString());
        builder.$plus$plus$eq(new StringBuilder(19).append("stroke-linejoin: ").append(linejoin).append("; ").toString());
        return builder.toString();
    }

    public String toStyle(Fill fill) {
        return new StringBuilder(7).append("fill: ").append(this.toHSLA(fill.color())).append(";").toString();
    }

    public String toStyle(Option<Stroke> stroke, Option<Fill> fill) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)stroke.fold((Function0 & Serializable & scala.Serializable)() -> "stroke: none;", (Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.toStyle((Stroke)x$6)))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(" ")), Predef$.MODULE$.StringCanBuildFrom()))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString((String)fill.fold((Function0 & Serializable & scala.Serializable)() -> "fill: none;", (Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.toStyle((Fill)x$7)))), Predef$.MODULE$.StringCanBuildFrom());
    }

    public String toSvgTransform(Transform tx) {
        double[] elt = tx.elements();
        double a = elt[0];
        double b = elt[3];
        double c = elt[1];
        double d = elt[4];
        double e = elt[2];
        double f = elt[5];
        return new StringBuilder(13).append("matrix(").append(a).append(",").append(b).append(",").append(c).append(",").append(d).append(",").append(e).append(",").append(f).append(")").toString();
    }

    public String toSvgPath(List<PathElement> elts, Svg.PathType pathType) {
        String string;
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder(64, "M 0,0 ");
        elts.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            scala.collection.mutable.StringBuilder stringBuilder;
            PathElement pathElement = x0$1;
            if (pathElement instanceof PathElement.MoveTo) {
                PathElement.MoveTo moveTo = (PathElement.MoveTo)pathElement;
                Point end = moveTo.to();
                stringBuilder = builder.$plus$plus$eq(new StringBuilder(4).append("M ").append(end.x()).append(",").append(end.y()).append(" ").toString());
            } else if (pathElement instanceof PathElement.LineTo) {
                PathElement.LineTo lineTo = (PathElement.LineTo)pathElement;
                Point end = lineTo.to();
                stringBuilder = builder.$plus$plus$eq(new StringBuilder(4).append("L ").append(end.x()).append(",").append(end.y()).append(" ").toString());
            } else if (pathElement instanceof PathElement.BezierCurveTo) {
                PathElement.BezierCurveTo bezierCurveTo = (PathElement.BezierCurveTo)pathElement;
                Point cp1 = bezierCurveTo.cp1();
                Point cp2 = bezierCurveTo.cp2();
                Point end = bezierCurveTo.to();
                stringBuilder = builder.$plus$plus$eq(new StringBuilder(8).append("C ").append(cp1.x()).append(",").append(cp1.y()).append(" ").append(cp2.x()).append(",").append(cp2.y()).append(" ").append(end.x()).append(",").append(end.y()).append(" ").toString());
            } else {
                throw new MatchError((Object)pathElement);
            }
            return stringBuilder;
        });
        Svg.PathType pathType2 = pathType;
        if (Svg$Open$.MODULE$.equals(pathType2)) {
            string = builder.toString();
        } else if (Svg$Closed$.MODULE$.equals(pathType2)) {
            string = builder.$plus$eq('Z').toString();
        } else {
            throw new MatchError((Object)pathType2);
        }
        return string;
    }

    public String toSvgPath(Point[] points, Svg.PathType pathType) {
        String string;
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])points)).size() * 10);
        BooleanRef first = BooleanRef.create((boolean)true);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])points)).foreach((Function1 & Serializable & scala.Serializable)pt -> {
            scala.collection.mutable.StringBuilder stringBuilder;
            if (first$1.elem) {
                first$1.elem = false;
                stringBuilder = builder.$plus$plus$eq(new StringBuilder(4).append("M ").append(pt.x()).append(",").append(pt.y()).append(" ").toString());
            } else {
                stringBuilder = builder.$plus$plus$eq(new StringBuilder(4).append("L ").append(pt.x()).append(",").append(pt.y()).append(" ").toString());
            }
            return stringBuilder;
        });
        Svg.PathType pathType2 = pathType;
        if (Svg$Open$.MODULE$.equals(pathType2)) {
            string = builder.toString();
        } else if (Svg$Closed$.MODULE$.equals(pathType2)) {
            string = builder.$plus$eq('Z').toString();
        } else {
            throw new MatchError((Object)pathType2);
        }
        return string;
    }

    public String toHSLA(Color color) {
        Tuple4 tuple4 = new Tuple4((Object)color.hue(), (Object)new Normalized(color.saturation()), (Object)new Normalized(color.lightness()), (Object)new Normalized(color.alpha()));
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Angle h = (Angle)tuple4._1();
        double s = ((Normalized)tuple4._2()).get();
        double l = ((Normalized)tuple4._3()).get();
        double a = ((Normalized)tuple4._4()).get();
        Tuple4 tuple42 = new Tuple4((Object)h, (Object)new Normalized(s), (Object)new Normalized(l), (Object)new Normalized(a));
        Tuple4 tuple43 = tuple42;
        Angle h2 = (Angle)tuple43._1();
        double s2 = ((Normalized)tuple43._2()).get();
        double l2 = ((Normalized)tuple43._3()).get();
        double a2 = ((Normalized)tuple43._4()).get();
        return new StringBuilder(14).append("hsla(").append(h2.toDegrees()).append(", ").append(s2 * (double)100).append("%, ").append(l2 * (double)100).append("%, ").append(a2).append(")").toString();
    }

    public String toRGB(Color color) {
        Tuple3 tuple3 = new Tuple3((Object)new UnsignedByte(color.red()), (Object)new UnsignedByte(color.green()), (Object)new UnsignedByte(color.blue()));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        byte r = ((UnsignedByte)tuple3._1()).value();
        byte g = ((UnsignedByte)tuple3._2()).value();
        byte b = ((UnsignedByte)tuple3._3()).value();
        Tuple3 tuple32 = new Tuple3((Object)new UnsignedByte(r), (Object)new UnsignedByte(g), (Object)new UnsignedByte(b));
        Tuple3 tuple33 = tuple32;
        byte r2 = ((UnsignedByte)tuple33._1()).value();
        byte g2 = ((UnsignedByte)tuple33._2()).value();
        byte b2 = ((UnsignedByte)tuple33._3()).value();
        return new StringBuilder(9).append("rgb(").append(UnsignedByte$.MODULE$.get$extension(r2)).append(", ").append(UnsignedByte$.MODULE$.get$extension(g2)).append(", ").append(UnsignedByte$.MODULE$.get$extension(b2)).append(")").toString();
    }

    public <Builder, Output extends FragT, FragT> Svg<Builder, Output, FragT> apply(Bundle<Builder, Output, FragT> bundle) {
        return new Svg<Builder, Output, FragT>(bundle);
    }

    public <Builder, Output extends FragT, FragT> Option<Bundle<Builder, Output, FragT>> unapply(Svg<Builder, Output, FragT> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.bundle());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Svg$() {
        MODULE$ = this;
    }
}

