/*
 * Decompiled with CFR 0.152.
 */
package doodle.svg.effect;

import cats.Apply;
import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.std.Queue;
import cats.effect.unsafe.IORuntime;
import doodle.algebra.Picture;
import doodle.core.BoundingBox;
import doodle.core.BoundingBox$;
import doodle.core.Color;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Transform;
import doodle.core.font.Font;
import doodle.svg.algebra.JsAlgebraModule;
import doodle.svg.effect.Canvas$;
import doodle.svg.effect.Frame;
import doodle.svg.effect.Size;
import doodle.svg.effect.Size$FitToPicture$;
import doodle.svg.effect.Size$FixedSize$;
import doodle.svg.package$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.scalajs.dom.DOMRect;
import org.scalajs.dom.Element;
import org.scalajs.dom.MouseEvent;
import org.scalajs.dom.Node;
import org.scalajs.dom.SVGRect;
import org.scalajs.dom.SVGTextElement;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.util.Either;
import scalatags.JsDom;
import scalatags.generic.Modifier;
import scalatags.generic.TypedTag;

public final class Canvas
implements Product,
Serializable {
    private final Node target;
    private final Frame frame;
    private final Option background;
    private final Queue redrawQueue;
    private final Queue mouseClickQueue;
    private final Queue mouseMoveQueue;
    private final IORuntime runtime;
    private final Function1 nullCallback;
    private final JsAlgebraModule.JsAlgebra algebra;
    private final Stream redraw;
    private final Stream mouseClick;
    private final Stream mouseMove;
    private BoundingBox currentBB;
    private Node svgRoot;
    private Node svgChild;

    public static Canvas apply(Node node, Frame frame, Option<Color> option, Queue<IO, Object> queue, Queue<IO, Point> queue2, Queue<IO, Point> queue3, IORuntime iORuntime) {
        return Canvas$.MODULE$.apply(node, frame, option, queue, queue2, queue3, iORuntime);
    }

    public static IO<Canvas> fromFrame(Frame frame, IORuntime iORuntime) {
        return Canvas$.MODULE$.fromFrame(frame, iORuntime);
    }

    public static Canvas unapply(Canvas canvas) {
        return Canvas$.MODULE$.unapply(canvas);
    }

    public Canvas(Node target, Frame frame, Option<Color> background, Queue<IO, Object> redrawQueue, Queue<IO, Point> mouseClickQueue, Queue<IO, Point> mouseMoveQueue, IORuntime runtime) {
        this.target = target;
        this.frame = frame;
        this.background = background;
        this.redrawQueue = redrawQueue;
        this.mouseClickQueue = mouseClickQueue;
        this.mouseMoveQueue = mouseMoveQueue;
        this.runtime = runtime;
        this.nullCallback = (Function1 & Serializable)_$1 -> {
            Canvas.$init$$$anonfun$1(_$1);
            return BoxedUnit.UNIT;
        };
        this.algebra = new JsAlgebraModule.JsAlgebra(package$.MODULE$.js(), this, (Apply<Tuple3<TypedTag<Element, Element, Node>, Set<TypedTag<Element, Element, Node>>, Object>>)package$.MODULE$.Svg().svgResultApplicative(), (Functor<Tuple3<TypedTag<Element, Element, Node>, Set<TypedTag<Element, Element, Node>>, Object>>)package$.MODULE$.Svg().svgResultApplicative());
        this.redraw = Stream$.MODULE$.fromQueueUnterminated(redrawQueue, Stream$.MODULE$.fromQueueUnterminated$default$2(), (Functor)IO$.MODULE$.asyncForIO());
        BooleanRef started = BooleanRef.create((boolean)false);
        DoubleRef lastTs = DoubleRef.create((double)0.0);
        this.register$1(started, redrawQueue, lastTs, runtime);
        this.mouseClick = Stream$.MODULE$.fromQueueUnterminated(mouseClickQueue, Stream$.MODULE$.fromQueueUnterminated$default$2(), (Functor)IO$.MODULE$.asyncForIO());
        this.mouseMove = Stream$.MODULE$.fromQueueUnterminated(mouseMoveQueue, Stream$.MODULE$.fromQueueUnterminated$default$2(), (Functor)IO$.MODULE$.asyncForIO());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Canvas)) return false;
        Canvas canvas = (Canvas)object;
        Node node = this.target();
        Node node2 = canvas.target();
        if (node == null) {
            if (node2 != null) {
                return false;
            }
        } else if (!node.equals(node2)) return false;
        Frame frame = this.frame();
        Frame frame2 = canvas.frame();
        if (frame == null) {
            if (frame2 != null) {
                return false;
            }
        } else if (!((Object)frame).equals(frame2)) return false;
        Option<Color> option = this.background();
        Option<Color> option2 = canvas.background();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Queue<IO, Object> queue = this.redrawQueue();
        Queue<IO, Object> queue2 = canvas.redrawQueue();
        if (queue == null) {
            if (queue2 != null) {
                return false;
            }
        } else if (!queue.equals(queue2)) return false;
        Queue<IO, Point> queue3 = this.mouseClickQueue();
        Queue<IO, Point> queue4 = canvas.mouseClickQueue();
        if (queue3 == null) {
            if (queue4 != null) {
                return false;
            }
        } else if (!queue3.equals(queue4)) return false;
        Queue<IO, Point> queue5 = this.mouseMoveQueue();
        Queue<IO, Point> queue6 = canvas.mouseMoveQueue();
        if (queue5 == null) {
            if (queue6 == null) return true;
            return false;
        } else {
            if (!queue5.equals(queue6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Canvas;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "Canvas";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "target";
            }
            case 1: {
                return "frame";
            }
            case 2: {
                return "background";
            }
            case 3: {
                return "redrawQueue";
            }
            case 4: {
                return "mouseClickQueue";
            }
            case 5: {
                return "mouseMoveQueue";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Node target() {
        return this.target;
    }

    public Frame frame() {
        return this.frame;
    }

    public Option<Color> background() {
        return this.background;
    }

    public Queue<IO, Object> redrawQueue() {
        return this.redrawQueue;
    }

    public Queue<IO, Point> mouseClickQueue() {
        return this.mouseClickQueue;
    }

    public Queue<IO, Point> mouseMoveQueue() {
        return this.mouseMoveQueue;
    }

    public Function1<Either<Throwable, BoxedUnit>, BoxedUnit> nullCallback() {
        return this.nullCallback;
    }

    public JsAlgebraModule.JsAlgebra algebra() {
        return this.algebra;
    }

    public Stream<IO, Object> redraw() {
        return this.redraw;
    }

    private Function1<MouseEvent, BoxedUnit> mouseClickCallback(Transform tx) {
        return (Function1 & Serializable)evt -> {
            this.mouseClickCallback$$anonfun$1(tx, (MouseEvent)evt);
            return BoxedUnit.UNIT;
        };
    }

    public Stream<IO, Point> mouseClick() {
        return this.mouseClick;
    }

    private Function1<MouseEvent, BoxedUnit> mouseMoveCallback(Transform tx) {
        return (Function1 & Serializable)evt -> {
            this.mouseMoveCallback$$anonfun$1(tx, (MouseEvent)evt);
            return BoxedUnit.UNIT;
        };
    }

    public Stream<IO, Point> mouseMove() {
        return this.mouseMove;
    }

    public Node svgRoot(BoundingBox bb) {
        this.currentBB = bb;
        Transform tx = package$.MODULE$.Svg().inverseClientTransform(this.currentBB, this.frame().size());
        if (this.svgRoot == null) {
            TypedTag newRoot = this.addCallbacks$1(package$.MODULE$.Svg().svgTag(bb, this.frame()), tx);
            this.svgRoot = this.target().appendChild((Node)newRoot.render());
            return this.svgRoot;
        }
        Size size = this.frame().size();
        if (size instanceof Size.FixedSize) {
            Size.FixedSize fixedSize = Size$FixedSize$.MODULE$.unapply((Size.FixedSize)size);
            double d = fixedSize._1();
            double d2 = fixedSize._2();
            return this.svgRoot;
        }
        if (size instanceof Size.FitToPicture) {
            Size.FitToPicture fitToPicture = Size$FitToPicture$.MODULE$.unapply((Size.FitToPicture)size);
            int n = fitToPicture._1();
            Element newRoot = (Element)this.addCallbacks$1(package$.MODULE$.Svg().svgTag(bb, this.frame()), tx).render();
            this.target().replaceChild((Node)newRoot, this.svgRoot);
            this.svgRoot = newRoot;
            return this.svgRoot;
        }
        throw new MatchError((Object)size);
    }

    public void renderChild(Node svgRoot, Node nodes) {
        if (this.svgChild == null || !svgRoot.contains(this.svgChild)) {
            svgRoot.appendChild(nodes);
            this.svgChild = nodes;
            return;
        }
        svgRoot.replaceChild(nodes, this.svgChild);
        this.svgChild = nodes;
    }

    public Tuple2<BoundingBox, SVGRect> textBoundingBox(String text, Font font) {
        Node elt = this.target().appendChild((Node)JsDom.svgTags$.MODULE$.svg().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Modifier[]{JsDom.svgAttrs$.MODULE$.visibility().$colon$eq((Object)"hidden", JsDom.all$.MODULE$.stringAttr())})).render());
        Node txt = elt.appendChild((Node)package$.MODULE$.Svg().textTag(text, font).render());
        SVGRect bb = ((SVGTextElement)txt).getBBox();
        BoundingBox boundingBox = BoundingBox$.MODULE$.centered(bb.width(), bb.height());
        this.target().removeChild(elt);
        return Tuple2$.MODULE$.apply((Object)boundingBox, (Object)bb);
    }

    public <A> IO<A> render(Picture<JsAlgebraModule.JsAlgebra, A> picture) {
        return package$.MODULE$.Svg().renderWithoutRootTag(this.algebra(), picture).map((Function1 & Serializable)result -> {
            Tuple3 tuple3 = result;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            BoundingBox bb = (BoundingBox)tuple3._1();
            TypedTag tags = (TypedTag)tuple3._2();
            Object a = tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)bb, (Object)tags, a);
            BoundingBox bb2 = (BoundingBox)tuple32._1();
            TypedTag tags2 = (TypedTag)tuple32._2();
            Object a2 = tuple32._3();
            Node root = this.svgRoot(bb2);
            this.renderChild(root, (Node)tags2.render());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return a2;
        });
    }

    public Canvas copy(Node target, Frame frame, Option<Color> background, Queue<IO, Object> redrawQueue, Queue<IO, Point> mouseClickQueue, Queue<IO, Point> mouseMoveQueue, IORuntime runtime) {
        return new Canvas(target, frame, background, redrawQueue, mouseClickQueue, mouseMoveQueue, runtime);
    }

    public Node copy$default$1() {
        return this.target();
    }

    public Frame copy$default$2() {
        return this.frame();
    }

    public Option<Color> copy$default$3() {
        return this.background();
    }

    public Queue<IO, Object> copy$default$4() {
        return this.redrawQueue();
    }

    public Queue<IO, Point> copy$default$5() {
        return this.mouseClickQueue();
    }

    public Queue<IO, Point> copy$default$6() {
        return this.mouseMoveQueue();
    }

    public Node _1() {
        return this.target();
    }

    public Frame _2() {
        return this.frame();
    }

    public Option<Color> _3() {
        return this.background();
    }

    public Queue<IO, Object> _4() {
        return this.redrawQueue();
    }

    public Queue<IO, Point> _5() {
        return this.mouseClickQueue();
    }

    public Queue<IO, Point> _6() {
        return this.mouseMoveQueue();
    }

    private static final /* synthetic */ void $init$$$anonfun$1(Either _$1) {
    }

    private final /* synthetic */ void $anonfun$1(BooleanRef started$2, Queue redrawQueue$2, DoubleRef lastTs$2, IORuntime runtime$2, double ts) {
        double d;
        if (started$2.elem) {
            ((IO)redrawQueue$2.offer((Object)BoxesRunTime.boxToInteger((int)((int)(ts - lastTs$2.elem))))).unsafeRunAsync(this.nullCallback(), runtime$2);
        } else {
            boolean bl;
            redrawQueue$2.offer((Object)BoxesRunTime.boxToInteger((int)0));
            started$2.elem = bl = true;
        }
        lastTs$2.elem = d = ts;
        this.register$1(started$2, redrawQueue$2, lastTs$2, runtime$2);
    }

    private final void register$1(BooleanRef started$1, Queue redrawQueue$1, DoubleRef lastTs$1, IORuntime runtime$1) {
        Function1 & Serializable callback = (Function1 & Serializable)v1 -> {
            this.$anonfun$1(started$1, redrawQueue$1, lastTs$1, runtime$1, BoxesRunTime.unboxToDouble((Object)v1));
            return BoxedUnit.UNIT;
        };
        int n = org.scalajs.dom.package$.MODULE$.window().requestAnimationFrame(Any$.MODULE$.fromFunction1((Function1)callback));
    }

    private final /* synthetic */ void mouseClickCallback$$anonfun$1(Transform tx$1, MouseEvent evt) {
        DOMRect rect = ((Element)evt.target()).getBoundingClientRect();
        double x = evt.clientX() - rect.left();
        double y = evt.clientY() - rect.top();
        ((IO)this.mouseClickQueue().offer((Object)tx$1.apply(Point$.MODULE$.apply(x, y)))).unsafeRunAsync(this.nullCallback(), this.runtime);
    }

    private final /* synthetic */ void mouseMoveCallback$$anonfun$1(Transform tx$2, MouseEvent evt) {
        DOMRect rect = ((Element)evt.target()).getBoundingClientRect();
        double x = evt.clientX() - rect.left();
        double y = evt.clientY() - rect.top();
        ((IO)this.mouseMoveQueue().offer((Object)tx$2.apply(Point$.MODULE$.apply(x, y)))).unsafeRunAsync(this.nullCallback(), this.runtime);
    }

    private final TypedTag addCallbacks$1(TypedTag tag, Transform tx) {
        return tag.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Modifier[]{JsDom.all$.MODULE$.onmousemove().$colon$eq(this.mouseMoveCallback(tx), JsDom.all$.MODULE$.bindJsAnyLike((Function1 & Serializable)f -> (Any)Any$.MODULE$.fromFunction1(f))), JsDom.all$.MODULE$.onclick().$colon$eq(this.mouseClickCallback(tx), JsDom.all$.MODULE$.bindJsAnyLike((Function1 & Serializable)f -> (Any)Any$.MODULE$.fromFunction1(f)))}));
    }
}

