/*
 * Decompiled with CFR 0.152.
 */
package doodle.svg.effect;

import cats.Apply;
import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.effect.unsafe.IORuntime;
import doodle.algebra.Picture;
import doodle.core.BoundingBox;
import doodle.core.BoundingBox$;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Transform;
import doodle.core.font.Font;
import doodle.svg.algebra.JsAlgebraModule;
import doodle.svg.effect.Canvas$;
import doodle.svg.effect.Frame;
import doodle.svg.effect.Size;
import doodle.svg.effect.Size$FitToPicture$;
import doodle.svg.effect.Size$FixedSize$;
import doodle.svg.package$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Topic;
import java.io.Serializable;
import org.scalajs.dom.DOMRect;
import org.scalajs.dom.Element;
import org.scalajs.dom.EventListenerOptions;
import org.scalajs.dom.MouseEvent;
import org.scalajs.dom.Node;
import org.scalajs.dom.SVGRect;
import org.scalajs.dom.SVGTextElement;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Object;
import scala.util.Either;
import scalatags.JsDom;
import scalatags.generic.Modifier;
import scalatags.generic.TypedTag;

public final class Canvas
implements Product,
Serializable {
    private final Node target;
    private final Frame frame;
    private final Topic redrawTopic;
    private final Topic mouseClickTopic;
    private final Topic mouseMoveTopic;
    private final Function1 nullCallback;
    private final JsAlgebraModule.JsAlgebra algebra;
    private final EventListenerOptions eventListenerOptions;
    private Stream<IO, Point> mouseMoveStream;
    private Stream<IO, Point> mouseClickStream;
    private BoundingBox currentBB;
    private Node svgRoot;
    private final Stream stream;
    private final Stream redraw;
    private final Stream mouseClick;
    private final Stream mouseMove;
    private Node svgChild;

    public static Canvas apply(Node node, Frame frame, Topic<IO, java.lang.Object> topic, Topic<IO, Point> topic2, Topic<IO, Point> topic3) {
        return Canvas$.MODULE$.apply(node, frame, topic, topic2, topic3);
    }

    public static Resource<IO, Canvas> fromFrame(Frame frame, IORuntime iORuntime) {
        return Canvas$.MODULE$.fromFrame(frame, iORuntime);
    }

    public static Canvas fromProduct(Product product) {
        return Canvas$.MODULE$.fromProduct(product);
    }

    public static Canvas unapply(Canvas canvas) {
        return Canvas$.MODULE$.unapply(canvas);
    }

    public Canvas(Node target, Frame frame, Topic<IO, java.lang.Object> redrawTopic, Topic<IO, Point> mouseClickTopic, Topic<IO, Point> mouseMoveTopic) {
        this.target = target;
        this.frame = frame;
        this.redrawTopic = redrawTopic;
        this.mouseClickTopic = mouseClickTopic;
        this.mouseMoveTopic = mouseMoveTopic;
        this.nullCallback = (Function1 & Serializable)_$1 -> {
            Canvas.$init$$$anonfun$1(_$1);
            return BoxedUnit.UNIT;
        };
        this.algebra = new JsAlgebraModule.JsAlgebra(package$.MODULE$.js(), this, (Apply<Tuple3<TypedTag<Element, Element, Node>, Set<TypedTag<Element, Element, Node>>, java.lang.Object>>)package$.MODULE$.Svg().svgResultApplicative(), (Functor<Tuple3<TypedTag<Element, Element, Node>, Set<TypedTag<Element, Element, Node>>, java.lang.Object>>)package$.MODULE$.Svg().svgResultApplicative());
        this.eventListenerOptions = (EventListenerOptions)scala.scalajs.runtime.package$.MODULE$.withContextualJSClassValue((java.lang.Object)scala.scalajs.runtime.package$.MODULE$.constructorOf(Object.class), (java.lang.Object)new EventListenerOptions(){
            private java.lang.Object capture;
            private java.lang.Object once;
            private java.lang.Object passive;
            private java.lang.Object signal;

            public java.lang.Object capture() {
                return this.capture;
            }

            public java.lang.Object once() {
                return this.once;
            }

            public java.lang.Object passive() {
                return this.passive;
            }

            public java.lang.Object signal() {
                return this.signal;
            }

            public void capture_$eq(java.lang.Object x$1) {
                this.capture = x$1;
            }

            public void once_$eq(java.lang.Object x$1) {
                this.once = x$1;
            }

            public void passive_$eq(java.lang.Object x$1) {
                this.passive = x$1;
            }

            public void signal_$eq(java.lang.Object x$1) {
                this.signal = x$1;
            }
        });
        this.eventListenerOptions.once_$eq((java.lang.Object)BoxesRunTime.boxToBoolean((boolean)true));
        Stream redrawStream = null;
        BooleanRef started = BooleanRef.create((boolean)false);
        DoubleRef lastTs = DoubleRef.create((double)0.0);
        redrawStream = Stream$.MODULE$.repeatEval((java.lang.Object)IO$.MODULE$.async_((Function1 & Serializable)cb -> {
            Canvas.$init$$$anonfun$2(started, lastTs, cb);
            return BoxedUnit.UNIT;
        }));
        this.currentBB = BoundingBox$.MODULE$.empty();
        Transform tx = package$.MODULE$.Svg().inverseClientTransform(this.currentBB, frame.size());
        Element tag = (Element)package$.MODULE$.Svg().svgTag(this.currentBB, frame).render();
        this.addCallbacks(tag, tx);
        this.svgRoot = tag;
        target.appendChild(this.svgRoot);
        Stream redraw = redrawStream.through(redrawTopic.publish()).drain();
        Stream click = this.mouseClickStream.through(mouseClickTopic.publish()).drain();
        Stream move = this.mouseMoveStream.through(mouseMoveTopic.publish()).drain();
        this.stream = redraw.merge(click, (GenConcurrent)IO$.MODULE$.asyncForIO()).merge(move, (GenConcurrent)IO$.MODULE$.asyncForIO());
        this.redraw = redrawTopic.subscribe(4);
        this.mouseClick = mouseClickTopic.subscribe(4);
        this.mouseMove = mouseMoveTopic.subscribe(4);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(java.lang.Object x$0) {
        if (this == x$0) return true;
        java.lang.Object object = x$0;
        if (!(object instanceof Canvas)) return false;
        Canvas canvas = (Canvas)object;
        Node node = this.target();
        Node node2 = canvas.target();
        if (node == null) {
            if (node2 != null) {
                return false;
            }
        } else if (!node.equals(node2)) return false;
        Frame frame = this.frame();
        Frame frame2 = canvas.frame();
        if (frame == null) {
            if (frame2 != null) {
                return false;
            }
        } else if (!((java.lang.Object)frame).equals(frame2)) return false;
        Topic<IO, java.lang.Object> topic = this.redrawTopic();
        Topic<IO, java.lang.Object> topic2 = canvas.redrawTopic();
        if (topic == null) {
            if (topic2 != null) {
                return false;
            }
        } else if (!topic.equals(topic2)) return false;
        Topic<IO, Point> topic3 = this.mouseClickTopic();
        Topic<IO, Point> topic4 = canvas.mouseClickTopic();
        if (topic3 == null) {
            if (topic4 != null) {
                return false;
            }
        } else if (!topic3.equals(topic4)) return false;
        Topic<IO, Point> topic5 = this.mouseMoveTopic();
        Topic<IO, Point> topic6 = canvas.mouseMoveTopic();
        if (topic5 == null) {
            if (topic6 == null) return true;
            return false;
        } else {
            if (!topic5.equals(topic6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(java.lang.Object that) {
        return that instanceof Canvas;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "Canvas";
    }

    public java.lang.Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "target";
            }
            case 1: {
                return "frame";
            }
            case 2: {
                return "redrawTopic";
            }
            case 3: {
                return "mouseClickTopic";
            }
            case 4: {
                return "mouseMoveTopic";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Node target() {
        return this.target;
    }

    public Frame frame() {
        return this.frame;
    }

    public Topic<IO, java.lang.Object> redrawTopic() {
        return this.redrawTopic;
    }

    public Topic<IO, Point> mouseClickTopic() {
        return this.mouseClickTopic;
    }

    public Topic<IO, Point> mouseMoveTopic() {
        return this.mouseMoveTopic;
    }

    public Function1<Either<Throwable, BoxedUnit>, BoxedUnit> nullCallback() {
        return this.nullCallback;
    }

    public JsAlgebraModule.JsAlgebra algebra() {
        return this.algebra;
    }

    private Function1<MouseEvent, Point> mouseClickCallback(Transform tx) {
        return (Function1 & Serializable)evt -> {
            DOMRect rect = ((Element)evt.target()).getBoundingClientRect();
            double x = evt.clientX() - rect.left();
            double y = evt.clientY() - rect.top();
            return tx.apply(Point$.MODULE$.apply(x, y));
        };
    }

    private Function1<MouseEvent, Point> mouseMoveCallback(Transform tx) {
        return (Function1 & Serializable)evt -> {
            DOMRect rect = ((Element)evt.target()).getBoundingClientRect();
            double x = evt.clientX() - rect.left();
            double y = evt.clientY() - rect.top();
            return tx.apply(Point$.MODULE$.apply(x, y));
        };
    }

    private void addCallbacks(Element elt, Transform tx) {
        Function1<MouseEvent, Point> onMoveCallback = this.mouseMoveCallback(tx);
        Stream onMove = Stream$.MODULE$.repeatEval((java.lang.Object)IO$.MODULE$.async_((Function1 & Serializable)cb -> {
            this.$anonfun$1(elt, (Function1)onMoveCallback, (Function1)cb);
            return BoxedUnit.UNIT;
        }));
        Function1<MouseEvent, Point> onClickCallback = this.mouseClickCallback(tx);
        Stream onClick = Stream$.MODULE$.repeatEval((java.lang.Object)IO$.MODULE$.async_((Function1 & Serializable)cb -> {
            this.$anonfun$2(elt, (Function1)onClickCallback, (Function1)cb);
            return BoxedUnit.UNIT;
        }));
        this.mouseMoveStream = onMove;
        this.mouseClickStream = onClick;
    }

    public Node svgRoot(BoundingBox bb) {
        this.currentBB = bb;
        Transform tx = package$.MODULE$.Svg().inverseClientTransform(this.currentBB, this.frame().size());
        Size size = this.frame().size();
        if (size instanceof Size.FixedSize) {
            Size.FixedSize fixedSize = Size$FixedSize$.MODULE$.unapply((Size.FixedSize)size);
            double d = fixedSize._1();
            double d2 = fixedSize._2();
            return this.svgRoot;
        }
        if (size instanceof Size.FitToPicture) {
            Size.FitToPicture fitToPicture = Size$FitToPicture$.MODULE$.unapply((Size.FitToPicture)size);
            int n = fitToPicture._1();
            Element newRoot = (Element)package$.MODULE$.Svg().svgTag(bb, this.frame()).render();
            this.addCallbacks(newRoot, tx);
            this.target().replaceChild((Node)newRoot, this.svgRoot);
            this.svgRoot = newRoot;
            return this.svgRoot;
        }
        throw new MatchError((java.lang.Object)size);
    }

    public Stream<IO, Nothing$> stream() {
        return this.stream;
    }

    public Stream<IO, java.lang.Object> redraw() {
        return this.redraw;
    }

    public Stream<IO, Point> mouseClick() {
        return this.mouseClick;
    }

    public Stream<IO, Point> mouseMove() {
        return this.mouseMove;
    }

    public void renderChild(Node svgRoot, Node nodes) {
        if (this.svgChild == null || !svgRoot.contains(this.svgChild)) {
            svgRoot.appendChild(nodes);
            this.svgChild = nodes;
            return;
        }
        svgRoot.replaceChild(nodes, this.svgChild);
        this.svgChild = nodes;
    }

    public Tuple2<BoundingBox, SVGRect> textBoundingBox(String text, Font font) {
        Node elt = this.target().appendChild((Node)JsDom.svgTags$.MODULE$.svg().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Modifier[]{JsDom.svgAttrs$.MODULE$.visibility().$colon$eq((java.lang.Object)"hidden", JsDom.all$.MODULE$.stringAttr())})).render());
        Node txt = elt.appendChild((Node)package$.MODULE$.Svg().textTag(text, font, "").render());
        SVGRect bb = ((SVGTextElement)txt).getBBox();
        BoundingBox boundingBox = BoundingBox$.MODULE$.centered(bb.width(), bb.height());
        this.target().removeChild(elt);
        return Tuple2$.MODULE$.apply((java.lang.Object)boundingBox, (java.lang.Object)bb);
    }

    public <A> IO<A> render(Picture<JsAlgebraModule.JsAlgebra, A> picture) {
        return package$.MODULE$.Svg().renderWithoutRootTag(this.algebra(), picture).map((Function1 & Serializable)result -> {
            Tuple3 tuple3 = result;
            if (tuple3 == null) {
                throw new MatchError((java.lang.Object)tuple3);
            }
            BoundingBox bb = (BoundingBox)tuple3._1();
            TypedTag tags = (TypedTag)tuple3._2();
            java.lang.Object a = tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((java.lang.Object)bb, (java.lang.Object)tags, a);
            BoundingBox bb2 = (BoundingBox)tuple32._1();
            TypedTag tags2 = (TypedTag)tuple32._2();
            java.lang.Object a2 = tuple32._3();
            Node root = this.svgRoot(bb2);
            this.renderChild(root, (Node)tags2.render());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return a2;
        });
    }

    public Canvas copy(Node target, Frame frame, Topic<IO, java.lang.Object> redrawTopic, Topic<IO, Point> mouseClickTopic, Topic<IO, Point> mouseMoveTopic) {
        return new Canvas(target, frame, redrawTopic, mouseClickTopic, mouseMoveTopic);
    }

    public Node copy$default$1() {
        return this.target();
    }

    public Frame copy$default$2() {
        return this.frame();
    }

    public Topic<IO, java.lang.Object> copy$default$3() {
        return this.redrawTopic();
    }

    public Topic<IO, Point> copy$default$4() {
        return this.mouseClickTopic();
    }

    public Topic<IO, Point> copy$default$5() {
        return this.mouseMoveTopic();
    }

    public Node _1() {
        return this.target();
    }

    public Frame _2() {
        return this.frame();
    }

    public Topic<IO, java.lang.Object> _3() {
        return this.redrawTopic();
    }

    public Topic<IO, Point> _4() {
        return this.mouseClickTopic();
    }

    public Topic<IO, Point> _5() {
        return this.mouseMoveTopic();
    }

    private static final /* synthetic */ void $init$$$anonfun$1(Either _$1) {
    }

    private static final /* synthetic */ java.lang.Object $init$$$anonfun$2$$anonfun$1(BooleanRef started$2, DoubleRef lastTs$2, Function1 cb$1, double ts) {
        if (started$2.elem) {
            double diff = ts - lastTs$2.elem;
            lastTs$2.elem = ts;
            return cb$1.apply((java.lang.Object)scala.package$.MODULE$.Right().apply((java.lang.Object)BoxesRunTime.boxToInteger((int)((int)diff))));
        }
        started$2.elem = true;
        return cb$1.apply((java.lang.Object)scala.package$.MODULE$.Right().apply((java.lang.Object)BoxesRunTime.boxToInteger((int)0)));
    }

    private static final /* synthetic */ void $init$$$anonfun$2(BooleanRef started$1, DoubleRef lastTs$1, Function1 cb) {
        org.scalajs.dom.package$.MODULE$.window().requestAnimationFrame(ts -> Canvas.$init$$$anonfun$2$$anonfun$1(started$1, lastTs$1, cb, BoxesRunTime.unboxToDouble((java.lang.Object)ts)));
    }

    private final /* synthetic */ void $anonfun$1(Element elt$1, Function1 onMoveCallback$1, Function1 cb) {
        elt$1.addEventListener("move", evt -> cb.apply((java.lang.Object)scala.package$.MODULE$.Right().apply(onMoveCallback$1.apply((java.lang.Object)((MouseEvent)evt)))), this.eventListenerOptions);
    }

    private final /* synthetic */ void $anonfun$2(Element elt$2, Function1 onClickCallback$1, Function1 cb) {
        elt$2.addEventListener("click", evt -> cb.apply((java.lang.Object)scala.package$.MODULE$.Right().apply(onClickCallback$1.apply((java.lang.Object)((MouseEvent)evt)))), this.eventListenerOptions);
    }
}

