/*
 * Copyright 2015 Creative Scala
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package doodle
package turtle
package examples

import doodle.core._
import doodle.syntax.all._
import doodle.turtle.Instruction._
import doodle.turtle._

object Geometry {
  val instructions =
    List(
      forward(100),
      turn(45.degrees),
      forward(100),
      turn(45.degrees),
      forward(100),
      turn(45.degrees),
      forward(100),
      turn(45.degrees),
      forward(100),
      turn(45.degrees),
      forward(100),
      turn(45.degrees),
      forward(100),
      turn(45.degrees),
      forward(100)
    )

  val image = Turtle.draw(instructions).fillColor(Color.red)
}
