/*
 * Decompiled with CFR 0.152.
 */
package com.augustnagro.magnum.magcats;

import cats.effect.kernel.Async;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.kernel.syntax.MonadCancelOps$;
import cats.effect.syntax.package;
import cats.syntax.FlatMapOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.package;
import com.augustnagro.magnum.DbCon;
import com.augustnagro.magnum.DbTx;
import com.augustnagro.magnum.SqlException;
import com.augustnagro.magnum.SqlLogger;
import com.augustnagro.magnum.magcats.Transactor$;
import java.io.Serializable;
import java.sql.Connection;
import javax.sql.DataSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;

public class Transactor<F> {
    private final DataSource dataSource;
    private final SqlLogger sqlLogger;
    private final Function1<Connection, BoxedUnit> connectionConfig;
    private final Option<Resource<F, BoxedUnit>> rateLimiter;
    private final Sync<F> evidence$1;
    private final Resource<F, Connection> makeConn;

    public static <F> Object apply(DataSource dataSource, int n, Async<F> async) {
        return Transactor$.MODULE$.apply(dataSource, n, async);
    }

    public static <F> Object apply(DataSource dataSource, SqlLogger sqlLogger, Function1<Connection, BoxedUnit> function1, int n, Async<F> async) {
        return Transactor$.MODULE$.apply(dataSource, sqlLogger, function1, n, async);
    }

    public static <F> Object apply(DataSource dataSource, SqlLogger sqlLogger, Function1<Connection, BoxedUnit> function1, Sync<F> sync) {
        return Transactor$.MODULE$.apply(dataSource, sqlLogger, function1, sync);
    }

    public static <F> Object apply(DataSource dataSource, SqlLogger sqlLogger, int n, Async<F> async) {
        return Transactor$.MODULE$.apply(dataSource, sqlLogger, n, async);
    }

    public static <F> Object apply(DataSource dataSource, SqlLogger sqlLogger, Sync<F> sync) {
        return Transactor$.MODULE$.apply(dataSource, sqlLogger, sync);
    }

    public static <F> Object apply(DataSource dataSource, Sync<F> sync) {
        return Transactor$.MODULE$.apply(dataSource, sync);
    }

    public Transactor(DataSource dataSource, SqlLogger sqlLogger, Function1<Connection, BoxedUnit> connectionConfig, Option<Resource<F, BoxedUnit>> rateLimiter, Sync<F> evidence$1) {
        this.dataSource = dataSource;
        this.sqlLogger = sqlLogger;
        this.connectionConfig = connectionConfig;
        this.rateLimiter = rateLimiter;
        this.evidence$1 = evidence$1;
        this.makeConn = Resource$.MODULE$.make(this.acquireConnection(), (Function1 & Serializable)conn -> this.releaseConnection((Connection)conn), evidence$1);
    }

    private DataSource dataSource() {
        return this.dataSource;
    }

    private SqlLogger sqlLogger() {
        return this.sqlLogger;
    }

    private Function1<Connection, BoxedUnit> connectionConfig() {
        return this.connectionConfig;
    }

    private Option<Resource<F, BoxedUnit>> rateLimiter() {
        return this.rateLimiter;
    }

    public Transactor<F> withSqlLogger(SqlLogger sqlLogger) {
        return new Transactor<F>(this.dataSource(), sqlLogger, this.connectionConfig(), this.rateLimiter(), this.evidence$1);
    }

    public Transactor<F> withConnectionConfig(Function1<Connection, BoxedUnit> connectionConfig) {
        return new Transactor<F>(this.dataSource(), this.sqlLogger(), connectionConfig, this.rateLimiter(), this.evidence$1);
    }

    public <A> F connect(Function1<DbCon, A> f) {
        return this.useRateLimitedConnection((Function1 & Serializable)cn -> {
            Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(Sync$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                this.connect$$anonfun$1$$anonfun$1((Connection)cn);
                return BoxedUnit.UNIT;
            }), this.evidence$1);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.connect$$anonfun$1$$anonfun$2(f, cn), this.evidence$1);
        });
    }

    public <A> F transact(Function1<DbTx, A> f) {
        return this.useRateLimitedConnection((Function1 & Serializable)cn -> {
            Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(Sync$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                this.transact$$anonfun$1$$anonfun$1((Connection)cn);
                return BoxedUnit.UNIT;
            }), this.evidence$1);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.transact$$anonfun$1$$anonfun$2(f, cn), this.evidence$1);
        });
    }

    private <A> F useRateLimitedConnection(Function1<Connection, F> program) {
        Object io = this.makeConn.use(program, this.evidence$1);
        return (F)this.rateLimiter().fold(() -> Transactor.useRateLimitedConnection$$anonfun$1(io), (Function1 & Serializable)_$2 -> _$2.surround(io, this.evidence$1));
    }

    private F acquireConnection() {
        Object object = package.all$.MODULE$.catsSyntaxMonadError(Sync$.MODULE$.apply(this.evidence$1).blocking(this::acquireConnection$$anonfun$1), this.evidence$1);
        return (F)MonadErrorOps$.MODULE$.adaptError$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return new SqlException("Unable to acquire DB Connection", x);
            }
        }, this.evidence$1);
    }

    private F releaseConnection(Connection conn) {
        if (conn == null) {
            return (F)Sync$.MODULE$.apply(this.evidence$1).unit();
        }
        Object object = package.all$.MODULE$.catsSyntaxMonadError(Sync$.MODULE$.apply(this.evidence$1).blocking((Function0 & Serializable)() -> {
            Transactor.releaseConnection$$anonfun$1(conn);
            return BoxedUnit.UNIT;
        }), this.evidence$1);
        return (F)MonadErrorOps$.MODULE$.adaptError$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return new SqlException("Unable to close DB connection", x);
            }
        }, this.evidence$1);
    }

    private final void connect$$anonfun$1$$anonfun$1(Connection cn$1) {
        this.connectionConfig().apply((Object)cn$1);
    }

    private final Object connect$$anonfun$1$$anonfun$2$$anonfun$1(Function1 f$3, Connection cn$3) {
        return f$3.apply((Object)new DbCon(cn$3, this.sqlLogger()));
    }

    private final Object connect$$anonfun$1$$anonfun$2(Function1 f$2, Connection cn$2) {
        return Sync$.MODULE$.apply(this.evidence$1).interruptible(() -> this.connect$$anonfun$1$$anonfun$2$$anonfun$1(f$2, cn$2));
    }

    private final void transact$$anonfun$1$$anonfun$1(Connection cn$4) {
        this.connectionConfig().apply((Object)cn$4);
        cn$4.setAutoCommit(false);
    }

    private final Object transact$$anonfun$1$$anonfun$2$$anonfun$1(Function1 f$6, Connection cn$6) {
        return f$6.apply((Object)new DbTx(cn$6, this.sqlLogger()));
    }

    private static final void transact$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Connection cn$8) {
        cn$8.commit();
    }

    private static final void transact$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(Connection cn$9) {
        cn$9.rollback();
    }

    private final Object transact$$anonfun$1$$anonfun$2(Function1 f$5, Connection cn$5) {
        Object object = package.all$.MODULE$.monadCancelOps(Sync$.MODULE$.apply(this.evidence$1).interruptible(() -> this.transact$$anonfun$1$$anonfun$2$$anonfun$1(f$5, cn$5)), this.evidence$1);
        return MonadCancelOps$.MODULE$.guaranteeCase$extension(object, (Function1 & Serializable)x$1 -> {
            Outcome outcome;
            block6: {
                block5: {
                    block4: {
                        outcome = x$1;
                        if (outcome instanceof Outcome.Succeeded) {
                            Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                            Object object = succeeded._1();
                            return Sync$.MODULE$.apply(this.evidence$1).blocking((Function0 & Serializable)() -> {
                                Transactor.transact$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(cn$5);
                                return BoxedUnit.UNIT;
                            });
                        }
                        if (!(outcome instanceof Outcome.Errored)) break block4;
                        Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                        Throwable throwable = (Throwable)errored._1();
                        break block5;
                    }
                    if (!(outcome instanceof Outcome.Canceled) || !Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) break block6;
                }
                return Sync$.MODULE$.apply(this.evidence$1).blocking((Function0 & Serializable)() -> {
                    Transactor.transact$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(cn$5);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)outcome);
        }, this.evidence$1);
    }

    private static final Object useRateLimitedConnection$$anonfun$1(Object io$1) {
        return io$1;
    }

    private final Connection acquireConnection$$anonfun$1() {
        return this.dataSource().getConnection();
    }

    private static final void releaseConnection$$anonfun$1(Connection conn$1) {
        conn$1.close();
    }
}

