/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.dsl.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.groovy.datetime.extensions.DateTimeStaticExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.cristalise.dsl.csv.TabularGroovyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVGroovyParser
implements TabularGroovyParser,
GroovyObject {
    private Map<String, Object> options;
    private CSVReader reader;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public CSVGroovyParser(Reader ioReader, Map opts) {
        CSVReader cSVReader;
        MetaClass metaClass;
        Map map;
        this.options = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object var4_4 = null;
        this.reader = IndyInterface.bootstrap("cast", "()", 0, var4_4);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.setDefaultOptions(opts);
        this.reader = cSVReader = this.getCSVReader(ioReader);
    }

    @Override
    public void setHeaderRowCount(int rowCount) {
        int n;
        int n2 = n = rowCount;
        this.options.put("headerRowCount", n2);
    }

    @Override
    public void setHeader(List<List<String>> h) {
        List<List<String>> list;
        List<List<String>> list2 = list = h;
        this.options.put("header", list2);
    }

    private CSVReader getCSVReader(Reader ioReader) {
        CSVParser parser = new CSVParserBuilder().withSeparator(((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("separatorChar"), Character.class))).charValue()).withQuoteChar(((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("quoteChar"), Character.class))).charValue()).withEscapeChar(((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("escapeChar"), Character.class))).charValue()).withStrictQuotes((boolean)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("strictQuotes"), Boolean.class))).build();
        return new CSVReaderBuilder(ioReader).withCSVParser((ICSVParser)parser).withSkipLines(((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("skipRows"), Integer.class))).intValue()).build();
    }

    private void setDefaultOptions(Map opts) {
        Object object;
        String string;
        Character c;
        Character c2;
        Character c3;
        Boolean bl;
        Integer n;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer n5 = n4 = opts.get("headerRowCount") != null ? opts.get("headerRowCount") : Integer.valueOf(1);
        this.options.put("headerRowCount", n5);
        Integer n6 = n3 = opts.get("skipLeftCols") != null ? opts.get("skipLeftCols") : Integer.valueOf(0);
        this.options.put("skipLeftCols", n6);
        Integer n7 = n2 = opts.get("skipRightCols") != null ? opts.get("skipRightCols") : Integer.valueOf(0);
        this.options.put("skipRightCols", n7);
        Boolean bl5 = bl4 = opts.get("trimHeader") != null ? opts.get("trimHeader") : Boolean.valueOf(true);
        this.options.put("trimHeader", bl5);
        Boolean bl6 = bl3 = opts.get("trimData") != null ? opts.get("trimData") : Boolean.valueOf(false);
        this.options.put("trimData", bl6);
        Boolean bl7 = bl2 = opts.get("strictQuotes") != null ? opts.get("strictQuotes") : Boolean.valueOf(CSVParser.DEFAULT_STRICT_QUOTES);
        this.options.put("strictQuotes", bl7);
        Integer n8 = n = opts.get("skipRows") != null ? opts.get("skipRows") : Integer.valueOf(CSVReader.DEFAULT_SKIP_LINES);
        this.options.put("skipRows", n8);
        Boolean bl8 = bl = opts.get("useStringOnly") != null ? opts.get("useStringOnly") : Boolean.valueOf(false);
        this.options.put("useStringOnly", bl8);
        Object v = opts.get("separatorChar");
        Character c4 = c3 = (v == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v)) != false ? opts.get("separatorChar") : Character.valueOf(CSVParser.DEFAULT_SEPARATOR);
        this.options.put("separatorChar", c4);
        Object v2 = opts.get("quoteChar");
        Character c5 = c2 = (v2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v2)) != false ? opts.get("quoteChar") : Character.valueOf(CSVParser.DEFAULT_QUOTE_CHARACTER);
        this.options.put("quoteChar", c5);
        Object v3 = opts.get("escapeChar");
        Character c6 = c = (v3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v3)) != false ? opts.get("escapeChar") : Character.valueOf(CSVParser.DEFAULT_ESCAPE_CHARACTER);
        this.options.put("escapeChar", c6);
        Object v4 = opts.get("dateFormatter");
        String string2 = string = (v4 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v4)) != false ? opts.get("dateFormatter") : "";
        this.options.put("dateFormatter", string2);
        Object v5 = opts.get("header");
        Object object2 = object = (v5 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v5)) != false ? opts.get("header") : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.options.put("header", object2);
    }

    @Override
    public List<List<String>> getHeader() {
        int rowCount = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("headerRowCount"), Integer.class));
        int skipLeftCols = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("skipLeftCols"), Integer.class));
        int skipRightCols = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("skipRightCols"), Integer.class));
        boolean trim = DefaultTypeTransformation.booleanUnbox((Object)this.options.get("trimData"));
        if (!(rowCount != 0)) {
            StringBuilder stringBuilder = new StringBuilder("rowCount. Values: ");
            stringBuilder.append((Object)"rowCount = ");
            stringBuilder.append(InvokerHelper.toString((Object)rowCount));
            throw InvokerHelper.createAssertError((Object)stringBuilder, (Object)"row count for header must be grater than zero");
        }
        if (log.isDebugEnabled()) {
            log.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{rowCount, skipLeftCols, skipRightCols}, new String[]{"getHeader() - rowCount: ", ", skipLeftCols: ", ", skipRightCols: ", ""}))));
            v0 = null;
        } else {
            v0 = null;
        }
        CallSite headerRows = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Integer size = null;
        IntRange intRange = new IntRange(true, true, 0, rowCount - 1);
        Object i = null;
        Iterator iterator = intRange != null ? intRange.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                i = iterator.next();
                String[] stringArray = this.reader.readNext();
                ScriptBytecodeAdapter.invokeMethodN(CSVGroovyParser.class, (Object)headerRows, (String)"putAt", (Object[])new Object[]{i, stringArray});
                if (IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)headerRows), (int)DefaultTypeTransformation.intUnbox(i))) == false) {
                    StringBuilder stringBuilder = new StringBuilder("headerRows[i]. Values: ");
                    stringBuilder.append((Object)"headerRows = ");
                    stringBuilder.append(InvokerHelper.toString((Object)headerRows));
                    stringBuilder.append((Object)", i = ");
                    stringBuilder.append(InvokerHelper.toString(i));
                    throw InvokerHelper.createAssertError((Object)stringBuilder, (Object)new GStringImpl(new Object[]{i}, new String[]{"", ". row in header is null or zero size"}));
                }
                if (log.isDebugEnabled()) {
                    log.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{i, DefaultGroovyMethods.size((Object[])IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)headerRows), (int)DefaultTypeTransformation.intUnbox(i))))}, new String[]{"getHeader() - headerRows[", "] size: ", ""}))));
                    v1 = null;
                } else {
                    v1 = null;
                }
                Integer n = size;
                if ((n == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, n)) != false && !ScriptBytecodeAdapter.compareEqual((Object)DefaultGroovyMethods.size((Object[])IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)headerRows), (int)DefaultTypeTransformation.intUnbox(i)))), size)) {
                    StringBuilder stringBuilder = new StringBuilder("(headerRows[i].size() == size). Values: ");
                    stringBuilder.append((Object)"size = ");
                    stringBuilder.append(InvokerHelper.toString((Object)size));
                    throw InvokerHelper.createAssertError((Object)stringBuilder, (Object)new GStringImpl(new Object[]{i}, new String[]{"", ". header row size is not equal with the previous. All header rows must have the same size"}));
                }
                size = DefaultGroovyMethods.size((Object[])IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)headerRows), (int)DefaultTypeTransformation.intUnbox(i))));
            }
        }
        CallSite currentNames = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        CallSite header = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        IntRange intRange2 = new IntRange(true, true, skipLeftCols, DefaultTypeTransformation.intUnbox((Object)NumberNumberMinus.minus(size, (Number)(1 + skipRightCols))));
        Iterator iterator2 = intRange2 != null ? intRange2.iterator() : null;
        int i2 = 0;
        Iterator iterator3 = iterator2;
        if (iterator3 != null) {
            while (iterator3.hasNext()) {
                i2 = DefaultTypeTransformation.intUnbox(iterator3.next());
                CallSite aList = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                Object j = null;
                IntRange intRange3 = new IntRange(true, true, 0, rowCount - 1);
                Iterator iterator4 = intRange3 != null ? intRange3.iterator() : null;
                if (iterator4 != null) {
                    while (iterator4.hasNext()) {
                        j = iterator4.next();
                        CallSite name = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)headerRows), (int)DefaultTypeTransformation.intUnbox(j))), (int)i2));
                        CallSite callSite = name;
                        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
                            Object object = trim && name instanceof String ? ((String)((Object)name)).trim() : name;
                            ScriptBytecodeAdapter.invokeMethodN(CSVGroovyParser.class, (Object)currentNames, (String)"putAt", (Object[])new Object[]{j, object});
                        }
                        name = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)currentNames), (int)DefaultTypeTransformation.intUnbox(j)));
                        CallSite callSite2 = name;
                        if ((callSite2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite2)) == false) continue;
                        ((ArrayList)((Object)aList)).add(name);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{i2 - skipLeftCols, aList}, new String[]{"getHeader() - header[", "] = ", ""}))));
                    v6 = null;
                } else {
                    v6 = null;
                }
                ((ArrayList)((Object)header)).add(aList);
            }
        }
        return header;
    }

    private Object getValue(String value) {
        boolean trim;
        block15: {
            trim = DefaultTypeTransformation.booleanUnbox((Object)this.options.get("trimData"));
            String string = value;
            if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) == false) {
                return null;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.options.get("useStringOnly"))) {
                return trim ? value.trim() : value;
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)value, (Object)"null")) {
                return null;
            }
            if (NumberUtils.isCreatable((String)value)) {
                if (StringGroovyMethods.isInteger((CharSequence)value)) {
                    return (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value.trim(), Integer.class));
                }
                if (StringGroovyMethods.isBigInteger((CharSequence)value)) {
                    return (BigInteger)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value.trim(), BigInteger.class));
                }
                if (StringGroovyMethods.isBigDecimal((CharSequence)value)) {
                    return (BigDecimal)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value.trim(), BigDecimal.class));
                }
                return (Number)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value.trim(), Number.class));
            }
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.options.get("dateFormatter"));
            if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) break block15;
            LocalDate localDate = DateTimeStaticExtensions.parse(null, (CharSequence)value.trim(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.options.get("dateFormatter"))));
            return localDate;
        }
        LocalDate localDate = LocalDate.parse(value.trim());
        try {
            return localDate;
        }
        catch (DateTimeParseException e) {
            String string = trim ? value.trim() : value;
            return string;
        }
    }

    private void convertNamesToMaps(Map<String, Object> map, List<String> names, String value) {
        Object name = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.head(names));
        List namesTail = DefaultGroovyMethods.tail(names);
        int index = -1;
        if (((String)name).contains("[") && ((String)name).endsWith("]")) {
            int i = ((String)name).indexOf("[");
            index = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ((String)name).substring(i + 1, StringGroovyMethods.size((CharSequence)name) - 1), Integer.class));
            name = ((String)name).substring(0, i);
        }
        if (log.isDebugEnabled()) {
            log.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name, index, names, value}, new String[]{"", " index:", " names:", " value:'", "'"}))));
            v0 = null;
        } else {
            v0 = null;
        }
        List list = namesTail;
        if ((list == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, list)) != false) {
            if (index == -1) {
                if (IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(map, (Object)name)) == false) {
                    Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    ScriptBytecodeAdapter.invokeMethodN(CSVGroovyParser.class, map, (String)"putAt", (Object[])new Object[]{name, map2});
                }
                this.convertNamesToMaps((Map<String, Object>)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(map, (Object)name))), namesTail, value);
            } else {
                if (IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(map, (Object)name)) == false) {
                    List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    ScriptBytecodeAdapter.invokeMethodN(CSVGroovyParser.class, map, (String)"putAt", (Object[])new Object[]{name, list2});
                }
                if (IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(map, (Object)name))), (int)index)) == false) {
                    Map map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    ScriptBytecodeAdapter.invokeMethodN(CSVGroovyParser.class, (Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(map, (Object)name)), (String)"putAt", (Object[])new Object[]{index, map3});
                }
                this.convertNamesToMaps((Map<String, Object>)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(map, (Object)name))), (int)index))), namesTail, value);
            }
        } else {
            Object object = this.getValue(value);
            ScriptBytecodeAdapter.invokeMethodN(CSVGroovyParser.class, map, (String)"putAt", (Object[])new Object[]{name, object});
            if (log.isDebugEnabled()) {
                log.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name, DefaultGroovyMethods.getAt(map, (Object)name)}, new String[]{"map[", "] = ", ""}))));
                v2 = null;
            } else {
                v2 = null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void eachRow(Closure cl) {
        nextLine = new Reference(null);
        (String[])nextLine.get();
        headerRowCount = (Integer)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("headerRowCount"), Integer.class);
        skipLeftCols = new Reference((Object)((int)((Integer)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("skipLeftCols"), Integer.class))));
        skipRightCols = (Integer)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("skipRightCols"), Integer.class);
        header = (List<List<String>>)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("header"), List.class);
        rowIndex = 0;
        if (!(headerRowCount != 0 == false)) ** GOTO lbl-1000
        v0 = header;
        if ((v0 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v0)) == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (v1) {
            CSVGroovyParser.log.warn("No header was specified so reverting to original openCsv behaviour");
            while (true) {
                v2 = this.reader.readNext();
                nextLine.set((Object)v2);
                if (v2 != null) {
                    v3 = new Object[2];
                    v3[0] = (String[])nextLine.get();
                    var8_8 = rowIndex;
                    var8_8 + 1;
                    v3[1] = var8_8;
                    cl.call(v3);
                    continue;
                }
                break;
            }
        } else {
            v4 = header;
            if ((v4 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v4)) == false) {
                header = this.getHeader();
            } else if (CSVGroovyParser.log.isDebugEnabled()) {
                CSVGroovyParser.log.debug((String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{header}, new String[]{"external header: ", ""})));
                v5 = null;
            } else {
                v5 = null;
            }
            v6 = header;
            if ((v6 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v6)) == false) {
                var9_9 = new StringBuilder("header. Values: ");
                var9_9.append((Object)"header = ");
                var9_9.append(InvokerHelper.toString(header));
                throw InvokerHelper.createAssertError((Object)var9_9, (Object)"no header is availalle");
            }
            while (true) {
                v7 = this.reader.readNext();
                nextLine.set((Object)v7);
                if (!(v7 != null)) break;
                if (!(header.size() == DefaultGroovyMethods.size((Object[])((String[])nextLine.get())) - DefaultTypeTransformation.intUnbox((Object)NumberNumberPlus.plus((Number)((Integer)skipLeftCols.get()), (Number)skipRightCols)))) {
                    var10_12 = new StringBuilder("(header.size() == (nextLine.size() - (skipLeftCols + skipRightCols))). Values: ");
                    var10_12.append((Object)"skipLeftCols = ");
                    var10_12.append(InvokerHelper.toString((Object)((Integer)skipLeftCols.get())));
                    var10_12.append((Object)", skipRightCols = ");
                    var10_12.append(InvokerHelper.toString((Object)skipRightCols));
                    throw InvokerHelper.createAssertError((Object)var10_12, (Object)"Header size must be equal with the size of data line");
                }
                map = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0])));
                DefaultGroovyMethods.eachWithIndex(header, (Closure)new _eachRow_closure1(this, this, nextLine, skipLeftCols, map));
                v8 = new Object[2];
                v8[0] = (LinkedHashMap)map.get();
                var12_11 = rowIndex;
                var12_11 + 1;
                v8[1] = var12_11;
                cl.call(v8);
            }
        }
    }

    public static List<List<String>> csvHeader(File self, Map options) {
        return new CSVGroovyParser(new FileReader(self), options).getHeader();
    }

    public static List<List<String>> csvHeader(String self, Map options) {
        return new CSVGroovyParser(new StringReader(self), options).getHeader();
    }

    public static void csvEachRow(File self, Map options, Closure cl) {
        new CSVGroovyParser(new FileReader(self), options).eachRow(cl);
    }

    public static void csvEachRow(String self, Map options, Closure cl) {
        new CSVGroovyParser(new StringReader(self), options).eachRow(cl);
    }

    @Deprecated
    public static void parse(File file, Closure cl) throws IOException {
        CSVGroovyParser.csvEachRow(file, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"headerRowCount", 1, "trimData", true, "useStringOnly", true}), cl);
    }

    @Deprecated
    public static void parse(String string, Closure cl) throws IOException {
        CSVGroovyParser.csvEachRow(string, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"headerRowCount", 1, "trimData", true, "useStringOnly", true}), cl);
    }

    @Generated
    public static List<List<String>> csvHeader(File self) {
        return CSVGroovyParser.csvHeader(self, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public static List<List<String>> csvHeader(String self) {
        return CSVGroovyParser.csvHeader(self, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public static void csvEachRow(File self, Closure cl) {
        CSVGroovyParser.csvEachRow(self, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), cl);
    }

    @Generated
    public static void csvEachRow(String self, Closure cl) {
        CSVGroovyParser.csvEachRow(self, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), cl);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CSVGroovyParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.cristalise.dsl.csv.CSVGroovyParser");
    }

    @Generated
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Generated
    public void setOptions(Map<String, Object> map) {
        this.options = map;
    }

    @Generated
    public CSVReader getReader() {
        return this.reader;
    }

    @Generated
    public void setReader(CSVReader cSVReader) {
        this.reader = cSVReader;
    }
}

