/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.dsl.csv;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.cristalise.dsl.csv.TabularGroovyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelGroovyParser
implements TabularGroovyParser,
GroovyObject {
    private Map<String, Object> options;
    private XSSFSheet sheet;
    private DataFormatter formatter;
    private FormulaEvaluator evaluator;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ExcelGroovyParser(XSSFWorkbook workbook, XSSFSheet s, Map opts) {
        XSSFSheet xSSFSheet;
        Integer n;
        MetaClass metaClass;
        DataFormatter dataFormatter;
        Map map;
        this.options = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object var5_5 = null;
        this.sheet = IndyInterface.bootstrap("cast", "()", 0, var5_5);
        this.formatter = dataFormatter = new DataFormatter();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        XSSFFormulaEvaluator xSSFFormulaEvaluator = new XSSFFormulaEvaluator(workbook);
        this.evaluator = xSSFFormulaEvaluator;
        Integer n2 = n = opts.get("headerRowCount") != null ? opts.get("headerRowCount") : Integer.valueOf(1);
        this.options.put("headerRowCount", n2);
        this.sheet = xSSFSheet = s;
    }

    @Override
    public void setHeaderRowCount(int rowCount) {
        int n;
        int n2 = n = rowCount;
        this.options.put("headerRowCount", n2);
    }

    @Override
    public void setHeader(List<List<String>> h) {
        List<List<String>> list;
        List<List<String>> list2 = list = h;
        this.options.put("header", list2);
    }

    @Override
    public List<List<String>> getHeader() {
        int headerRowCount = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("headerRowCount"), Integer.class));
        List header = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        XSSFSheet xSSFSheet = this.sheet;
        Iterator iterator = xSSFSheet != null ? xSSFSheet.iterator() : null;
        CallSite row = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                CallSite cell = null;
                row = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                CallSite callSite = row;
                Iterator iterator3 = callSite != null ? callSite.iterator() : null;
                if (iterator3 != null) {
                    while (iterator3.hasNext()) {
                        Object v4;
                        cell = IndyInterface.bootstrap("cast", "()", 0, iterator3.next());
                        String cellText = this.formatter.formatCellValue((Cell)cell);
                        CellRangeAddress currentRegion = this.getMergedRegionForCell((Cell)cell);
                        CellRangeAddress cellRangeAddress = currentRegion;
                        if ((cellRangeAddress == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, cellRangeAddress)) != false) {
                            cellText = this.formatter.formatCellValue(row.getCell(currentRegion.getFirstColumn()), this.evaluator);
                        }
                        if (log.isDebugEnabled()) {
                            String cellRef = new CellReference(row.getRowNum(), cell.getColumnIndex()).formatAsString();
                            if (log.isDebugEnabled()) {
                                log.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{cell.getRowIndex(), cellRef, cellText}, new String[]{"getHeader() - row:", " cell:", "='", "'"}).plus(currentRegion == null ? "" : StringGroovyMethods.plus((String)" - region:", (CharSequence)currentRegion.formatAsString())))));
                                v2 = null;
                            } else {
                                v2 = null;
                            }
                        }
                        String string = cellText;
                        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
                            if (DefaultGroovyMethods.getAt((List)header, (int)cell.getColumnIndex()) == null) {
                                List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                                ScriptBytecodeAdapter.invokeMethodN(ExcelGroovyParser.class, (Object)header, (String)"putAt", (Object[])new Object[]{cell.getColumnIndex(), list});
                            }
                            ((List)DefaultGroovyMethods.getAt((List)header, (int)cell.getColumnIndex())).add(cellText);
                            continue;
                        }
                        if (!log.isDebugEnabled()) break;
                        String cellRef = new CellReference(row.getRowNum(), cell.getColumnIndex()).formatAsString();
                        if (log.isDebugEnabled()) {
                            log.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{cell.getRowIndex(), cellRef, cellText}, new String[]{"getHeader() - STOPPING at row:", " cell:", "='", "'"}).plus(currentRegion == null ? "" : StringGroovyMethods.plus((String)" - region:", (CharSequence)currentRegion.formatAsString())))));
                            v4 = null;
                            break;
                        }
                        v4 = null;
                        break;
                    }
                }
                if (!(row.getRowNum() == headerRowCount - 1)) continue;
                break;
            }
        }
        public final class _getHeader_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getHeader_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<String> doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, it);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public List<String> doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getHeader_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        header = DefaultGroovyMethods.findAll((List)header, (Closure)new _getHeader_closure1(this, this));
        log.debug("getHeader() - header:{}", (Object)header);
        return header;
    }

    private void convertNamesToMaps(Map map, List<String> names, String value) {
        CallSite name = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.head(names));
        List namesTail = DefaultGroovyMethods.tail(names);
        log.debug("convertNamesToMaps() - {} names:{} value:'{}'", new Object[]{name, names, value});
        List list = namesTail;
        if ((list == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, list)) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((Map)map, (Object)name)) == false) {
                Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                ScriptBytecodeAdapter.invokeMethodN(ExcelGroovyParser.class, (Object)map, (String)"putAt", (Object[])new Object[]{name, map2});
            }
            this.convertNamesToMaps((Map)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((Map)map, (Object)name))), namesTail, value);
        } else {
            String string = value;
            ScriptBytecodeAdapter.invokeMethodN(ExcelGroovyParser.class, (Object)map, (String)"putAt", (Object[])new Object[]{name, string});
            if (log.isDebugEnabled()) {
                log.debug("convertNamesToMaps() - map[{}] = {}", (Object)name, DefaultGroovyMethods.getAt((Map)map, (Object)name));
                v1 = null;
            } else {
                v1 = null;
            }
        }
    }

    @Override
    public void eachRow(Closure block) {
        List<List<String>> header = this.getHeader();
        int headerRowCount = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, this.options.get("headerRowCount"), Integer.class));
        int numberOfColumns = header.size();
        XSSFSheet xSSFSheet = this.sheet;
        Iterator iterator = xSSFSheet != null ? xSSFSheet.iterator() : null;
        CallSite row = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                row = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                if (row.getRowNum() < headerRowCount) continue;
                CallSite rowMap = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                if (log.isDebugEnabled()) {
                    log.debug("eachRow() - row #{} numberOfColumns:{} physicalNumberOfCells:{}", new Object[]{row.getRowNum(), numberOfColumns, row.getPhysicalNumberOfCells()});
                    v1 = null;
                } else {
                    v1 = null;
                }
                int idx = 0;
                while (idx < numberOfColumns) {
                    Cell cell = row.getCell(idx);
                    if (cell != null) {
                        String cellRef = new CellReference(row.getRowNum(), cell.getColumnIndex()).formatAsString();
                        String cellText = this.formatter.formatCellValue(cell, this.evaluator);
                        if (log.isDebugEnabled()) {
                            log.debug("eachRow() - row:{} cell:{}='{}'", new Object[]{cell.getRowIndex(), cellRef, cellText});
                            v2 = null;
                        } else {
                            v2 = null;
                        }
                        this.convertNamesToMaps((Map)((Object)rowMap), (List<String>)((Object)IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(header, (int)cell.getColumnIndex()))), cellText);
                    }
                    int n = idx;
                    int cfr_ignored_0 = n + 1;
                }
                if (!(row != null && row.getPhysicalNumberOfCells() != 0)) break;
                block.call(new Object[]{rowMap, row.getRowNum() - headerRowCount});
                ((LinkedHashMap)((Object)rowMap)).clear();
            }
        }
    }

    private CellRangeAddress getMergedRegionForCell(Cell c) {
        List list = this.sheet.getMergedRegions();
        Iterator iterator = list != null ? list.iterator() : null;
        CallSite mergedRegion = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                mergedRegion = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                if (!mergedRegion.isInRange(c)) continue;
                return mergedRegion;
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Object getCellValue(Cell cell) {
        CellType cellType = cell.getCellType();
        if (ScriptBytecodeAdapter.isCase((Object)cellType, (Object)CellType.STRING)) {
            return cell.getStringCellValue();
        }
        if (ScriptBytecodeAdapter.isCase((Object)cellType, (Object)CellType.NUMERIC)) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                return cell.getDateCellValue();
            }
            return cell.getNumericCellValue();
        }
        if (ScriptBytecodeAdapter.isCase((Object)cellType, (Object)CellType.BOOLEAN)) {
            return cell.getBooleanCellValue();
        }
        if (ScriptBytecodeAdapter.isCase((Object)cellType, (Object)CellType.FORMULA)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            if (ScriptBytecodeAdapter.isCase((Object)cellType2, (Object)CellType.NUMERIC)) {
                return cell.getNumericCellValue();
            }
            if (ScriptBytecodeAdapter.isCase((Object)cellType2, (Object)CellType.STRING)) {
                return cell.getStringCellValue();
            }
            if (ScriptBytecodeAdapter.isCase((Object)cellType2, (Object)CellType.BOOLEAN)) {
                return cell.getBooleanCellValue();
            }
            if (ScriptBytecodeAdapter.isCase((Object)cellType2, (Object)CellType.ERROR)) {
                return cell.getErrorCellValue();
            }
            return null;
        }
        if (ScriptBytecodeAdapter.isCase((Object)cellType, (Object)CellType.ERROR)) {
            return cell.getErrorCellValue();
        }
        if (ScriptBytecodeAdapter.isCase((Object)cellType, (Object)CellType.BLANK)) {
            return "";
        }
        return null;
    }

    public static List<List<String>> excelHeader(File self, String sheetName, Map options) {
        FileInputStream fileStream = new FileInputStream(self);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileStream);
        List<List<String>> header = ExcelGroovyParser.excelHeader(workbook, workbook.getSheet(sheetName.trim()), options);
        workbook.close();
        fileStream.close();
        return header;
    }

    public static List<List<String>> excelHeader(XSSFWorkbook workbook, XSSFSheet sheet, Map options) {
        return new ExcelGroovyParser(workbook, sheet, options).getHeader();
    }

    public static void excelEachRow(File self, String sheetName, Map options, Closure block) {
        FileInputStream fileStream = new FileInputStream(self);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileStream);
        XSSFSheet sheet = workbook.getSheet(sheetName.trim());
        ExcelGroovyParser.excelEachRow(workbook, sheet, options, block);
        workbook.close();
        fileStream.close();
    }

    public static void excelEachRow(XSSFWorkbook workbook, XSSFSheet sheet, Map options, Closure block) {
        ExcelGroovyParser egp = new ExcelGroovyParser(workbook, sheet, options);
        egp.eachRow(block);
    }

    @Generated
    public static List<List<String>> excelHeader(File self, String sheetName) {
        return ExcelGroovyParser.excelHeader(self, sheetName, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public static List<List<String>> excelHeader(XSSFWorkbook workbook, XSSFSheet sheet) {
        return ExcelGroovyParser.excelHeader(workbook, sheet, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public static void excelEachRow(File self, String sheetName, Closure block) {
        ExcelGroovyParser.excelEachRow(self, sheetName, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), block);
    }

    @Generated
    public static void excelEachRow(XSSFWorkbook workbook, XSSFSheet sheet, Closure block) {
        ExcelGroovyParser.excelEachRow(workbook, sheet, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), block);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExcelGroovyParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.cristalise.dsl.csv.ExcelGroovyParser");
    }

    @Generated
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Generated
    public void setOptions(Map<String, Object> map) {
        this.options = map;
    }

    @Generated
    public XSSFSheet getSheet() {
        return this.sheet;
    }

    @Generated
    public void setSheet(XSSFSheet xSSFSheet) {
        this.sheet = xSSFSheet;
    }

    @Generated
    public DataFormatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public void setFormatter(DataFormatter dataFormatter) {
        this.formatter = dataFormatter;
    }

    @Generated
    public FormulaEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Generated
    public void setEvaluator(FormulaEvaluator formulaEvaluator) {
        this.evaluator = formulaEvaluator;
    }
}

