/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.dsl.csv;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.cristalise.dsl.csv.CSVGroovyParser;
import org.cristalise.dsl.csv.ExcelGroovyParser;
import org.cristalise.dsl.csv.TabularGroovyParser;
import org.cristalise.kernel.common.InvalidDataException;

public class TabularGroovyParserBuilder
implements GroovyObject {
    private TabularGroovyParser.ParserTypes type;
    private File file;
    private String sheetName;
    private List<List<String>> header;
    private Integer headerRowCount;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public TabularGroovyParserBuilder() {
        MetaClass metaClass;
        Object var1_1 = null;
        this.type = IndyInterface.bootstrap("cast", "()", 0, var1_1);
        Object var2_2 = null;
        this.file = IndyInterface.bootstrap("cast", "()", 0, var2_2);
        Object var3_3 = null;
        this.sheetName = IndyInterface.bootstrap("cast", "()", 0, var3_3);
        Object var4_4 = null;
        this.header = IndyInterface.bootstrap("cast", "()", 0, var4_4);
        Object var5_5 = null;
        this.headerRowCount = IndyInterface.bootstrap("cast", "()", 0, var5_5);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public TabularGroovyParserBuilder csvParser(File f) {
        File file;
        TabularGroovyParser.ParserTypes parserTypes;
        this.type = parserTypes = TabularGroovyParser.ParserTypes.CSV;
        this.file = file = f;
        return this;
    }

    public TabularGroovyParserBuilder excelParser(File f, String name) {
        String string;
        File file;
        TabularGroovyParser.ParserTypes parserTypes;
        this.type = parserTypes = TabularGroovyParser.ParserTypes.EXCEL;
        this.file = file = f;
        this.sheetName = string = name;
        return this;
    }

    public TabularGroovyParserBuilder withHeaderRowCount(int count) {
        int n = count;
        this.headerRowCount = n;
        return this;
    }

    public TabularGroovyParserBuilder withHeader(List<List<String>> h) {
        List<List<String>> list = h;
        this.header = list;
        return this;
    }

    private TabularGroovyParser initCsvParser(Map options) {
        FileReader reader = new FileReader(this.file);
        return new CSVGroovyParser(reader, options);
    }

    private TabularGroovyParser initExcelParser(Map options) {
        FileInputStream is = new FileInputStream(this.file);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)is);
        XSSFSheet sheet = workbook.getSheet(this.sheetName.trim());
        return new ExcelGroovyParser(workbook, sheet, options);
    }

    public TabularGroovyParser build() {
        TabularGroovyParser.ParserTypes parserTypes;
        if (this.type == null) {
            throw (Throwable)new InvalidDataException();
        }
        CallSite options = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        if (this.headerRowCount != null) {
            Integer n = this.headerRowCount;
            ScriptBytecodeAdapter.invokeMethodN(TabularGroovyParserBuilder.class, (Object)options, (String)"putAt", (Object[])new Object[]{"headerRowCount", n});
        }
        if (this.header != null) {
            List<List<String>> list = this.header;
            ScriptBytecodeAdapter.invokeMethodN(TabularGroovyParserBuilder.class, (Object)options, (String)"putAt", (Object[])new Object[]{"header", list});
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)(parserTypes = this.type)), (Object)((Object)TabularGroovyParser.ParserTypes.CSV))) {
            return this.initCsvParser((Map)((Object)options));
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)parserTypes), (Object)((Object)TabularGroovyParser.ParserTypes.EXCEL))) {
            return this.initExcelParser((Map)((Object)options));
        }
        throw (Throwable)new InvalidDataException();
    }

    public static TabularGroovyParser build(File file, String sheet, int headerRowCount) {
        String fileName = file.getName();
        String type = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
        String string = type;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"XLSX")) {
            return new TabularGroovyParserBuilder().excelParser(file, sheet).withHeaderRowCount(headerRowCount).build();
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"CSV")) {
            return new TabularGroovyParserBuilder().csvParser(file).withHeaderRowCount(headerRowCount).build();
        }
        throw (Throwable)new UnsupportedOperationException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{type, fileName}, new String[]{"Unsupported file type:", " name:", ""}))));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TabularGroovyParserBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

