/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.dsl.module;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitStatus
extends Enum<GitStatus>
implements GroovyObject {
    public static final /* enum */ GitStatus ADDED;
    public static final /* enum */ GitStatus MODIFIED;
    public static final /* enum */ GitStatus REMOVED;
    public static final /* enum */ GitStatus UNTRACKED;
    public static final GitStatus MIN_VALUE;
    public static final GitStatus MAX_VALUE;
    private static final /* synthetic */ GitStatus[] $VALUES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    private GitStatus(LinkedHashMap __namedArgs) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (__namedArgs == null) {
            throw (Throwable)new IllegalArgumentException("One of the enum constants for enum org.cristalise.dsl.module.GitStatus was initialized with null. Please use a non-null value or define your own constructor.");
        }
        ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
    }

    @Generated
    private GitStatus() {
        this(new LinkedHashMap());
    }

    public static Map<GitStatus, List<Path>> getStatusMapForWorkTree(String workDir) {
        RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
        Repository repo = ((RepositoryBuilder)((RepositoryBuilder)repositoryBuilder.findGitDir(new File(workDir))).setMustExist(true)).build();
        Git git = Git.wrap((Repository)repo);
        Status currentStatus = git.status().call();
        Path gitParentDirPath = repo.getDirectory().getParentFile().toPath();
        LinkedHashMap<GitStatus, List<Path>> statusMap = new LinkedHashMap<GitStatus, List<Path>>();
        Path workDirPath = Paths.get(workDir, new String[0]).normalize();
        if (!currentStatus.isClean()) {
            GitStatus.updateStatusMap(statusMap, ADDED, currentStatus.getAdded(), gitParentDirPath, workDirPath);
            GitStatus.updateStatusMap(statusMap, MODIFIED, currentStatus.getModified(), gitParentDirPath, workDirPath);
            GitStatus.updateStatusMap(statusMap, REMOVED, currentStatus.getRemoved(), gitParentDirPath, workDirPath);
            GitStatus.updateStatusMap(statusMap, UNTRACKED, currentStatus.getUntracked(), gitParentDirPath, workDirPath);
        }
        return statusMap;
    }

    private static void updateStatusMap(Map<GitStatus, List<Path>> statusMap, GitStatus status, Set<String> files, Path gitDir, Path workDir) {
        Logger log = LoggerFactory.getLogger(GitStatus.class);
        Set<String> set = files;
        Iterator<String> iterator = set != null ? set.iterator() : null;
        CallSite file = null;
        Iterator<String> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                file = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                Path filePath = Paths.get(gitDir.toString(), new String[]{file}).normalize();
                if (filePath.startsWith(workDir)) {
                    log.info("updateStatusMap() - adding {}:{}", (Object)status, (Object)filePath);
                    if (IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(statusMap, (Object)((Object)status))) == false) {
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        ScriptBytecodeAdapter.invokeMethodN(GitStatus.class, statusMap, (String)"putAt", (Object[])new Object[]{status, list});
                    }
                    ((List)DefaultGroovyMethods.getAt(statusMap, (Object)((Object)status))).add(filePath);
                    continue;
                }
                log.debug("updateStatusMap() - SKIPPING {}:{} workDir:{}", new Object[]{status, filePath, workDir});
            }
        }
    }

    @Generated
    public static final GitStatus[] values() {
        return IndyInterface.bootstrap("cast", "()", 0, $VALUES.clone());
    }

    @Generated
    public GitStatus next() {
        Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])$VALUES))) {
            ordinal = 0;
        }
        return IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)));
    }

    @Generated
    public GitStatus previous() {
        Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
        if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
            ordinal = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])$VALUES), (Number)1);
        }
        return IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)));
    }

    @Generated
    public static GitStatus valueOf(String name) {
        return IndyInterface.bootstrap("cast", "()", 0, Enum.valueOf(GitStatus.class, name));
    }

    @Generated
    public static final /* synthetic */ GitStatus $INIT(Object ... para) {
        GitStatus gitStatus;
        Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
        switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, GitStatus.class)) {
            case -1348271900: {
                GitStatus gitStatus2;
                gitStatus = gitStatus2;
                Object[] objectArray2 = objectArray;
                gitStatus2 = new GitStatus();
                break;
            }
            case -242181752: {
                GitStatus gitStatus2;
                gitStatus = gitStatus2;
                Object[] objectArray2 = objectArray;
                gitStatus2 = new GitStatus((LinkedHashMap)((Object)IndyInterface.bootstrap("cast", "()", 0, objectArray[2])));
                break;
            }
            default: {
                throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
            }
        }
        return gitStatus;
    }

    static {
        GitStatus gitStatus;
        GitStatus gitStatus2;
        GitStatus gitStatus3;
        GitStatus gitStatus4;
        GitStatus gitStatus5;
        GitStatus gitStatus6;
        ADDED = gitStatus6 = GitStatus.$INIT("ADDED", 0);
        MODIFIED = gitStatus5 = GitStatus.$INIT("MODIFIED", 1);
        REMOVED = gitStatus4 = GitStatus.$INIT("REMOVED", 2);
        UNTRACKED = gitStatus3 = GitStatus.$INIT("UNTRACKED", 3);
        MIN_VALUE = gitStatus2 = ADDED;
        MAX_VALUE = gitStatus = UNTRACKED;
        GitStatus[] gitStatusArray = new GitStatus[]{ADDED, MODIFIED, REMOVED, UNTRACKED};
        $VALUES = gitStatusArray;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GitStatus.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

