/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeSubscriber;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.utils.Logger;

public class DynamicTreeBuilder
extends Node
implements NodeSubscriber {
    private DefaultTreeModel treeModel;
    private final DefaultMutableTreeNode parent;
    public short state = 0;
    public static final short IDLE = 0;
    public static final short LOADING = 1;
    public static final short PARTIAL = 2;
    public static final short FINISHED = 3;
    private final DefaultMutableTreeNode loading;
    private static ImageIcon loadIcon = ImageLoader.findImage("loading.gif");
    private static ImageIcon pauseIcon = ImageLoader.findImage("reload.gif");

    public DynamicTreeBuilder(DefaultMutableTreeNode parent, ItemTabManager desktop) {
        super(desktop);
        this.parent = parent;
        this.loading = new DefaultMutableTreeNode(this);
    }

    public void buildInfo(JTree parentTree) {
        this.treeModel = (DefaultTreeModel)parentTree.getModel();
    }

    public void start() {
        Node parentNode = (Node)this.parent.getUserObject();
        Logger.msg((int)2, (String)("DynamicTreeBuilder.start() - Filling in children of '" + parentNode.toString() + "'"));
        if (this.state == 0) {
            parentNode.subscribeNode(this);
        } else {
            parentNode.loadMore();
        }
        this.state = 1;
    }

    @Override
    public String toString() {
        switch (this.state) {
            case 0: {
                return "Initializing Tree Node Loader";
            }
            case 1: {
                return "Loading . . .";
            }
            case 2: {
                return "Double-click to load more";
            }
            case 3: {
                return "Done";
            }
        }
        return "";
    }

    @Override
    public ImageIcon getIcon() {
        if (this.state == 1) {
            return loadIcon;
        }
        return pauseIcon;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.loading;
    }

    @Override
    public void add(Node newNode) {
        Logger.msg((int)2, (String)("DynamicTreeBuilder.add() - Received item for tree. Name: " + newNode));
        SwingUtilities.invokeLater(new TreeAddThread(newNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(boolean more) {
        if (more) {
            this.state = (short)2;
        } else {
            this.state = (short)3;
            DefaultTreeModel defaultTreeModel = this.treeModel;
            synchronized (defaultTreeModel) {
                if (this.loading.getParent() != null) {
                    SwingUtilities.invokeLater(new TreeRemoveThread(this.loading));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Path path) {
        DefaultTreeModel defaultTreeModel = this.treeModel;
        synchronized (defaultTreeModel) {
            for (int i = 0; i < this.parent.getChildCount(); ++i) {
                Node childNode;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.treeModel.getChild(this.parent, i);
                if (!(child.getUserObject() instanceof Node) || !(childNode = (Node)child.getUserObject()).getPath().equals((Object)path)) continue;
                SwingUtilities.invokeLater(new TreeRemoveThread(child));
                return;
            }
        }
    }

    @Override
    public void loadChildren() {
    }

    class TreeRemoveThread
    implements Runnable {
        DefaultMutableTreeNode oldNode;

        TreeRemoveThread(DefaultMutableTreeNode oldNode) {
            this.oldNode = oldNode;
        }

        @Override
        public void run() {
            DynamicTreeBuilder.this.treeModel.removeNodeFromParent(this.oldNode);
        }
    }

    class TreeAddThread
    implements Runnable {
        Node newNode;

        TreeAddThread(Node newNode) {
            this.newNode = newNode;
        }

        @Override
        public void run() {
            boolean inserted = false;
            DefaultMutableTreeNode newTreeNode = this.newNode.getTreeNode();
            for (int i = 0; i < DynamicTreeBuilder.this.parent.getChildCount() && !inserted; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)DynamicTreeBuilder.this.treeModel.getChild(DynamicTreeBuilder.this.parent, i);
                if (child == DynamicTreeBuilder.this.loading) continue;
                Node childNode = (Node)child.getUserObject();
                if (childNode.getName().equals(this.newNode.getName())) {
                    inserted = true;
                    break;
                }
                if (childNode.getName().compareTo(this.newNode.getName()) < 0) continue;
                DynamicTreeBuilder.this.treeModel.insertNodeInto(newTreeNode, DynamicTreeBuilder.this.parent, i);
                inserted = true;
                break;
            }
            if (!inserted) {
                DynamicTreeBuilder.this.treeModel.insertNodeInto(newTreeNode, DynamicTreeBuilder.this.parent, DynamicTreeBuilder.this.parent.getChildCount());
            }
        }
    }
}

