/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.cristalise.gui.ItemDetails;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.MenuBuilder;
import org.cristalise.gui.tabs.JTabbedPaneWithCloseIcons;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.utils.Logger;

public class ItemTabManager
extends JPanel {
    protected HashMap<ItemPath, ItemDetails> openItems = new HashMap();
    protected JTabbedPaneWithCloseIcons tabbedPane = new JTabbedPaneWithCloseIcons();
    MenuBuilder myMenuBuilder;

    public ItemTabManager() {
        this.setLayout(new GridLayout(1, 1));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.tabbedPane);
    }

    public ItemDetails add(NodeItem thisItem) {
        ItemDetails requestedDetails;
        if (!this.openItems.containsKey(thisItem.getItemPath())) {
            MainFrame.progress.startBouncing("Opening " + thisItem.getName() + ". Please wait.");
            Logger.msg((int)1, (String)("ItemWindowManager.add() - Window for syskey " + thisItem.getItemPath() + " not found. Opening new one."));
            requestedDetails = new ItemDetails(thisItem);
            Thread itemLoader = new Thread(requestedDetails);
            itemLoader.start();
            this.openItems.put(thisItem.getItemPath(), requestedDetails);
            requestedDetails.setDesktopManager(this);
            this.tabbedPane.addTab(thisItem.getName(), thisItem.getIcon(), requestedDetails, thisItem.getType());
        } else {
            requestedDetails = this.openItems.get(thisItem.getItemPath());
        }
        this.tabbedPane.setSelectedComponent(requestedDetails);
        return requestedDetails;
    }

    public void setMenuBuilder(MenuBuilder myMenuBuilder) {
        this.myMenuBuilder = myMenuBuilder;
    }

    public void remove(ItemPath itemPath) {
        if (!this.openItems.containsKey(itemPath)) {
            return;
        }
        ItemDetails tabToClose = this.openItems.get(itemPath);
        this.tabbedPane.remove(tabToClose);
        tabToClose.discardTabs();
        this.openItems.remove(itemPath);
    }

    public void closeAll(boolean keepOpen) {
        ArrayList<ItemPath> toRemove = new ArrayList<ItemPath>();
        for (ItemPath element : this.openItems.keySet()) {
            if (keepOpen && this.openItems.get(element).equals(this.tabbedPane.getSelectedComponent())) continue;
            toRemove.add(element);
        }
        for (ItemPath element : toRemove) {
            this.remove(element);
        }
    }
}

