/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.cristalise.gui.DomainKeyConsumer;
import org.cristalise.gui.DynamicTreeBuilder;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.gui.tree.NodeTransferHandler;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.utils.Logger;

public class TreeBrowser
extends JPanel
implements DomainKeyConsumer {
    private ItemTabManager desktop;
    protected JTree tree;
    private Node userRoot;

    public TreeBrowser(ItemTabManager target, Node userRoot) {
        this.setLayout(new BorderLayout());
        this.desktop = target;
        this.userRoot = userRoot;
        this.setPreferredSize(new Dimension(300, 500));
        this.tree = new JTree(new DefaultTreeModel(userRoot.getTreeNode()));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(3);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                TreePath p = e.getPath();
                DefaultMutableTreeNode nodeClicked = (DefaultMutableTreeNode)p.getLastPathComponent();
                DefaultMutableTreeNode loadNode = (DefaultMutableTreeNode)nodeClicked.getFirstChild();
                if (loadNode.getUserObject() instanceof DynamicTreeBuilder) {
                    DynamicTreeBuilder loading = (DynamicTreeBuilder)loadNode.getUserObject();
                    if (loading.state == 0) {
                        loading.buildInfo(TreeBrowser.this.tree);
                        loading.start();
                    }
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new ItemRenderer());
        this.tree.addMouseListener(new TreeMouseListener());
        this.tree.setDragEnabled(true);
        this.tree.setDropMode(DropMode.ON);
        this.tree.setTransferHandler(new NodeTransferHandler(this));
        JScrollPane myScrollPane = new JScrollPane(this.tree);
        this.add(myScrollPane);
        DefaultMutableTreeNode loadNode = (DefaultMutableTreeNode)userRoot.getTreeNode().getFirstChild();
        DynamicTreeBuilder loading = (DynamicTreeBuilder)loadNode.getUserObject();
        loading.buildInfo(this.tree);
        loading.start();
    }

    @Override
    public void push(DomainPath target) {
        String[] components = target.getPath();
        Node currentNode = this.userRoot;
        Object[] treePath = new Object[components.length + 1];
        treePath[0] = currentNode.getTreeNode();
        for (int i = 0; i < components.length; ++i) {
            String[] newPath = new String[i + 1];
            for (int j = 0; j < newPath.length; ++j) {
                newPath[j] = components[j];
            }
            DomainPath nextNodePath = new DomainPath(newPath);
            Node nextNode = currentNode.getChildNode((Path)nextNodePath);
            if (nextNode == null) {
                Logger.msg((int)6, (String)("TreeBrowser.push() - creating " + nextNodePath));
                nextNode = currentNode.newNode((Path)nextNodePath);
                currentNode.add(nextNode);
                DynamicTreeBuilder builder = currentNode.getTreeBuilder();
                builder.buildInfo(this.tree);
                builder.add(nextNode);
            }
            treePath[i + 1] = nextNode.getTreeNode();
            currentNode = nextNode;
        }
        TreePath targetNode = new TreePath(treePath);
        if (Logger.doLog((int)5)) {
            TreeBrowser.dumpPath(targetNode, 5);
        }
        this.tree.clearSelection();
        this.tree.addSelectionPath(targetNode);
        this.tree.makeVisible(targetNode);
        if (currentNode instanceof NodeItem) {
            this.desktop.add((NodeItem)currentNode);
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void push(String name) {
        JOptionPane.showMessageDialog(null, "'" + name + "' was not found.", "No results", 1);
    }

    public Node getSelectedNode() {
        Object selObj = this.tree.getLastSelectedPathComponent();
        if (selObj != null) {
            try {
                DefaultMutableTreeNode nodeClicked = (DefaultMutableTreeNode)selObj;
                Object userObject = nodeClicked.getUserObject();
                if (userObject instanceof Node) {
                    return (Node)userObject;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Node getNodeAt(Point p) {
        TreePath selPath = this.tree.getPathForLocation(p.x, p.y);
        if (selPath != null) {
            try {
                DefaultMutableTreeNode nodeClicked = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                Object userObject = nodeClicked.getUserObject();
                if (userObject instanceof Node) {
                    return (Node)userObject;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void dumpPath(TreePath selPath, int logLevel) {
        if (selPath == null) {
            Logger.msg((int)logLevel, (String)"TreeBrowser.dumpPath() - selPath null");
            return;
        }
        for (int i = 0; i < selPath.getPath().length; ++i) {
            Logger.msg((int)logLevel, (String)("TreeBrowser.dumpPath() - selPath " + i + " = " + selPath.getPath()[i]));
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            } else {
                Node source = TreeBrowser.this.getNodeAt(e.getPoint());
                if (source == null) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    if (source instanceof NodeItem) {
                        NodeItem thisNode = (NodeItem)source;
                        TreeBrowser.this.desktop.add(thisNode);
                    }
                    if (source instanceof DynamicTreeBuilder) {
                        DynamicTreeBuilder thisLoader = (DynamicTreeBuilder)source;
                        if (thisLoader.state == 2) {
                            thisLoader.start();
                        }
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            Node source = TreeBrowser.this.getNodeAt(e.getPoint());
            if (source == null) {
                return;
            }
            if (source instanceof Node) {
                Node thisNode = source;
                thisNode.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class ItemRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object thisLeaf = ((DefaultMutableTreeNode)value).getUserObject();
            if (thisLeaf instanceof DynamicTreeBuilder) {
                DynamicTreeBuilder thisLoader = (DynamicTreeBuilder)thisLeaf;
                ImageIcon loadGif = thisLoader.getIcon();
                this.setIcon(loadGif);
                loadGif.setImageObserver(tree);
                this.setToolTipText("Tree Content Loader");
            } else if (thisLeaf instanceof Node) {
                Node thisNode = (Node)thisLeaf;
                if (thisNode.getIcon() != null) {
                    this.setIcon(thisNode.getIcon());
                }
                this.setToolTipText(thisNode.getToolTip());
            }
            return this;
        }
    }
}

