/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.graph.controller.DeletionController;
import org.cristalise.gui.graph.controller.StartVertexController;
import org.cristalise.gui.graph.view.EditorModeListener;
import org.cristalise.gui.graph.view.GraphPanel;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.utils.Logger;

public class EditorToolBar
extends Box
implements Printable {
    protected boolean mEdgeCreationMode = false;
    protected GraphPanel mGraphPanel = null;
    protected JComboBox<TypeNameAndConstructionInfo> mVertexTypeBox = new JComboBox();
    protected JComboBox<TypeNameAndConstructionInfo> mEdgeTypeBox = new JComboBox();
    protected ButtonGroup mModeButtonGroup = new ButtonGroup();
    protected JToggleButton mVertexModeButton = new JToggleButton(ImageLoader.findImage("graph/newvertex.png"));
    protected JToggleButton mSelectModeButton = new JToggleButton(ImageLoader.findImage("graph/selection.gif"));
    protected JToggleButton mEdgeModeButton = new JToggleButton(ImageLoader.findImage("graph/edge.png"));
    protected JButton[] mOtherButtons = null;
    protected JButton mStartButton = new JButton(ImageLoader.findImage("graph/start.png"));
    protected JButton mDeleteButton = new JButton(ImageLoader.findImage("graph/delete.png"));
    protected JButton mPrintButton = new JButton(ImageLoader.findImage("graph/print.png"));
    protected JButton mCopyButton = new JButton(ImageLoader.findImage("graph/copy.png"));
    protected StartVertexController mStartVertexController = new StartVertexController();
    protected DeletionController mDeletionController = new DeletionController();
    protected Vector<EditorModeListener> mListenerVector = new Vector(10, 10);

    public EditorToolBar(boolean edgeCreationMode, JButton[] otherButtons, GraphPanel graphP) {
        super(0);
        this.mGraphPanel = graphP;
        this.mEdgeCreationMode = edgeCreationMode;
        this.mOtherButtons = otherButtons;
        this.prepareModeButtons();
        this.mStartVertexController.setStartButton(this.mStartButton);
        this.mDeletionController.setDeleteButton(this.mDeleteButton);
        this.createLayout();
        this.createListeners();
    }

    protected void prepareModeButtons() {
        this.mVertexModeButton.setToolTipText("Create vertex");
        this.mSelectModeButton.setToolTipText("Multi-select and drag");
        this.mEdgeModeButton.setToolTipText("Create edge");
        this.mStartButton.setToolTipText("Select the start vertex of the graph");
        this.mDeleteButton.setToolTipText("Delete the selection");
        this.mPrintButton.setToolTipText("Print this graph");
        this.mCopyButton.setToolTipText("Copy an image of this graph to the clipboard");
        this.mVertexModeButton.setMargin(new Insets(0, 0, 0, 0));
        this.mSelectModeButton.setMargin(new Insets(0, 0, 0, 0));
        this.mEdgeModeButton.setMargin(new Insets(0, 0, 0, 0));
        this.mSelectModeButton.setSelected(true);
        this.mModeButtonGroup.add(this.mVertexModeButton);
        this.mModeButtonGroup.add(this.mSelectModeButton);
        this.mModeButtonGroup.add(this.mEdgeModeButton);
        this.mVertexModeButton.addActionListener(new ModeButtonListener("Vertex"));
        this.mSelectModeButton.addActionListener(new ModeButtonListener("Select"));
        this.mEdgeModeButton.addActionListener(new ModeButtonListener("Edge"));
    }

    public void enterSelectMode() {
        this.mSelectModeButton.setSelected(true);
        this.notifyListeners("Select");
    }

    public void updateVertexTypes(TypeNameAndConstructionInfo[] typeNameAndConstructionInfo) {
        int i = 0;
        this.mVertexTypeBox.removeAllItems();
        for (i = 0; i < typeNameAndConstructionInfo.length; ++i) {
            this.mVertexTypeBox.addItem(typeNameAndConstructionInfo[i]);
        }
    }

    public void updateEdgeTypes(TypeNameAndConstructionInfo[] typeNameAndConstructionInfo) {
        int i = 0;
        this.mEdgeTypeBox.removeAllItems();
        for (i = 0; i < typeNameAndConstructionInfo.length; ++i) {
            this.mEdgeTypeBox.addItem(typeNameAndConstructionInfo[i]);
        }
    }

    public TypeNameAndConstructionInfo getSelectedVertexType() {
        return (TypeNameAndConstructionInfo)this.mVertexTypeBox.getSelectedItem();
    }

    public TypeNameAndConstructionInfo getSelectedEdgeType() {
        return (TypeNameAndConstructionInfo)this.mEdgeTypeBox.getSelectedItem();
    }

    protected void createLayout() {
        int i = 0;
        this.add(this.mSelectModeButton);
        this.add(this.mVertexModeButton);
        this.add(this.mVertexTypeBox);
        this.add(Box.createHorizontalStrut(10));
        if (this.mEdgeCreationMode) {
            this.add(this.mEdgeModeButton);
            this.add(this.mEdgeTypeBox);
        }
        this.add(Box.createGlue());
        this.mPrintButton.setEnabled(true);
        this.mPrintButton.setMargin(new Insets(0, 0, 0, 0));
        this.add(this.mPrintButton);
        this.mCopyButton.setEnabled(true);
        this.mCopyButton.setMargin(new Insets(0, 0, 0, 0));
        this.add(this.mCopyButton);
        this.mStartButton.setEnabled(false);
        this.mStartButton.setMargin(new Insets(0, 0, 0, 0));
        this.mDeleteButton.setEnabled(false);
        this.mDeleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.add(this.mDeleteButton);
        this.add(Box.createRigidArea(new Dimension(20, 0)));
        this.add(this.mStartButton);
        if (this.mOtherButtons != null) {
            for (i = 0; i < this.mOtherButtons.length; ++i) {
                this.mOtherButtons[i].setMargin(new Insets(0, 0, 0, 0));
                this.add(this.mOtherButtons[i]);
            }
        }
    }

    protected void createListeners() {
        this.mVertexTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EditorToolBar.this.mVertexModeButton.setSelected(true);
                EditorToolBar.this.notifyListeners("Vertex");
            }
        });
        this.mEdgeTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EditorToolBar.this.mEdgeModeButton.setSelected(true);
                EditorToolBar.this.notifyListeners("Edge");
            }
        });
        this.mPrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PrinterJob _monJob = PrinterJob.getPrinterJob();
                if (_monJob.printDialog()) {
                    _monJob.setPrintable(EditorToolBar.this.self());
                }
                try {
                    _monJob.print();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        try {
            Class.forName("java.awt.datatransfer.DataFlavor").getDeclaredField("imageFlavor");
            this.mCopyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        Image i = EditorToolBar.this.createImage(EditorToolBar.this.mGraphPanel.getWidth(), EditorToolBar.this.mGraphPanel.getHeight());
                        Graphics g = i.getGraphics();
                        EditorToolBar.this.mGraphPanel.paintComponent(g);
                        ImageTransferable it = new ImageTransferable(i, EditorToolBar.this.mGraphPanel.getWidth(), EditorToolBar.this.mGraphPanel.getHeight());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(it, it);
                    }
                    catch (Exception e) {
                        Logger.error((Throwable)e);
                    }
                }
            });
        }
        catch (Exception ex) {
            this.mCopyButton.setEnabled(false);
        }
    }

    protected void notifyListeners(String newModeId) {
        int i = 0;
        EditorModeListener listener = null;
        for (i = 0; i < this.mListenerVector.size(); ++i) {
            listener = this.mListenerVector.elementAt(i);
            listener.editorModeChanged(newModeId);
        }
    }

    public void setGraphModelManager(GraphModelManager graphModelManager) {
        this.mStartVertexController.setGraphModelManager(graphModelManager);
        this.mDeletionController.setGraphModelManager(graphModelManager);
    }

    public void setGraphPanel(GraphPanel graphPanel) {
        graphPanel.addKeyListener(this.mDeletionController);
        this.mDeletionController.setGraphPanel(graphPanel);
    }

    public void addEditorModeListener(EditorModeListener listener) {
        this.mListenerVector.add(listener);
    }

    public void removeEditorModeListener(EditorModeListener listener) {
        this.mListenerVector.remove(listener);
    }

    public void setGraphEditable(boolean editable) {
        this.mVertexModeButton.setEnabled(editable);
        this.mEdgeModeButton.setEnabled(editable);
    }

    public EditorToolBar self() {
        return this;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int i) throws PrinterException {
        if (i >= 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double scalex = pf.getImageableWidth() / (double)this.mGraphPanel.getWidth();
        double scaley = pf.getImageableHeight() / (double)this.mGraphPanel.getHeight();
        double scale = Math.min(Math.min(scalex, scaley), 1.0);
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        g2d.scale(scale, scale);
        this.mGraphPanel.printComponent(g2d);
        return 0;
    }

    protected class ImageTransferable
    implements Transferable,
    ClipboardOwner {
        Image image;
        int width;
        int height;
        DataFlavor javaImg;

        public ImageTransferable(Image image, int width, int height) {
            this.image = image;
            this.width = width;
            this.height = height;
            try {
                this.javaImg = new DataFlavor("image/x-java-image; class=java.awt.Image", "AWT Image");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor) || this.image == null) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            boolean result = this.in(flavor, this.getTransferDataFlavors());
            return result;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.javaImg};
        }

        protected boolean in(DataFlavor flavor, DataFlavor[] flavors) {
            int f;
            for (f = 0; f < flavors.length && !flavor.equals(flavors[f]); ++f) {
            }
            return f < flavors.length;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            this.image = null;
        }
    }

    protected class ModeButtonListener
    implements ActionListener {
        protected String mModeId = null;

        public ModeButtonListener(String modeId) {
            this.mModeId = modeId;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            EditorToolBar.this.notifyListeners(this.mModeId);
        }
    }
}

