/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.cristalise.kernel.utils.CastorHashMap;

public class PropertyTableModel
extends AbstractTableModel {
    private String[] mColumnNames = new String[]{"Name", "Value"};
    private String[] mColumnNameswAbstract = new String[]{"Name", "Value", "Abstract"};
    public CastorHashMap sourceMap = new CastorHashMap();
    public ArrayList<String> sortedNameList = new ArrayList();
    boolean isEditable = false;

    public PropertyTableModel(boolean useAbstract) {
        if (useAbstract) {
            this.mColumnNames = this.mColumnNameswAbstract;
        }
    }

    @Override
    public int getColumnCount() {
        return this.mColumnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.mColumnNames[col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        CastorHashMap castorHashMap = this.sourceMap;
        synchronized (castorHashMap) {
            return this.sourceMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        CastorHashMap castorHashMap = this.sourceMap;
        synchronized (castorHashMap) {
            String rowName = this.sortedNameList.get(rowIndex);
            switch (colIndex) {
                case 0: {
                    return rowName;
                }
                case 1: {
                    return this.sourceMap.get((Object)rowName);
                }
                case 2: {
                    return this.sourceMap.getAbstract().contains(rowName);
                }
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
        CastorHashMap castorHashMap = this.sourceMap;
        synchronized (castorHashMap) {
            if (colIndex == 0) {
                return;
            }
            String rowName = this.sortedNameList.get(rowIndex);
            if (colIndex == 1) {
                Class<?> oldElement = this.sourceMap.get((Object)rowName).getClass();
                if (oldElement == Double.class && value.getClass() == String.class) {
                    try {
                        value = Double.valueOf((String)value);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (oldElement == Integer.class && value.getClass() == String.class) {
                    try {
                        value = Integer.valueOf((String)value);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (value.getClass() != oldElement) {
                    JOptionPane.showMessageDialog(null, "This property should contain a " + oldElement.getName() + " not a " + value.getClass().getName(), "Incorrect datatype", 0);
                } else {
                    this.sourceMap.put((Object)rowName, value);
                }
            } else if (colIndex == 2) {
                Boolean boolVal = (Boolean)value;
                if (boolVal.booleanValue()) {
                    this.sourceMap.getAbstract().add(rowName);
                } else {
                    this.sourceMap.getAbstract().remove(rowName);
                }
            }
        }
        this.fireTableCellUpdated(rowIndex, colIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMap(CastorHashMap props) {
        CastorHashMap castorHashMap = this.sourceMap;
        synchronized (castorHashMap) {
            this.sourceMap = props;
            this.sortedNameList = new ArrayList(props.size());
            for (String string : props.keySet()) {
                this.sortedNameList.add(string);
            }
            Collections.sort(this.sortedNameList, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 0 && this.isEditable;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public void addProperty(String text, Object object, boolean isAbstract) {
        this.sourceMap.put(text, object, isAbstract);
        this.setMap(this.sourceMap);
    }

    public void delProperty(Object propName) {
        this.sourceMap.remove(propName);
        this.setMap(this.sourceMap);
    }
}

