/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.chooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.lifecycle.chooser.LDAPFileChooser;
import org.cristalise.gui.lifecycle.chooser.WorkflowDialogue;
import org.cristalise.kernel.utils.Logger;

public class ActivityChooser
extends JFrame {
    private LDAPFileChooser mLDAPFileChooserActivity = null;
    private JButton mButtonOK = null;
    private JButton mButtonCancel = null;
    private JPanel mJPanelVertical = null;
    private JPanel mJPanelHorizontal = null;
    private WorkflowDialogue mParent = null;
    private JLabel label = null;
    HashMap<String, Object> mhashmap = null;

    public ActivityChooser(String type, Image img, WorkflowDialogue parent, HashMap<String, Object> hashmap) {
        super("Select " + type + " activity definition");
        this.setDefaultCloseOperation(2);
        img = ImageLoader.findImage("graph/newvertex_large.png").getImage();
        this.setIconImage(img);
        this.mParent = parent;
        this.mhashmap = hashmap;
        this.initialize(type);
    }

    private JButton getJButtonOK() {
        if (this.mButtonOK == null) {
            this.mButtonOK = new JButton("OK");
        }
        return this.mButtonOK;
    }

    private JButton getJButtonCancel() {
        if (this.mButtonCancel == null) {
            this.mButtonCancel = new JButton("Cancel");
        }
        return this.mButtonCancel;
    }

    private LDAPFileChooser getLDAPFileChooserActivity(String type) {
        if (this.mLDAPFileChooserActivity == null) {
            try {
                this.mLDAPFileChooserActivity = new LDAPFileChooser(type);
                this.mLDAPFileChooserActivity.setName("LDAPFileChooserRouting");
            }
            catch (Exception mExc) {
                Logger.error((Throwable)mExc);
            }
        }
        return this.mLDAPFileChooserActivity;
    }

    private void initialize(String type) {
        this.getJButtonOK().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Logger.debug((int)5, (String)("mLDAPFileChooserActivity.getEntryName()" + ActivityChooser.this.mLDAPFileChooserActivity.getEntryName()));
                ActivityChooser.this.setCursor(new Cursor(3));
                try {
                    ActivityChooser.this.mParent.loadThisWorkflow(ActivityChooser.this.mLDAPFileChooserActivity.getEntryName(), ActivityChooser.this.mLDAPFileChooserActivity.getEntryVersion(), ActivityChooser.this.mhashmap);
                }
                catch (Exception ex) {
                    Logger.error((Throwable)ex);
                    MainFrame.exceptionDialog(ex);
                }
                ActivityChooser.this.setCursor(new Cursor(0));
                ActivityChooser.this.close();
            }
        });
        this.getJButtonCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityChooser.this.close();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.getJPanelVertical(type));
        contentPane.add(this.getJPanelHorizontal());
        contentPane.add(Box.createGlue());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        this.setResizable(true);
        this.pack();
        this.setSize(new Dimension(this.getWidth(), this.getJButtonCancel().getHeight() + this.getLDAPFileChooserActivity(type).getHeight() + this.label.getHeight() + 100));
        this.setVisible(true);
    }

    private void close() {
        this.mParent = null;
        this.setEnabled(false);
        this.setVisible(false);
    }

    private JPanel getJPanelVertical(String type) {
        if (this.mJPanelVertical == null) {
            try {
                Logger.debug((int)8, (String)"Panel button");
                this.mJPanelVertical = new JPanel();
                this.mJPanelVertical.setName("JPanelV");
                this.mJPanelVertical.setLayout(new BoxLayout(this.mJPanelVertical, 1));
                this.label = new JLabel("Select item, then numeric version");
                JPanel labelP = new JPanel();
                labelP.setLayout(new BoxLayout(labelP, 0));
                labelP.add(this.label);
                labelP.add(Box.createGlue());
                this.mJPanelVertical.add(labelP);
                this.mJPanelVertical.add(Box.createRigidArea(new Dimension(0, 5)));
                this.mJPanelVertical.add(this.getLDAPFileChooserActivity(type));
                this.mJPanelVertical.add(Box.createGlue());
                this.mJPanelVertical.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                this.mJPanelVertical.setVisible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.mJPanelVertical;
    }

    private JPanel getJPanelHorizontal() {
        if (this.mJPanelHorizontal == null) {
            try {
                Logger.debug((int)8, (String)"Panel button");
                this.mJPanelHorizontal = new JPanel();
                this.mJPanelHorizontal.setName("JPanelH");
                this.mJPanelHorizontal.setLayout(new BoxLayout(this.mJPanelHorizontal, 0));
                this.mJPanelHorizontal.add((Component)this.getJButtonOK(), this.getJButtonOK().getName());
                this.mJPanelHorizontal.add(Box.createRigidArea(new Dimension(10, 0)));
                this.mJPanelHorizontal.add((Component)this.getJButtonCancel(), this.getJButtonCancel().getName());
                this.mJPanelHorizontal.setVisible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.mJPanelHorizontal;
    }
}

