/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.chooser;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import org.cristalise.gui.MainFrame;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;

public class LDAPEntryChooser
extends JComboBox<String> {
    ArrayList<Property> props;
    ArrayList<String> allItems = new ArrayList();
    HashMap<String, ItemPath> itemPaths = new HashMap();

    public LDAPEntryChooser(ArrayList<Property> props) {
        this.props = props;
        this.initialise();
    }

    private void initialise() {
        try {
            Iterator children = Gateway.getLookup().search((Path)new DomainPath(""), this.props.toArray(new Property[this.props.size()]));
            while (children.hasNext()) {
                ItemPath path = (ItemPath)children.next();
                Property prop = (Property)Gateway.getStorage().get(path, "Property/Name", null);
                this.allItems.add(prop.getValue());
                this.itemPaths.put(prop.getValue(), path);
            }
        }
        catch (Exception ex) {
            MainFrame.exceptionDialog(ex);
        }
        Collections.sort(this.allItems);
        this.addItem("");
        for (String element : this.allItems) {
            this.addItem(element);
        }
    }

    public ItemPath getItem(String name) {
        return this.itemPaths.get(name);
    }

    public void reload() {
        this.removeAllItems();
        this.initialise();
    }

    @Override
    public synchronized Dimension getSize() {
        if (Gateway.getProperties().getInt("ResizeCombo") > 0) {
            return new Dimension(super.getSize().width < 400 ? 400 : super.getSize().width, super.getSize().height);
        }
        return super.getSize();
    }
}

