/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.desc;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.ArrayList;
import org.cristalise.gui.graph.view.VertexRenderer;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.ActivitySlotDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;

public class ActivityDefRenderer
implements VertexRenderer {
    private Paint mInactivePaint = new Color(255, 255, 255);
    private Paint mErrorPaint = new Color(255, 50, 0);
    private Paint mCompositePaint = new Color(200, 200, 255);
    private Paint mTextPaint = Color.black;

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        WfVertexDef activityDef = (WfVertexDef)vertex;
        boolean hasError = activityDef.verify();
        GraphPoint centrePoint = activityDef.getCentrePoint();
        int vertexHeight = activityDef.getHeight();
        int vertexWidth = activityDef.getWidth();
        ArrayList<String> linesOfText = new ArrayList<String>();
        FontMetrics metrics = g2d.getFontMetrics();
        int lineHeight = metrics.getHeight();
        int x = 0;
        int y = 0;
        int i = 0;
        if (activityDef instanceof ActivitySlotDef) {
            try {
                linesOfText.add((String)activityDef.getProperties().get((Object)"Name"));
                linesOfText.add("(" + ((ActivitySlotDef)activityDef).getTheActivityDef().getActName() + ")");
            }
            catch (Exception e) {
                linesOfText.add("(Not found)");
            }
        } else {
            linesOfText.add(activityDef.getName());
        }
        if (!hasError) {
            linesOfText.add(activityDef.getErrors());
        }
        g2d.setPaint(!hasError ? this.mErrorPaint : (activityDef.getIsComposite() ? this.mCompositePaint : this.mInactivePaint));
        g2d.fill3DRect(centrePoint.x - vertexWidth / 2, centrePoint.y - vertexHeight / 2, vertexWidth, vertexHeight, true);
        g2d.setPaint(this.mTextPaint);
        int linesHeight = lineHeight * linesOfText.size();
        int linesStartY = centrePoint.y - linesHeight / 2 + lineHeight * 2 / 3;
        for (String line : linesOfText) {
            if (line == null) {
                line = "";
            }
            int lineWidth = metrics.stringWidth(line);
            x = centrePoint.x - lineWidth / 2;
            y = linesStartY + i++ * lineHeight;
            g2d.drawString(line, x, y);
        }
    }
}

