/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.desc;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.graph.view.EditorPanel;
import org.cristalise.gui.graph.view.VertexPropertyPanel;
import org.cristalise.gui.lifecycle.desc.WfDefGraphPanel;
import org.cristalise.gui.lifecycle.desc.WfDirectedEdgeDefRenderer;
import org.cristalise.gui.lifecycle.desc.WfEdgeDefFactory;
import org.cristalise.gui.lifecycle.desc.WfVertexDefFactory;
import org.cristalise.gui.lifecycle.desc.WfVertexDefRenderer;
import org.cristalise.gui.lifecycle.instance.FindActDefPanel;
import org.cristalise.gui.tabs.outcome.InvalidOutcomeException;
import org.cristalise.gui.tabs.outcome.InvalidSchemaException;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.OutcomeHandler;
import org.cristalise.gui.tabs.outcome.OutcomeNotInitialisedException;
import org.cristalise.kernel.graph.layout.DefaultGraphLayoutGenerator;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.VertexOutlineCreator;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.WfVertexDefOutlineCreator;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class CompActDefOutcomeHandler
extends JPanel
implements OutcomeHandler {
    protected JButton mLoadButton = new JButton(ImageLoader.findImage("graph/load.png"));
    protected JButton mLayoutButton = new JButton(ImageLoader.findImage("graph/autolayout.png"));
    protected JButton mZoomOutButton = new JButton(ImageLoader.findImage("graph/zoomout.png"));
    protected JButton[] mOtherToolBarButtons = new JButton[]{this.mZoomOutButton, this.mLayoutButton, this.mLoadButton};
    protected CompositeActivityDef mCompActDef = null;
    protected WfEdgeDefFactory mWfEdgeDefFactory = new WfEdgeDefFactory();
    protected WfVertexDefFactory mWfVertexDefFactory = new WfVertexDefFactory();
    protected EditorPanel mEditorPanel;
    protected VertexPropertyPanel mPropertyPanel = this.loadPropertyPanel();
    protected JSplitPane mSplitPane;
    boolean unsaved;

    public CompActDefOutcomeHandler() {
        this.mPropertyPanel.createLayout(new FindActDefPanel());
        this.mEditorPanel = new EditorPanel(this.mWfEdgeDefFactory, this.mWfVertexDefFactory, (VertexOutlineCreator)new WfVertexDefOutlineCreator(), true, this.mOtherToolBarButtons, new WfDefGraphPanel(new WfDirectedEdgeDefRenderer(), new WfVertexDefRenderer()));
    }

    protected void createLayout() {
        this.mLoadButton.setToolTipText("Load from local file");
        this.mLayoutButton.setToolTipText("Auto-Layout");
        this.mZoomOutButton.setToolTipText("Zoom Out");
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weighty = 2.0;
        c.weightx = 2.0;
        this.mSplitPane = new JSplitPane(1, this.mEditorPanel, this.mPropertyPanel);
        this.mSplitPane.setDividerSize(5);
        if (this.mCompActDef != null) {
            int minWidth = this.mCompActDef.getChildrenGraphModel().getWidth() + 20;
            int editWidth = (int)this.mEditorPanel.getPreferredSize().getWidth();
            if (editWidth > minWidth) {
                minWidth = editWidth;
            }
            if (this.mSplitPane.getDividerLocation() < minWidth) {
                this.mSplitPane.setDividerLocation(minWidth);
            }
        }
        gridbag.setConstraints(this.mSplitPane, c);
        this.add(this.mSplitPane);
        this.revalidate();
    }

    protected void createListeners() {
        this.mLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                File selectedFile = null;
                int returnValue = MainFrame.xmlChooser.showOpenDialog(null);
                switch (returnValue) {
                    case 0: {
                        selectedFile = MainFrame.xmlChooser.getSelectedFile();
                        try {
                            String newWf = FileStringUtility.file2String((File)selectedFile);
                            CompActDefOutcomeHandler.this.setOutcome(newWf);
                            CompActDefOutcomeHandler.this.setUpGraphEditor();
                            break;
                        }
                        catch (Exception e) {
                            MainFrame.exceptionDialog(e);
                        }
                    }
                }
            }
        });
        this.mLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultGraphLayoutGenerator.layoutGraph((GraphModel)CompActDefOutcomeHandler.this.mEditorPanel.mGraphModelManager.getModel());
            }
        });
        this.mZoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CompActDefOutcomeHandler.this.mEditorPanel.mGraphModelManager.zoomOut();
            }
        });
    }

    public void setUpGraphEditor() {
        this.mEditorPanel.mGraphModelManager.setModel(this.mCompActDef.getChildrenGraphModel());
        this.mEditorPanel.updateVertexTypes(this.mCompActDef.getVertexTypeNameAndConstructionInfo());
        this.mEditorPanel.updateEdgeTypes(this.mCompActDef.getEdgeTypeNameAndConstructionInfo());
        this.mEditorPanel.enterSelectMode();
        this.mWfVertexDefFactory.setCreationContext(this.mCompActDef);
    }

    @Override
    public void setOutcome(String outcome) throws InvalidOutcomeException {
        try {
            CompositeActivityDef newAct = (CompositeActivityDef)Gateway.getMarshaller().unmarshall(outcome);
            if (this.mCompActDef != null) {
                newAct.setName(this.mCompActDef.getName());
            }
            this.mCompActDef = newAct;
            if (this.mSplitPane != null) {
                int minWidth = this.mCompActDef.getChildrenGraphModel().getWidth() + 20;
                if (this.mSplitPane.getDividerLocation() < minWidth) {
                    this.mSplitPane.setDividerLocation(minWidth);
                }
            }
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            throw new InvalidOutcomeException(ex.getMessage());
        }
    }

    @Override
    public void setDescription(String description) throws InvalidSchemaException {
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.mLayoutButton.setEnabled(!readOnly);
        this.mLoadButton.setEnabled(!readOnly);
        this.mEditorPanel.setEditable(!readOnly);
        this.mPropertyPanel.setEditable(!readOnly);
    }

    @Override
    public JPanel getPanel() throws OutcomeNotInitialisedException {
        return this;
    }

    @Override
    public String getOutcome() throws OutcomeException {
        if (!this.mCompActDef.verify()) {
            throw new OutcomeException(this.mCompActDef.getErrors());
        }
        try {
            return Gateway.getMarshaller().marshall((Object)this.mCompActDef);
        }
        catch (Exception ex) {
            throw new OutcomeException(ex.getMessage());
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Composite Act Def Viewer");
        this.createLayout();
        this.createListeners();
        this.mPropertyPanel.setGraphModelManager(this.mEditorPanel.mGraphModelManager);
        this.setUpGraphEditor();
        this.revalidate();
        this.doLayout();
    }

    public VertexPropertyPanel loadPropertyPanel() {
        String wfPanelClass = Gateway.getProperties().getString("WfPropertyPanel");
        if (wfPanelClass != null) {
            try {
                return (VertexPropertyPanel)Gateway.getProperties().getInstance("WfPropertyPanel");
            }
            catch (Exception ex) {
                Logger.error((String)("Could not load wf props panel:" + wfPanelClass));
                Logger.error((Throwable)ex);
            }
        }
        return new VertexPropertyPanel(true);
    }

    @Override
    public boolean isUnsaved() {
        return this.unsaved;
    }

    @Override
    public void saved() {
        this.unsaved = false;
    }

    @Override
    public void export(File targetFile) throws Exception {
        File parentDir = targetFile.getParentFile();
        for (BuiltInResources res : BuiltInResources.values()) {
            FileStringUtility.createNewDir((String)(parentDir.getAbsolutePath() + "/" + res.getTypeCode()));
        }
        BufferedWriter imports = new BufferedWriter(new FileWriter(new File(parentDir, this.mCompActDef.getActName() + "Imports.xml")));
        this.mCompActDef.export((Writer)imports, targetFile.getParentFile());
        imports.close();
    }
}

