/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.instance;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.util.ArrayList;
import org.cristalise.gui.graph.view.VertexRenderer;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.utils.DateUtility;

public class ActivityRenderer
implements VertexRenderer {
    private Paint mActivePaint = new Color(100, 255, 100);
    private Paint mActiveCompPaint = new Color(100, 255, 255);
    private Paint mInactivePaint = new Color(255, 255, 255);
    private Paint mInactiveCompPaint = new Color(200, 200, 255);
    private Paint mErrorPaint = new Color(255, 50, 0);
    private Paint mTextPaint = Color.black;

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        Activity activity = (Activity)vertex;
        boolean active = activity.getActive();
        boolean hasError = !activity.verify();
        boolean isComposite = activity.getIsComposite();
        GraphPoint centrePoint = activity.getCentrePoint();
        ArrayList<String> linesOfText = new ArrayList<String>();
        String type = activity.getTypeName();
        if (type != null) {
            linesOfText.add("(" + type + ")");
        }
        linesOfText.add(activity.getName());
        if (hasError) {
            linesOfText.add(activity.getErrors());
        } else {
            String stateName = "Invalid State";
            try {
                stateName = activity.getStateName();
            }
            catch (InvalidDataException ex) {
                // empty catch block
            }
            linesOfText.add(stateName + " " + ActivityRenderer.getWaitTime(activity.getStateDate()));
        }
        FontMetrics metrics = g2d.getFontMetrics();
        int lineWidth = 0;
        int lineHeight = metrics.getHeight();
        int linesHeight = lineHeight * linesOfText.size();
        int linesStartY = centrePoint.y - linesHeight / 2 + lineHeight * 2 / 3;
        int x = 0;
        int y = 0;
        int i = 0;
        GraphPoint[] outline = vertex.getOutlinePoints();
        Paint actColour = hasError ? this.mErrorPaint : (active ? (isComposite ? this.mActiveCompPaint : this.mActivePaint) : (isComposite ? this.mInactiveCompPaint : this.mInactivePaint));
        g2d.setPaint(actColour);
        g2d.fill(ActivityRenderer.graphPointsToPolygon(outline));
        g2d.setPaint(this.mTextPaint);
        for (String line : linesOfText) {
            lineWidth = metrics.stringWidth(line);
            x = centrePoint.x - lineWidth / 2;
            y = linesStartY + i++ * lineHeight;
            g2d.drawString(line, x, y);
        }
    }

    private static Polygon graphPointsToPolygon(GraphPoint[] points) {
        Polygon polygon = new Polygon();
        int i = 0;
        for (i = 0; i < points.length; ++i) {
            polygon.addPoint(points[i].x, points[i].y);
        }
        return polygon;
    }

    private static String getWaitTime(GTimeStamp date) {
        GTimeStamp now = new GTimeStamp();
        DateUtility.setToNow((GTimeStamp)now);
        long diff = DateUtility.diff((GTimeStamp)now, (GTimeStamp)date);
        long secondes = diff % 60L;
        long minutes = diff / 60L % 60L;
        long hours = diff / 3600L % 24L;
        long days = diff / 3600L / 24L;
        if (days > 0L) {
            return days + " " + "d" + " " + hours + " " + "h";
        }
        if (hours > 0L) {
            return hours + " " + "h" + " " + minutes + " " + "min";
        }
        if (minutes > 0L) {
            return minutes + " " + "min";
        }
        return secondes + " " + "sec";
    }
}

