/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.instance;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.graph.view.SelectedVertexPanel;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tabs.execution.Executor;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.utils.Logger;

public class TransitionPanel
extends SelectedVertexPanel
implements ActionListener {
    protected Activity mCurrentAct;
    protected GridBagLayout gridbag;
    protected GridBagConstraints c;
    protected Box transBox;
    protected JComboBox executors;
    protected JComboBox states = new JComboBox();
    protected JCheckBox active = new JCheckBox();
    protected JLabel status = new JLabel();
    protected ItemProxy mItem;

    public TransitionPanel() {
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        JLabel title = new JLabel("Available Transitions");
        title.setFont(ItemTabPane.titleFont);
        this.gridbag.setConstraints(title, this.c);
        this.add(title);
        ++this.c.gridy;
        this.gridbag.setConstraints(this.status, this.c);
        this.add(this.status);
        ++this.c.gridy;
        this.transBox = Box.createHorizontalBox();
        this.gridbag.setConstraints(this.transBox, this.c);
        this.add(this.transBox);
        this.c.weightx = 0.0;
        ++this.c.gridx;
        this.executors = MainFrame.getExecutionPlugins();
        if (this.executors.getItemCount() > 1) {
            this.gridbag.setConstraints(this.executors, this.c);
            this.add(this.executors);
        }
        if (MainFrame.isAdmin) {
            this.c.gridx = 0;
            ++this.c.gridy;
            title = new JLabel("State Hacking");
            title.setFont(ItemTabPane.titleFont);
            this.gridbag.setConstraints(title, this.c);
            this.add(title);
            Box hackBox = Box.createHorizontalBox();
            hackBox.add(this.states);
            hackBox.add(Box.createHorizontalGlue());
            hackBox.add(new JLabel("Active:"));
            hackBox.add(this.active);
            ++this.c.gridy;
            this.gridbag.setConstraints(hackBox, this.c);
            this.add(hackBox);
            this.states.addActionListener(this);
            this.active.addActionListener(this);
        }
        this.clear();
    }

    @Override
    public void select(Vertex vert) {
        Map transitions;
        int currentState;
        StateMachine sm;
        this.clear();
        if (!(vert instanceof Activity)) {
            return;
        }
        this.mCurrentAct = (Activity)vert;
        try {
            sm = this.mCurrentAct.getStateMachine();
        }
        catch (InvalidDataException e) {
            this.status.setText("Invalid state machine.");
            Logger.error((Throwable)e);
            return;
        }
        this.states.removeAllItems();
        try {
            currentState = this.mCurrentAct.getState();
        }
        catch (InvalidDataException e) {
            this.status.setText("Could not find activity state");
            Logger.error((Throwable)e);
            return;
        }
        for (State thisState : sm.getStates()) {
            this.states.addItem(thisState);
            if (currentState != thisState.getId()) continue;
            this.states.setSelectedItem(thisState);
        }
        this.states.setEnabled(true);
        this.active.setSelected(this.mCurrentAct.active);
        this.active.setEnabled(true);
        Logger.msg((int)1, (String)("Retrieving possible transitions for activity " + this.mCurrentAct.getName()));
        try {
            transitions = this.mCurrentAct.getStateMachine().getPossibleTransitions(this.mCurrentAct, MainFrame.userAgent.getPath());
        }
        catch (Exception e) {
            this.status.setText("Error loading possible transitions of activity. See log.");
            Logger.error((Throwable)e);
            return;
        }
        if (transitions.size() == 0) {
            this.status.setText("None");
            return;
        }
        for (Transition trans : transitions.keySet()) {
            boolean hasOutcome = trans.hasOutcome(this.mCurrentAct.getProperties());
            if (!hasOutcome || hasOutcome && !trans.getOutcome().isRequired()) {
                JButton thisTrans = new JButton(trans.getName());
                thisTrans.setActionCommand("Trans:" + trans.getId());
                thisTrans.addActionListener(this);
                this.transBox.add(thisTrans);
                this.transBox.add(Box.createHorizontalGlue());
            }
            this.status.setText(transitions.size() + " transitions possible.");
        }
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.active.isEnabled() && e.getSource() == this.active && this.mCurrentAct != null) {
            this.mCurrentAct.active = this.active.isSelected();
            return;
        }
        if (this.states.isEnabled() && e.getSource() == this.states && this.mCurrentAct != null) {
            Logger.msg((int)1, (String)("Setting state of " + this.mCurrentAct.getName() + " to " + this.states.getSelectedItem()));
            this.mCurrentAct.setState(this.states.getSelectedIndex());
            return;
        }
        if (!e.getActionCommand().startsWith("Trans:")) {
            return;
        }
        int transition = Integer.parseInt(e.getActionCommand().substring(6));
        Logger.msg((String)("Requesting transition " + transition));
        try {
            StateMachine actSM = this.mCurrentAct.getStateMachine();
            Job thisJob = new Job(this.mCurrentAct, this.mItem.getPath(), actSM.getTransition(transition), MainFrame.userAgent.getPath(), null, "Admin");
            Executor selectedExecutor = (Executor)this.executors.getSelectedItem();
            selectedExecutor.execute(thisJob, this.status);
        }
        catch (Exception ex) {
            String className = ex.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            Logger.error((Throwable)ex);
            JOptionPane.showMessageDialog(null, ex.getMessage(), className, 0);
        }
    }

    @Override
    public void clear() {
        this.states.setEnabled(false);
        this.active.setEnabled(false);
        this.mCurrentAct = null;
        this.transBox.removeAll();
        this.status.setText("No activity selected");
        this.active.setSelected(false);
        this.revalidate();
    }

    public void setItem(ItemProxy item) {
        this.mItem = item;
    }
}

