/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class HistoryPane
extends ItemTabPane
implements ActionListener,
ProxyObserver<Event> {
    History history;
    HistoryTableModel model;
    JTable eventTable;
    JButton startButton = new JButton("<<");
    JButton prevButton = new JButton("<");
    JButton nextButton = new JButton(">");
    JButton endButton = new JButton(">>");
    public static final int SIZE = 30;
    int currentSize = 30;

    public HistoryPane() {
        super("History", "Event History");
        this.initPanel();
        Box navBox = Box.createHorizontalBox();
        navBox.add(this.startButton);
        navBox.add(this.prevButton);
        navBox.add(this.nextButton);
        navBox.add(this.endButton);
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.prevButton.setActionCommand("prev");
        this.prevButton.addActionListener(this);
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        this.endButton.setActionCommand("end");
        this.endButton.addActionListener(this);
        this.add(navBox);
        this.eventTable = new JTable();
        JScrollPane eventScroll = new JScrollPane(this.eventTable);
        this.add(eventScroll);
        this.eventTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Event selected;
                if (e.getClickCount() == 2 && (selected = HistoryPane.this.model.getEventForRow(HistoryPane.this.eventTable.getSelectedRow())).getSchemaName() != null && selected.getViewName() != null) {
                    HistoryPane.this.parent.runCommand("Data Viewer", selected.getSchemaName() + ":" + selected.getViewName());
                }
            }
        });
    }

    @Override
    public void reload() {
        this.history.clear();
        this.jumpToEnd();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("History Pane Builder");
        MainFrame.progress.startBouncing("Loading history");
        try {
            this.history = (History)this.sourceItem.getItem().getObject("AuditTrail");
            this.history.activate();
            this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, "AuditTrail", false));
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
        }
        this.model = new HistoryTableModel();
        this.eventTable.setModel(this.model);
        this.jumpToEnd();
    }

    public void jumpToEnd() {
        int lastEvent = this.history.getLastId();
        int firstEvent = 0;
        this.currentSize = 30;
        if (lastEvent > this.currentSize) {
            firstEvent = lastEvent - this.currentSize + 1;
        }
        if (lastEvent < this.currentSize) {
            this.currentSize = lastEvent + 1;
        }
        Logger.msg((int)5, (String)("HistoryPane.run() - init table start " + firstEvent + " for " + this.currentSize));
        this.model.setView(firstEvent, this.currentSize);
        MainFrame.progress.stopBouncing("History loaded");
    }

    public void add(Event contents) {
        this.jumpToEnd();
    }

    public void remove(String id) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("end")) {
            this.jumpToEnd();
            return;
        }
        int lastEvent = this.history.getLastId();
        int startEvent = this.model.getStartId();
        if (e.getActionCommand().equals("start")) {
            this.currentSize = 30;
            startEvent = 0;
        } else if (e.getActionCommand().equals("prev")) {
            this.currentSize = 30;
            if ((startEvent -= this.currentSize) < 0) {
                startEvent = 0;
            }
        } else if (e.getActionCommand().equals("next")) {
            this.currentSize = 30;
            if ((startEvent += this.currentSize) > lastEvent) {
                startEvent = lastEvent - this.currentSize + 1;
            }
        } else {
            return;
        }
        this.model.setView(startEvent, this.currentSize);
    }

    public void control(String control, String msg) {
        if (control.equals("theEND")) {
            MainFrame.progress.stopBouncing("History loading complete.");
        } else {
            MainFrame.progress.stopBouncing("History: " + msg);
        }
    }

    private class HistoryTableModel
    extends AbstractTableModel {
        Event[] event = new Event[0];
        StateMachine[] sm;
        Integer[] ids = new Integer[0];
        int loaded = 0;
        int startId = 0;

        public int getStartId() {
            return this.startId;
        }

        public void setView(int startId, int size) {
            this.event = new Event[size];
            this.ids = new Integer[size];
            this.sm = new StateMachine[size];
            this.startId = startId;
            for (int i = 0; i < size; ++i) {
                this.event[i] = HistoryPane.this.history.getEvent(startId + i);
                try {
                    this.sm[i] = LocalObjectLoader.getStateMachine((String)this.event[i].getStateMachineName(), (int)this.event[i].getStateMachineVersion());
                }
                catch (Exception ex) {
                    Logger.error((Throwable)ex);
                }
                this.ids[i] = new Integer(startId + i);
                this.loaded = i + 1;
            }
            this.fireTableStructureChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "Activity";
                }
                case 2: {
                    return "Transition";
                }
                case 3: {
                    return "Date";
                }
                case 4: {
                    return "Agent Name";
                }
                case 5: {
                    return "Agent Role";
                }
                case 6: {
                    return "Schema";
                }
                case 7: {
                    return "View";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.loaded;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.event.length <= rowIndex || this.event[rowIndex] == null) {
                return "";
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return this.ids[rowIndex];
                    }
                    case 1: {
                        return this.event[rowIndex].getStepName();
                    }
                    case 2: {
                        return this.sm[rowIndex] == null ? "Unknown" : this.sm[rowIndex].getTransition(this.event[rowIndex].getTransition()).getName();
                    }
                    case 3: {
                        return this.event[rowIndex].getTimeString();
                    }
                    case 4: {
                        return this.event[rowIndex].getAgentPath().getAgentName();
                    }
                    case 5: {
                        return this.event[rowIndex].getAgentRole();
                    }
                    case 6: {
                        String schId = this.event[rowIndex].getSchemaName();
                        if (schId != null && !schId.isEmpty()) {
                            Schema evSch = LocalObjectLoader.getSchema((String)schId, (int)this.event[rowIndex].getSchemaVersion());
                            return evSch.getName() + " v" + this.event[rowIndex].getSchemaVersion();
                        }
                        return null;
                    }
                    case 7: {
                        return this.event[rowIndex].getViewName();
                    }
                }
                return "";
            }
            catch (Exception e) {
                return null;
            }
        }

        public Event getEventForRow(int rowIndex) {
            return this.event[rowIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

