/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.DomainPathAdmin;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tabs.RoleAdmin;
import org.cristalise.gui.tree.NodeAgent;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;

public class PropertiesPane
extends ItemTabPane
implements ProxyObserver<Property>,
ActionListener {
    Box propertyBox;
    JButton eraseButton;
    boolean subbed = false;
    HashMap<String, JLabel> loadedProps = new HashMap();
    DomainPathAdmin domAdmin;
    JLabel roleTitle;
    RoleAdmin roleAdmin = null;

    public PropertiesPane() {
        super("Properties", "Properties");
        this.initPanel();
        this.propertyBox = Box.createVerticalBox();
        this.add(this.propertyBox);
        this.addGlue();
        if (MainFrame.isAdmin) {
            this.roleTitle = this.getTitle("Roles");
            this.roleAdmin = new RoleAdmin();
            this.roleTitle.setVisible(false);
            this.roleAdmin.setVisible(false);
            this.addTitle(this.roleTitle);
            this.add(this.roleAdmin);
            this.addTitle(this.getTitle("Domain Paths"));
            this.add(Box.createVerticalStrut(5));
            this.domAdmin = new DomainPathAdmin();
            this.add(this.domAdmin);
            if (Gateway.getProperties().getBoolean("EnableItemErase")) {
                this.addGlue();
                Box eraseBox = Box.createHorizontalBox();
                eraseBox.add(Box.createHorizontalGlue());
                this.eraseButton = new JButton("Erase!");
                this.eraseButton.addActionListener(this);
                this.eraseButton.setAlignmentX(1.0f);
                this.eraseButton.setBackground(Color.RED);
                eraseBox.add(this.eraseButton);
                this.add(eraseBox);
            }
            this.addGlue();
        }
    }

    @Override
    public void reload() {
        Gateway.getStorage().clearCache(this.sourceItem.getItemPath(), "Property");
        this.loadedProps = new HashMap();
        this.initForItem(this.sourceItem);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Property Pane Builder");
        if (this.sourceItem instanceof NodeAgent && this.roleAdmin != null) {
            this.roleAdmin.setEntity((AgentProxy)this.sourceItem.getItem());
            this.roleTitle.setVisible(true);
            this.roleAdmin.setVisible(true);
        }
        if (this.domAdmin != null) {
            this.domAdmin.setEntity(this.sourceItem.getItem());
        }
        this.propertyBox.removeAll();
        this.revalidate();
        this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, "Property", true));
    }

    public void add(Property newProp) {
        JLabel propLabel = this.loadedProps.get(newProp.getName());
        if (propLabel == null) {
            JPanel summaryPanel = new JPanel(new GridLayout(0, 2));
            summaryPanel.add(new JLabel(newProp.getName() + ":"));
            Box valueBox = Box.createHorizontalBox();
            propLabel = new JLabel(newProp.getValue());
            this.loadedProps.put(newProp.getName(), propLabel);
            valueBox.add(propLabel);
            if (MainFrame.isAdmin && newProp.isMutable()) {
                JButton editButton = new JButton("...");
                editButton.setMargin(new Insets(0, 0, 0, 0));
                editButton.setActionCommand(newProp.getName());
                editButton.addActionListener(this);
                valueBox.add(Box.createHorizontalStrut(7));
                valueBox.add(editButton);
                valueBox.add(Box.createHorizontalGlue());
            }
            summaryPanel.add(valueBox);
            this.propertyBox.add(Box.createVerticalStrut(7));
            this.propertyBox.add(summaryPanel);
        }
        propLabel.setText(newProp.getValue());
        this.revalidate();
    }

    public void remove(String id) {
        String propName = id.substring(id.lastIndexOf("/") + 1);
        JLabel propbox = this.loadedProps.get(propName);
        if (propbox != null) {
            propbox.setText("[DELETED]");
        }
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.eraseButton) {
            try {
                if (JOptionPane.showConfirmDialog(this, "Are you sure?", "Erase Item", 0) != 0) {
                    return;
                }
                String predefStep = this.sourceItem instanceof NodeAgent ? "RemoveAgent" : "Erase";
                MainFrame.userAgent.execute(this.sourceItem.getItem(), predefStep, new String[0]);
            }
            catch (Exception ex) {
                MainFrame.exceptionDialog(ex);
            }
        } else {
            String oldVal = this.loadedProps.get(e.getActionCommand()).getText();
            String newVal = (String)JOptionPane.showInputDialog(null, "Enter new value for " + e.getActionCommand(), "Edit Property", 3, null, null, oldVal);
            if (newVal != null && !newVal.equals(oldVal)) {
                try {
                    this.sourceItem.getItem().setProperty(MainFrame.userAgent, e.getActionCommand(), newVal);
                }
                catch (Exception ex) {
                    MainFrame.exceptionDialog(ex);
                }
            }
        }
    }

    public void control(String control, String msg) {
    }
}

