/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tabs.JFixedHeightComboBox;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.OutcomeHandler;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.utils.Logger;

public class ViewpointPane
extends ItemTabPane
implements ItemListener,
ActionListener,
ProxyObserver<C2KLocalObject> {
    JComboBox<String> schemas;
    JComboBox<Viewpoint> views;
    JComboBox<EventItem> events;
    JLabel eventDetails;
    JButton exportButton;
    JButton viewButton;
    ArrayList<String> schemaList;
    ArrayList<Viewpoint> viewpointList;
    ArrayList<EventItem> eventList;
    String currentSchema = null;
    Outcome currentOutcome = null;
    OutcomeHandler thisOutcome;
    boolean suspendSelection = false;
    JPanel dataView = new JPanel(new GridLayout(1, 1));

    public ViewpointPane() {
        super("Data Viewer", "Outcome Browser");
        this.initialize();
    }

    public void initialize() {
        this.initPanel();
        Box viewBox = Box.createHorizontalBox();
        JLabel label = new JLabel("Outcome Type:", 2);
        viewBox.add(label);
        viewBox.add(Box.createHorizontalStrut(7));
        this.schemas = new JFixedHeightComboBox<String>();
        viewBox.add(this.schemas);
        viewBox.add(Box.createHorizontalGlue());
        this.schemas.addItemListener(this);
        label = new JLabel("View:", 2);
        viewBox.add(label);
        viewBox.add(Box.createHorizontalStrut(7));
        this.views = new JFixedHeightComboBox<Viewpoint>();
        viewBox.add(this.views);
        viewBox.add(Box.createHorizontalGlue());
        this.views.addItemListener(this);
        viewBox.setMaximumSize(this.views.getMaximumSize());
        this.add(viewBox);
        Box eventBox = Box.createHorizontalBox();
        label = new JLabel("Event:", 2);
        eventBox.add(label);
        eventBox.add(Box.createHorizontalStrut(7));
        this.events = new JFixedHeightComboBox<EventItem>();
        eventBox.add(this.events);
        eventBox.add(Box.createHorizontalStrut(7));
        this.events.addItemListener(this);
        this.eventDetails = new JLabel();
        eventBox.add(this.eventDetails);
        eventBox.add(Box.createHorizontalGlue());
        if (MainFrame.isAdmin) {
            this.viewButton = new JButton("Write View");
            this.viewButton.setMargin(new Insets(0, 0, 0, 0));
            this.viewButton.setActionCommand("setview");
            eventBox.add(this.viewButton);
            eventBox.add(Box.createHorizontalStrut(14));
            this.viewButton.addActionListener(this);
        }
        this.exportButton = new JButton("Export");
        this.exportButton.setMargin(new Insets(0, 0, 0, 0));
        this.exportButton.setActionCommand("export");
        this.exportButton.addActionListener(this);
        eventBox.add(this.exportButton);
        eventBox.setMaximumSize(this.events.getMaximumSize());
        this.add(eventBox);
        this.add(Box.createVerticalStrut(5));
        this.add(this.dataView);
    }

    @Override
    public void reload() {
        this.schemas.removeAllItems();
        this.views.removeAllItems();
        this.events.removeAllItems();
        this.eventDetails.setText("");
        this.clearView();
        this.initForItem(this.sourceItem);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Viewpoint Pane Builder");
        this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, "ViewPoint", false));
        this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, "Outcome", false));
        this.clearView();
        this.schemas.addItem("--");
        this.currentSchema = null;
        this.schemaList = new ArrayList();
        try {
            String outcomeTypes = this.sourceItem.getItem().queryData("ViewPoint/all");
            StringTokenizer tok = new StringTokenizer(outcomeTypes, ",");
            int nonSystemSchemas = 0;
            String defaultSelection = null;
            while (tok.hasMoreTokens()) {
                String thisType = tok.nextToken();
                this.schemas.addItem(thisType);
                this.schemaList.add(thisType);
                if (thisType.equals("PredefinedStepOutcome") || thisType.equals("ItemInitialization")) continue;
                ++nonSystemSchemas;
                defaultSelection = thisType;
            }
            if (nonSystemSchemas == 1) {
                this.schemas.setSelectedItem(defaultSelection);
            }
        }
        catch (Exception e) {
            Logger.msg((int)2, (String)"No viewpoints found");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object selectedItem = e.getItem();
        if (e.getStateChange() == 2) {
            return;
        }
        if (this.suspendSelection) {
            return;
        }
        if (e.getItem().equals("--")) {
            return;
        }
        if (e.getItemSelectable() == this.schemas) {
            this.switchSchema((String)selectedItem);
        } else if (e.getItemSelectable() == this.views) {
            this.switchView((Viewpoint)selectedItem);
        } else if (e.getItemSelectable() == this.events) {
            this.showEvent((EventItem)selectedItem);
        }
    }

    public void switchSchema(String schemaName) {
        this.clearView();
        this.suspendSelection = true;
        this.views.removeAllItems();
        this.events.removeAllItems();
        this.viewpointList = new ArrayList();
        this.eventList = new ArrayList();
        this.currentSchema = schemaName;
        try {
            String viewNames = this.sourceItem.getItem().queryData("ViewPoint/" + schemaName + "/all");
            StringTokenizer tok = new StringTokenizer(viewNames, ",");
            Viewpoint lastView = null;
            while (tok.hasMoreTokens()) {
                String viewName = tok.nextToken();
                Viewpoint thisView = (Viewpoint)this.sourceItem.getItem().getObject("ViewPoint/" + schemaName + "/" + viewName);
                this.views.addItem(thisView);
                if (lastView == null) {
                    lastView = thisView;
                }
                if (thisView.getName().equals("last")) {
                    lastView = thisView;
                }
                this.viewpointList.add(thisView);
            }
            String ocVersions = this.sourceItem.getItem().queryData("Outcome/" + schemaName + "/all");
            tok = new StringTokenizer(ocVersions, ",");
            while (tok.hasMoreTokens()) {
                int schemaVersion = Integer.parseInt(tok.nextToken());
                String ocEvents = this.sourceItem.getItem().queryData("Outcome/" + schemaName + "/" + schemaVersion + "/all");
                StringTokenizer tok2 = new StringTokenizer(ocEvents, ",");
                while (tok2.hasMoreTokens()) {
                    int eventId = Integer.parseInt(tok2.nextToken());
                    EventItem newEvent = new EventItem(eventId, schemaVersion);
                    for (Viewpoint thisView : this.viewpointList) {
                        if (thisView.getEventId() != eventId) continue;
                        newEvent.addView(thisView.getName());
                    }
                    this.eventList.add(newEvent);
                }
                Collections.sort(this.eventList, new Comparator<EventItem>(){

                    @Override
                    public int compare(EventItem o1, EventItem o2) {
                        return o1.compareTo(o2);
                    }
                });
                for (EventItem eventItem : this.eventList) {
                    this.events.addItem(eventItem);
                }
            }
            if (lastView != null) {
                this.suspendSelection = false;
                this.views.setSelectedItem(lastView);
                this.switchView(lastView);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            JOptionPane.showMessageDialog(this, "The data structures of this item are incorrect.\nPlease contact your administrator.", "Viewpoint Error", 0);
        }
        this.suspendSelection = false;
    }

    public void switchView(Viewpoint newView) {
        for (EventItem thisEvent : this.eventList) {
            if (thisEvent.eventId != newView.getEventId()) continue;
            this.suspendSelection = true;
            this.events.setSelectedItem(thisEvent);
            this.showEvent(thisEvent);
            this.suspendSelection = false;
            break;
        }
    }

    public void showEvent(EventItem thisEvent) {
        this.eventDetails.setText(thisEvent.getEventDesc());
        try {
            this.setView((Outcome)this.sourceItem.getItem().getObject("Outcome/" + this.currentSchema + "/" + thisEvent.schemaVersion + "/" + thisEvent.eventId));
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            JOptionPane.showMessageDialog(this, "Could not retrieve requested outcome.\nPlease contact your administrator.", "Viewpoint Error", 0);
        }
    }

    public void setView(Outcome data) {
        Logger.msg((int)6, (String)("ViewpointPane: got outcome type: " + data.getSchema().getName() + " version: " + data.getSchema().getVersion()));
        this.currentOutcome = data;
        this.dataView.removeAll();
        String error = null;
        try {
            Schema schema = data.getSchema();
            this.thisOutcome = ItemTabPane.getOutcomeHandler(schema.getName(), schema.getVersion());
            this.thisOutcome.setDescription(schema.getSchemaData());
            this.thisOutcome.setOutcome(data.getData());
            this.thisOutcome.setReadOnly(true);
            Thread builder = new Thread(this.thisOutcome);
            builder.start();
            this.dataView.add(this.thisOutcome.getPanel());
            this.exportButton.setEnabled(true);
            if (this.viewButton != null) {
                this.viewButton.setEnabled(true);
            }
            return;
        }
        catch (OutcomeException ex) {
            error = "Outcome was not valid. See log for details: " + ex.getMessage();
            Logger.error((Throwable)ex);
            this.dataView.add(new JLabel(error));
            return;
        }
    }

    public void clearView() {
        this.dataView.removeAll();
        this.exportButton.setEnabled(false);
        if (this.viewButton != null) {
            this.viewButton.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("export") && this.currentOutcome != null) {
            this.saveOutcomeToFile();
        }
        if (e.getActionCommand().equals("setview") && this.currentOutcome != null) {
            this.overrideView();
        }
    }

    private void saveOutcomeToFile() {
        MainFrame.xmlChooser.setSelectedFile(new File(this.currentOutcome.getSchema().getName() + ".xml"));
        int returnVal = MainFrame.xmlChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File targetFile = MainFrame.xmlChooser.getSelectedFile();
            if (!targetFile.getAbsolutePath().endsWith(".xml")) {
                targetFile = new File(targetFile.getAbsolutePath() + ".xml");
            }
            Logger.msg((int)2, (String)("ViewpointPane.actionPerformed() - Exporting outcome to file " + targetFile.getName()));
            try {
                this.thisOutcome.export(targetFile);
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
                MainFrame.exceptionDialog(ex);
            }
        }
    }

    private void overrideView() {
        Viewpoint oldView = (Viewpoint)this.views.getSelectedItem();
        EventItem newEvent = (EventItem)this.events.getSelectedItem();
        if (oldView.getEventId() == newEvent.eventId) {
            JOptionPane.showMessageDialog(this, "View '" + oldView.getName() + "' is already set to event " + newEvent.eventId, "Viewpoint Already Set", 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to set the '" + oldView.getName() + "' view to event " + newEvent.eventId + "?", "Overwrite view", 0) != 0) {
            return;
        }
        try {
            String[] predefParams = new String[]{oldView.getSchemaName(), oldView.getName(), String.valueOf(newEvent.eventId)};
            MainFrame.userAgent.execute(this.sourceItem.getItem(), "WriteViewpoint", predefParams);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            MainFrame.exceptionDialog(e);
        }
    }

    @Override
    public void runCommand(String command) {
        String[] viewElements = command.split(":");
        if (viewElements.length != 2) {
            return;
        }
        if (this.schemaList == null) {
            this.run();
        }
        this.schemas.setSelectedItem(viewElements[0]);
        for (Viewpoint thisView : this.viewpointList) {
            if (!thisView.getName().equals(viewElements[1])) continue;
            this.switchView(thisView);
            return;
        }
        Logger.error((String)("Viewpoint " + command + " not found in this item"));
    }

    public void add(C2KLocalObject contents) {
        if (contents instanceof Viewpoint) {
            this.addViewpoint((Viewpoint)contents);
        } else if (contents instanceof Outcome) {
            this.addOutcome((Outcome)contents);
        }
    }

    public void addViewpoint(Viewpoint newView) {
        String schemaName = newView.getSchemaName();
        Logger.msg((int)3, (String)("Viewpoint " + newView.getName() + " now points to " + newView.getEventId()));
        if (!this.schemaList.contains(schemaName)) {
            this.schemaList.add(schemaName);
            this.schemas.addItem(schemaName);
            return;
        }
        if (!schemaName.equals(this.schemas.getSelectedItem())) {
            return;
        }
        for (EventItem thisEvent : this.eventList) {
            if (thisEvent.eventId == newView.getEventId()) {
                thisEvent.addView(newView.getName());
                continue;
            }
            thisEvent.removeView(newView.getName());
        }
        boolean isSelected = false;
        for (Viewpoint thisView : this.viewpointList) {
            if (!thisView.getName().equals(newView.getName())) continue;
            isSelected = thisView.equals(this.views.getSelectedItem());
            this.views.removeItem(thisView);
            this.viewpointList.remove(thisView);
            break;
        }
        this.views.addItem(newView);
        this.viewpointList.add(newView);
        if (isSelected) {
            this.views.setSelectedItem(newView);
        }
    }

    public void addOutcome(Outcome contents) {
        if (!contents.getSchema().getName().equals(this.currentSchema)) {
            return;
        }
        Logger.msg((int)3, (String)("Adding event " + contents.getID()));
        EventItem newEvent = new EventItem(contents.getID(), contents.getSchema().getVersion());
        this.eventList.add(newEvent);
        this.events.addItem(newEvent);
    }

    public void remove(String id) {
    }

    public void control(String control, String msg) {
    }

    class EventItem
    implements Comparable<EventItem> {
        public int eventId;
        public int schemaVersion;
        public ArrayList<String> viewNames = new ArrayList();
        public String viewList = "";

        public EventItem(int eventId, int schemaVersion) {
            this.eventId = eventId;
            this.schemaVersion = schemaVersion;
        }

        public void addView(String viewName) {
            if (!this.viewNames.contains(viewName)) {
                this.viewNames.add(viewName);
                this.buildViewLabel();
            }
        }

        public void removeView(String viewName) {
            this.viewNames.remove(viewName);
            this.buildViewLabel();
        }

        private void buildViewLabel() {
            if (this.viewNames.size() == 0) {
                this.viewList = "";
                return;
            }
            StringBuffer newLabel = new StringBuffer(" (");
            Iterator<String> iter = this.viewNames.iterator();
            while (iter.hasNext()) {
                String viewName = iter.next();
                newLabel.append(viewName);
                if (!iter.hasNext()) continue;
                newLabel.append(", ");
            }
            this.viewList = newLabel.append(")").toString();
        }

        public String toString() {
            return this.eventId + this.viewList;
        }

        public String getEventDesc() {
            try {
                Event myEvent = (Event)ViewpointPane.this.sourceItem.getItem().getObject("AuditTrail/" + this.eventId);
                return "Recorded on " + myEvent.getTimeString() + " by " + myEvent.getAgentPath().getAgentName() + " using schema v" + this.schemaVersion;
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
                return "Error retrieving event details";
            }
        }

        @Override
        public int compareTo(EventItem other) {
            if (other.eventId < this.eventId) {
                return 1;
            }
            if (other.eventId > this.eventId) {
                return -1;
            }
            return 0;
        }
    }
}

