/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.graph.controller.Selection;
import org.cristalise.gui.graph.view.EditorPanel;
import org.cristalise.gui.graph.view.VertexPropertyPanel;
import org.cristalise.gui.lifecycle.instance.TransitionPanel;
import org.cristalise.gui.lifecycle.instance.WfDirectedEdgeRenderer;
import org.cristalise.gui.lifecycle.instance.WfEdgeFactory;
import org.cristalise.gui.lifecycle.instance.WfGraphPanel;
import org.cristalise.gui.lifecycle.instance.WfVertexFactory;
import org.cristalise.gui.lifecycle.instance.WfVertexRenderer;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.graph.layout.DefaultGraphLayoutGenerator;
import org.cristalise.kernel.graph.model.EdgeFactory;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.VertexFactory;
import org.cristalise.kernel.graph.model.VertexOutlineCreator;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.WfVertexOutlineCreator;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class WorkflowPane
extends ItemTabPane
implements ProxyObserver<Workflow> {
    protected Workflow mWorkflow = null;
    boolean init = false;
    TransitionPanel transPanel;
    protected JButton mLoadButton = new JButton(ImageLoader.findImage("graph/load.png"));
    protected JButton mSaveButton = new JButton(ImageLoader.findImage("graph/save.png"));
    protected JButton mLayoutButton = new JButton(ImageLoader.findImage("graph/autolayout.png"));
    protected JButton mZoomOutButton = new JButton(ImageLoader.findImage("graph/zoomout.png"));
    protected JButton[] mOtherToolBarButtons;
    protected EdgeFactory mWfEdgeFactory = new WfEdgeFactory();
    protected VertexFactory mWfVertexFactory = new WfVertexFactory();
    protected EditorPanel mEditorPanel;
    protected VertexPropertyPanel mPropertyPanel;
    protected JSplitPane mSplitPane;

    public WorkflowPane() {
        super("Workflow", "Workflow Viewer");
        this.mZoomOutButton.setToolTipText("Zoom Out");
        this.mLayoutButton.setToolTipText("Auto Layout");
        this.mLoadButton.setToolTipText("Load");
        this.mSaveButton.setToolTipText("Save");
        this.mOtherToolBarButtons = new JButton[]{this.mZoomOutButton, this.mLayoutButton, this.mLoadButton, this.mSaveButton};
    }

    protected void createListeners() {
        this.mLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WorkflowPane.this.loadWorkflow();
            }
        });
        this.mSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WorkflowPane.this.setCursor(new Cursor(3));
                WorkflowPane.this.saveWorkflow();
                WorkflowPane.this.setCursor(new Cursor(0));
            }
        });
        this.mLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultGraphLayoutGenerator.layoutGraph((GraphModel)WorkflowPane.this.mEditorPanel.mGraphModelManager.getModel());
            }
        });
        this.mZoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WorkflowPane.this.mEditorPanel.mGraphModelManager.zoomOut();
            }
        });
    }

    public EditorPanel getEditorPanel() {
        if (this.mEditorPanel == null) {
            this.mEditorPanel = new EditorPanel(this.mWfEdgeFactory, this.mWfVertexFactory, (VertexOutlineCreator)new WfVertexOutlineCreator(), true, this.mOtherToolBarButtons, new WfGraphPanel(new WfDirectedEdgeRenderer(), new WfVertexRenderer()));
        }
        return this.mEditorPanel;
    }

    public JSplitPane getJSplitPane() {
        if (this.mSplitPane == null) {
            this.mSplitPane = new JSplitPane(1, this.getEditorPanel(), this.getPropertyPanel());
            this.mSplitPane.setDividerSize(5);
            if (this.mWorkflow != null) {
                CompositeActivity domain = (CompositeActivity)this.mWorkflow.search("workflow/domain");
                int minWidth = domain.getChildrenGraphModel().getWidth() + 20;
                if (this.mSplitPane.getDividerLocation() < minWidth) {
                    this.mSplitPane.setDividerLocation(minWidth);
                }
            }
        }
        return this.mSplitPane;
    }

    public void add(Workflow contents) {
        this.mWorkflow = contents;
        CompositeActivity domain = (CompositeActivity)this.mWorkflow.search("workflow/domain");
        this.addActivity(domain);
        if (this.mSplitPane != null) {
            int minWidth = domain.getChildrenGraphModel().getWidth() + 20;
            if (this.mSplitPane.getDividerLocation() < minWidth) {
                this.mSplitPane.setDividerLocation(minWidth);
            }
        }
    }

    public void remove(String id) {
    }

    protected void addActivity(CompositeActivity cAct) {
        this.mEditorPanel.mGraphModelManager.replace(cAct.getChildrenGraphModel());
        this.mEditorPanel.updateVertexTypes(cAct.getWf().getVertexTypeNameAndConstructionInfo());
        this.mEditorPanel.updateEdgeTypes(cAct.getWf().getEdgeTypeNameAndConstructionInfo());
        this.mEditorPanel.enterSelectMode();
        this.mWfVertexFactory.setCreationContext((Object)cAct);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Workflow Pane Builder");
        if (!this.init) {
            this.createLayout();
            this.createListeners();
            this.mPropertyPanel.setGraphModelManager(this.mEditorPanel.mGraphModelManager);
            this.mEditorPanel.setEditable(MainFrame.isAdmin);
            this.init = true;
        }
        this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, "LifeCycle", true));
        this.transPanel.setItem(this.sourceItem.getItem());
    }

    @Override
    public void reload() {
        Gateway.getStorage().clearCache(this.sourceItem.getItemPath(), "LifeCycle");
        this.initForItem(this.sourceItem);
    }

    protected void createLayout() {
        this.initPanel();
        Box wfPane = Box.createHorizontalBox();
        wfPane.add(this.getJSplitPane());
        this.add(wfPane);
        this.validate();
    }

    protected void loadWorkflow() {
        File selectedFile = null;
        int returnValue = MainFrame.xmlChooser.showOpenDialog(null);
        switch (returnValue) {
            case 0: {
                selectedFile = MainFrame.xmlChooser.getSelectedFile();
                try {
                    String newWf = FileStringUtility.file2String((File)selectedFile);
                    this.add((Workflow)Gateway.getMarshaller().unmarshall(newWf));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void saveWorkflow() {
        try {
            CompositeActivity cact = (CompositeActivity)this.mWorkflow.getWf().search("workflow/domain");
            MainFrame.userAgent.execute(this.sourceItem.getItem(), "ReplaceDomainWorkflow", new String[]{Gateway.getMarshaller().marshall((Object)cact)});
            this.mEditorPanel.mGraphPanel.setSelection(new Selection(null, null, 0, 0, 0, 0));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public VertexPropertyPanel getPropertyPanel() {
        if (this.mPropertyPanel == null) {
            this.setNewPropertyPanel();
            this.transPanel = new TransitionPanel();
            this.mPropertyPanel.createLayout(this.transPanel);
            this.mPropertyPanel.setGraphModelManager(this.mEditorPanel.mGraphModelManager);
            this.mPropertyPanel.setEditable(MainFrame.isAdmin);
        }
        return this.mPropertyPanel;
    }

    public void setNewPropertyPanel() {
        String wfPanelClass = Gateway.getProperties().getProperty("WfPropertyPanel");
        if (wfPanelClass != null) {
            try {
                Class<?> panelClass = Class.forName(wfPanelClass);
                this.mPropertyPanel = (VertexPropertyPanel)panelClass.newInstance();
                return;
            }
            catch (Exception ex) {
                Logger.error((String)("Could not load wf props panel:" + wfPanelClass));
                Logger.error((Throwable)ex);
            }
        }
        this.mPropertyPanel = new VertexPropertyPanel(false);
    }

    public void control(String control, String msg) {
    }
}

