/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.collection;

import java.awt.GridLayout;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.TreeBrowser;
import org.cristalise.gui.tabs.collection.CollectionMemberPropertyPanel;
import org.cristalise.gui.tabs.collection.CollectionView;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeCollection;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.ObjectNotFoundException;

public class DependencyView
extends CollectionView<DependencyMember> {
    TreeBrowser tree;
    CollectionMemberPropertyPanel propPanel;
    JSplitPane split;

    public DependencyView() {
        this.setLayout(new GridLayout(1, 1));
        this.createLayout();
    }

    @Override
    public void setCollection(Collection<DependencyMember> contents) {
        this.thisColl = contents;
        NodeCollection collNode = new NodeCollection(this.item, this.thisColl.getName(), null);
        this.tree = new TreeBrowser(MainFrame.myDesktopManager, collNode);
        this.tree.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getPath() == null) {
                    DependencyView.this.propPanel.clear();
                } else {
                    Node selectedNode = (Node)((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
                    if (selectedNode instanceof NodeItem) {
                        NodeItem thisItem = (NodeItem)selectedNode;
                        if (thisItem.getParentCollection() != null) {
                            try {
                                DependencyView.this.propPanel.setMember(thisItem.getParentCollection().getMember(thisItem.getSlotNo().intValue()));
                                return;
                            }
                            catch (ObjectNotFoundException e1) {
                                // empty catch block
                            }
                        }
                        DependencyView.this.propPanel.clear();
                    }
                }
            }
        });
        this.split.setLeftComponent(this.tree);
    }

    public void createLayout() {
        this.propPanel = new CollectionMemberPropertyPanel();
        this.split = new JSplitPane(1);
        this.split.setRightComponent(this.propPanel);
        this.add(this.split);
    }
}

